#ifdef    FIXED_SOBJECT_LOCATION_TEST
#if 0
#include  <iostream>
#include  <cstdlib>
#include  "fixed_sobject_location.h"

using namespace std;

int    main( void )
{
	Fixed_SObject_Location_Translator	trans;
	D2_Vector				vec;

	string	obj = "(flag r t 30)";

	if ( ! trans.get_location( &vec , obj , S_Side_LR::Left_Side ) )
	{
		cerr << obj << ": No such soccer object." << endl;
		return( 1 );
	}
	else
	{
		cout << "x = " << vec.x() << ", y = " << vec.y() << endl;
	}

	return( 0 );
}
#else
#include  <iostream>
#include  <cstdlib>
#include  "fixed_sobject_location.h"

using namespace std;

int    main( void )
{
	Fixed_SObject_Location_Translator	trans;
	D2_Vector				vec;

	Lisp_Lexical_Object	obj( "(flag r t 30)" );

	if ( ! trans.get_location( &vec , obj.list[0] ,
				   S_Side_LR::Left_Side ) )
	{
		cerr << "No such soccer object." << endl;
		return( 1 );
	}
	else
	{
		cout << "x = " << vec.x() << ", y = " << vec.y() << endl;
	}

	return( 0 );
}
#endif
#endif // FIXED_SOBJECT_LOCATION_TEST


#include  "fixed_sobject_location.h"
#include  <cstdlib>
#include  <cmath>
#include  <cfloat>

using namespace std;

Fixed_SObject_Location_Translator::Fixed_SObject_Location_Translator()
{
	for( unsigned int i = 0  ;
	     i < (sizeof(flag_goal_location_table)
		  / sizeof(flag_goal_location_table[0]))  ;  i ++ )
	{
		Lisp_Lexical_Object	lisp_obj( flag_goal_location_table[i]
						  .obj_ident );

		D2_Vector	vec( D2_Vector::XY ,
				     flag_goal_location_table[i].vec[0] ,
				     flag_goal_location_table[i].vec[1] );

		if ( ! (   lisp_obj.list.size() == 1
			&& lisp_obj.list[0].type == Lisp_Lexical_Object::List
			&& lisp_obj.list[0].has_right_paren == true
			&& lisp_obj.list[0].list.size() <= MAX_OBJ_IDENT) )
		{
			cerr << "Internal Error "
				"in Fixed_SObject_Location_Translator" << endl;
			exit( 1 );
		}

		const Lisp_Lexical_Object &	lisp_list = lisp_obj.list[0];

		for ( size_t  check_sym = 0  ;
		      check_sym < lisp_list.list.size()  ;  check_sym ++ )
		{
			if ( ! (   lisp_list.list[check_sym].type
				     == Lisp_Lexical_Object::Symbol
				&& lisp_list.list[check_sym].symbol.size()
				     <= MAX_SYMBOL_LEN) )
			{
				cerr << "Internal Error "
					"in Fixed_SObject_Location_Translator"
				     << endl;
				exit( 1 );
			}
		}

		trans_lsp[ lisp_list ] = vec;
		trans_str[ flag_goal_location_table[i].obj_ident ] = vec;

		char	**tmp;
		tmp = new char *[MAX_OBJ_IDENT];
		for ( size_t  i = 0  ;  i < lisp_list.list.size() ;  i ++ )
		{
			tmp[i] = new char[MAX_SYMBOL_LEN + 1];
			strcpy( tmp[i] , lisp_list.list[i].symbol.c_str() );
		}

		pair<char **, size_t>	tmp_pair;
		tmp_pair.first  = tmp;
		tmp_pair.second = lisp_list.list.size();

		trans_str_array[ tmp_pair ] = vec;
	}
}


Fixed_SObject_Location_Translator::~Fixed_SObject_Location_Translator()
{
	for( map<pair<char **, size_t>, D2_Vector>::iterator  it
		     = trans_str_array.begin()  ;
	     it != trans_str_array.end()  ;  it ++ )
	{
		for ( size_t  i = 0  ;  i < (*it).first.second  ;  i ++ )
		{
			delete[] (*it).first.first[i];
		}

		delete[] (*it).first.first;
	}
}


bool   Fixed_SObject_Location_Translator::get_location(
			       D2_Vector *  vec ,
			       const Lisp_Lexical_Object &  obj ,
			       S_Side_LR  side )
{
	map<const Lisp_Lexical_Object, D2_Vector>::iterator	it;

	if ( side == S_Side_LR::Unknown
	  || (it = trans_lsp.find( obj )) == trans_lsp.end() )
	{
		vec -> set( D2_Vector::XY , 0.0 , 0.0 );

		return( false );
	}
	else
	{
		*vec = (*it).second;

		this -> side_trans( vec , side );

		return( true );
	}
}


bool   Fixed_SObject_Location_Translator::get_location(
					       D2_Vector *  vec ,
					       const string &  str_obj ,
					       S_Side_LR  side )
{
	map<string, D2_Vector>::iterator	it;

	if ( side == S_Side_LR::Unknown
	  || (it = trans_str.find( str_obj )) == trans_str.end() )
	{
		vec -> set( D2_Vector::XY , 0.0 , 0.0 );
		return( false );
	}
	else
	{
		*vec = (*it).second;

		this -> side_trans( vec , side );

		return( true );
	}
}


#include  <stdexcept>

bool  Fixed_SObject_Location_Translator::trans_str_array_less::
		operator()( pair<char **, size_t> a ,
			    pair<char **, size_t> b )
	const throw()
{
	if ( a.second != b.second )
	{
		return( a.second < b.second );
	}

	for ( size_t  i = a.second - 1  ;  i >= 1  ;  -- i )
	{
		int	cmp;
		if ( (cmp = strcmp( a.first[i] , b.first[i] )) != 0 )
		{
			return( cmp < 0 );
		}
	}

	return( strcmp( a.first[0] , b.first[0] ) < 0 );
}


bool   Fixed_SObject_Location_Translator::get_location(
			D2_Vector *  vec ,
			size_t  obj_ident_size ,
			char **  obj_ident ,
			S_Side_LR  side )
{
	if ( obj_ident_size <= 1 )
	{
		vec -> set( D2_Vector::XY , 0.0 , 0.0 );
		return( false );
	}

	pair<char **, size_t>	test_pair;

	test_pair.first  = obj_ident;
	test_pair.second = obj_ident_size;

	std::map< std::pair<char **, size_t>, D2_Vector,
		  trans_str_array_less>
		::iterator	it = trans_str_array.find( test_pair );

	if ( it == trans_str_array.end()
	  || side == S_Side_LR::Unknown )
	{
		vec -> set( D2_Vector::XY , 0.0 , 0.0 );

		return( false );
	}
	else
	{
		*vec = (*it).second;

		this -> side_trans( vec , side );

		return( true );
	}
}




bool   Fixed_SObject_Location_Translator::get_closest_object_location(
					D2_Vector *  closest_object ,
					const D2_Vector &  point ,
					bool  marker_flag )
{
	// XXX: flag must be used
	//      flag == true : Flag Object
	//      flag == false: Goal Object
	(void)marker_flag;

	int	table_size
		  = sizeof(flag_goal_location_table)
		    / sizeof(flag_goal_location_table[0]);

	if ( table_size == 0 )
	{
		return( false );
	}


	double	min_dist = DBL_MAX;
	int	min_dist_index = 0;

	for ( int  i = 0  ;  i < table_size  ;  i ++ )
	{
		D2_Vector	obj( flag_goal_location_table[i].vec[0] ,
				     flag_goal_location_table[i].vec[1] );

		double	dist = (point - obj).r();

		if ( dist < min_dist )
		{
			min_dist = dist;
			min_dist_index = i;
		}
	}

	closest_object
		-> set( flag_goal_location_table[min_dist_index].vec[0] ,
			flag_goal_location_table[min_dist_index].vec[1] );

	return( true );
}


void   Fixed_SObject_Location_Translator::side_trans( D2_Vector *  obj_vec ,
						      S_Side_LR  side ) const
{
	// if right side, reverse x and y coordinate.
	if ( side == S_Side_LR::Right_Side )
	{
		obj_vec -> set( D2_Vector::XY ,
				- (obj_vec -> x()) ,
				- (obj_vec -> y()) );
	}
}
