#ifndef	   FIXED_SOBJECT_LOCATION_H_INCLUDED
#define	   FIXED_SOBJECT_LOCATION_H_INCLUDED

#include  "d2_vector.h"
#include  "lisp_lex.h"
#include  "s_basic.h"
#include  <map>
#include  <utility>
#include  <stdexcept>

class  Fixed_SObject_Location_Translator
{
protected:
	static	const size_t	MAX_OBJ_IDENT  = 4;
	static	const size_t	MAX_SYMBOL_LEN = 4;

protected:
	class	trans_str_array_less
	{
	public:
		bool	operator()(
			   std::pair<char **, size_t> a ,
			   std::pair<char **, size_t> b ) const throw();
	};

protected:
	std::map<Lisp_Lexical_Object, D2_Vector>	trans_lsp;
	std::map<std::string, D2_Vector>		trans_str;
	std::map<std::pair<char **, size_t>, D2_Vector,
				trans_str_array_less>	trans_str_array;


protected:
	void	side_trans( D2_Vector *  obj_vec ,  S_Side_LR  side ) const;

public:
	 Fixed_SObject_Location_Translator();
	~Fixed_SObject_Location_Translator();

	bool	get_location( D2_Vector *  vec ,
			      const Lisp_Lexical_Object &  obj ,
			      S_Side_LR  side );

	bool	get_location( D2_Vector *  vec ,
			      const std::string &  str_obj ,
			      S_Side_LR  side );

	bool	get_location( D2_Vector *  vec ,
			      size_t  obj_ident_size ,
			      char **  obj_ident ,
			      S_Side_LR  side );

	bool	get_closest_object_location( D2_Vector *  closest_object ,
					     const D2_Vector &  point ,
					     bool  marker_flag );
};


//
// Fixed SObject Location Table
//
#include  <string>

struct  Fixed_SObject_Location_Table_Entry
{
	std::string	obj_ident;
	double		vec[2];
};

static const Fixed_SObject_Location_Table_Entry  flag_goal_location_table[] =
{
	{ "(goal l)"     ,	{ -52.5,    0.0  } },
	{ "(goal r)"     ,	{  52.5,    0.0  } },

	{ "(flag c)"     ,	{   0.0 ,   0.0  } },
	{ "(flag c t)"   ,	{   0.0 , -34.0  } },
	{ "(flag c b)"   ,	{   0.0 ,  34.0  } },

	{ "(flag l t)"   ,	{ -52.5 , -34.0  } },
	{ "(flag l b)"   ,	{ -52.5 ,  34.0  } },
	{ "(flag r t)"   ,	{  52.5 , -34.0  } },
	{ "(flag r b)"   ,	{  52.5 ,  34.0  } },

	{ "(flag p l t)" ,	{ -36.0 , -20.16 } },
	{ "(flag p l c)" ,	{ -36.0 ,   0.0  } },
	{ "(flag p l b)" ,	{ -36.0 ,  20.16 } },
	{ "(flag p r t)" ,	{  36.0 , -20.16 } },
	{ "(flag p r c)" ,	{  36.0 ,   0.0  } },
	{ "(flag p r b)" ,	{  36.0 ,  20.16 } },

	// XXX: these 4 flags are not constant.
	{ "(flag g l t)" ,	{ -52.5 ,  -7.01 } },
	{ "(flag g l b)" ,	{ -52.5 ,   7.01 } },
	{ "(flag g r t)" ,	{  52.5 ,  -7.01 } },
	{ "(flag g r b)" ,	{  52.5 ,   7.01 } },

	{ "(flag t l 50)",	{ -50.0 , -39.0  } },
	{ "(flag t l 40)",	{ -40.0 , -39.0  } },
	{ "(flag t l 30)",	{ -30.0 , -39.0  } },
	{ "(flag t l 20)",	{ -20.0 , -39.0  } },
	{ "(flag t l 10)",	{ -10.0 , -39.0  } },
	{ "(flag t 0)"   ,	{   0.0 , -39.0  } },
	{ "(flag t r 10)",	{  10.0 , -39.0  } },
	{ "(flag t r 20)",	{  20.0 , -39.0  } },
	{ "(flag t r 30)",	{  30.0 , -39.0  } },
	{ "(flag t r 40)",	{  40.0 , -39.0  } },
	{ "(flag t r 50)",	{  50.0 , -39.0  } },

	{ "(flag b l 50)",	{ -50.0 ,  39.0  } },
	{ "(flag b l 40)",	{ -40.0 ,  39.0  } },
	{ "(flag b l 30)",	{ -30.0 ,  39.0  } },
	{ "(flag b l 20)",	{ -20.0 ,  39.0  } },
	{ "(flag b l 10)",	{ -10.0 ,  39.0  } },
	{ "(flag b 0)"   ,	{   0.0 ,  39.0  } },
	{ "(flag b r 10)",	{  10.0 ,  39.0  } },
	{ "(flag b r 20)",	{  20.0 ,  39.0  } },
	{ "(flag b r 30)",	{  30.0 ,  39.0  } },
	{ "(flag b r 40)",	{  40.0 ,  39.0  } },
	{ "(flag b r 50)",	{  50.0 ,  39.0  } },

	{ "(flag l t 30)",	{ -57.5 , -30.0  } },
	{ "(flag l t 20)",	{ -57.5 , -20.0  } },
	{ "(flag l t 10)",	{ -57.5 , -10.0  } },
	{ "(flag l 0)"   ,	{ -57.5 ,   0.0  } },
	{ "(flag l b 10)",	{ -57.5 ,  10.0  } },
	{ "(flag l b 20)",	{ -57.5 ,  20.0  } },
	{ "(flag l b 30)",	{ -57.5 ,  30.0  } },

	{ "(flag r t 30)",	{  57.5 , -30.0  } },
	{ "(flag r t 20)",	{  57.5 , -20.0  } },
	{ "(flag r t 10)",	{  57.5 , -10.0  } },
	{ "(flag r 0)"   ,	{  57.5 ,   0.0  } },
	{ "(flag r b 10)",	{  57.5 ,  10.0  } },
	{ "(flag r b 20)",	{  57.5 ,  20.0  } },
	{ "(flag r b 30)",	{  57.5 ,  30.0  } },

	//
	// for soccer server ver 6
	//
	{ "(g l)"     ,	{ -52.5,    0.0  } },
	{ "(g r)"     ,	{  52.5,    0.0  } },

	{ "(f c)"     ,	{   0.0 ,   0.0  } },
	{ "(f c t)"   ,	{   0.0 , -34.0  } },
	{ "(f c b)"   ,	{   0.0 ,  34.0  } },

	{ "(f l t)"   ,	{ -52.5 , -34.0  } },
	{ "(f l b)"   ,	{ -52.5 ,  34.0  } },
	{ "(f r t)"   ,	{  52.5 , -34.0  } },
	{ "(f r b)"   ,	{  52.5 ,  34.0  } },

	{ "(f p l t)" ,	{ -36.0 , -20.16 } },
	{ "(f p l c)" ,	{ -36.0 ,   0.0  } },
	{ "(f p l b)" ,	{ -36.0 ,  20.16 } },
	{ "(f p r t)" ,	{  36.0 , -20.16 } },
	{ "(f p r c)" ,	{  36.0 ,   0.0  } },
	{ "(f p r b)" ,	{  36.0 ,  20.16 } },

	// XXX: these 4 flags are not constant.
	{ "(f g l t)" ,	{ -52.5 ,  -7.01 } },
	{ "(f g l b)" ,	{ -52.5 ,   7.01 } },
	{ "(f g r t)" ,	{  52.5 ,  -7.01 } },
	{ "(f g r b)" ,	{  52.5 ,   7.01 } },

	{ "(f t l 50)",	{ -50.0 , -39.0  } },
	{ "(f t l 40)",	{ -40.0 , -39.0  } },
	{ "(f t l 30)",	{ -30.0 , -39.0  } },
	{ "(f t l 20)",	{ -20.0 , -39.0  } },
	{ "(f t l 10)",	{ -10.0 , -39.0  } },
	{ "(f t 0)"   ,	{   0.0 , -39.0  } },
	{ "(f t r 10)",	{  10.0 , -39.0  } },
	{ "(f t r 20)",	{  20.0 , -39.0  } },
	{ "(f t r 30)",	{  30.0 , -39.0  } },
	{ "(f t r 40)",	{  40.0 , -39.0  } },
	{ "(f t r 50)",	{  50.0 , -39.0  } },

	{ "(f b l 50)",	{ -50.0 ,  39.0  } },
	{ "(f b l 40)",	{ -40.0 ,  39.0  } },
	{ "(f b l 30)",	{ -30.0 ,  39.0  } },
	{ "(f b l 20)",	{ -20.0 ,  39.0  } },
	{ "(f b l 10)",	{ -10.0 ,  39.0  } },
	{ "(f b 0)"   ,	{   0.0 ,  39.0  } },
	{ "(f b r 10)",	{  10.0 ,  39.0  } },
	{ "(f b r 20)",	{  20.0 ,  39.0  } },
	{ "(f b r 30)",	{  30.0 ,  39.0  } },
	{ "(f b r 40)",	{  40.0 ,  39.0  } },
	{ "(f b r 50)",	{  50.0 ,  39.0  } },

	{ "(f l t 30)",	{ -57.5 , -30.0  } },
	{ "(f l t 20)",	{ -57.5 , -20.0  } },
	{ "(f l t 10)",	{ -57.5 , -10.0  } },
	{ "(f l 0)"   ,	{ -57.5 ,   0.0  } },
	{ "(f l b 10)",	{ -57.5 ,  10.0  } },
	{ "(f l b 20)",	{ -57.5 ,  20.0  } },
	{ "(f l b 30)",	{ -57.5 ,  30.0  } },

	{ "(f r t 30)",	{  57.5 , -30.0  } },
	{ "(f r t 20)",	{  57.5 , -20.0  } },
	{ "(f r t 10)",	{  57.5 , -10.0  } },
	{ "(f r 0)"   ,	{  57.5 ,   0.0  } },
	{ "(f r b 10)",	{  57.5 ,  10.0  } },
	{ "(f r b 20)",	{  57.5 ,  20.0  } },
	{ "(f r b 30)",	{  57.5 ,  30.0  } }
};


#endif	/* FIXED_SOBJECT_LOCATION_H_INCLUDED */
