#ifdef QUANTIZE_TEST
#include  <iostream>
#include  "quantize.h"

int    main( void )
{
	for( double  d = 0.0  ;  d  <=  120.0  ;  d += 0.01 )
	{
		cout  <<  d  <<  "\t"  <<  d  <<  endl;
	}

	cout  <<  endl;

	SServer_Param	param;

#if 0
	for( double  d = 0.0  ;  d  <=  120.0  ;  d += 0.01 )
	{
		cout  <<  d  <<  "\t"
		      <<  quantize(d , 0.1)  <<  endl;
	}

	cout  <<  endl;

	for( double  d = 0.0  ;  d  <=  120.0  ;  d += 0.01 )
	{
		double	d_min;
		unquantize( quantize(d , 0.1) , 0.1 ,
			    &d_min , static_cast<double *>(0) );

		cout  <<  d  <<  "\t"  <<  d_min  <<  endl;
	}
	cout  <<  endl;

	for( double  d = 0.0  ;  d  <=  120.0  ;  d += 0.01 )
	{
		double	d_max;
		unquantize( quantize(d , 0.1) , 0.1 ,
			    static_cast<double *>(0) , &d_max );

		cout  <<  d  <<  "\t"  <<  d_max  <<  endl;
	}
#endif

#if 1
	for( double  d = 0.0  ;  d  <=  120.0  ;  d += 0.01 )
	{
		cout  <<  d  <<  "\t"
		      <<  far_object_distance( param , d , false )  <<  endl;
	}

	cout  <<  endl;

	for( double  d = 1.0  ;  d  <=  120.0  ;  d += 0.001 )
	{
		double	d_min;
		double	d_max;

		far_object_unquantized_distance
			( param ,
			  far_object_distance( param , d , false ) ,
			  false ,
			  &d_min , &d_max );

		cout  <<  d  <<  "\t"  <<  d_max  <<  endl;
	}

	cout  <<  endl;

	for( double  d = 1.0  ;  d  <=  120.0  ;  d += 0.001 )
	{
		double	d_min;
		double	d_max;

		far_object_unquantized_distance
			( param ,
			  far_object_distance( param , d , false ) ,
			  false ,
			  &d_min , &d_max );

		cout  <<  d  <<  "\t"  <<  d_min  <<  endl;
	}
#endif

	return( 0 );
}
#endif  // QUANTIZE_TEST


#include  <cmath>
#include  <cstddef>
#include  "quantize.h"

using namespace std;

static	const	double	SERVER_EPS = (1.0e-10);

double  far_object_distance( const SServer_Param &  param ,
			     double  x ,  bool  move_object )
{
	const	double	quantize_step = (move_object ?
					   param.QUANTIZE_STEP()
					 : param.QUANTIZE_STEP_L());

	return( quantize( exp( quantize( log( x + SERVER_EPS ) ,
					 quantize_step ) ) ,
			  0.1 ) );
}

void   far_object_unquantized_distance( const SServer_Param &  param ,
					double  x ,  bool  move_object ,
					double *  x_min ,  double *  x_max )
{
	// XXX: bug: if (x < 0.0)

	const	double	quantize_step = (move_object ?
					   param.QUANTIZE_STEP()
					 : param.QUANTIZE_STEP_L());

	const	double	err = (quantize_step / 2.0);

	double	x_with_error_min = x - err;
	double	x_with_error_max = x + err;

	if ( x_with_error_min < 0.0 )
	{
		x_with_error_min = 0.0;
	}


	double	a = 0.0;
	double	b = 0.0;
	double	aa = 0.0;
	double	bb = 0.0;

	unquantize( x_with_error_min , 0.1 , &a , static_cast<double *>(0) );
	unquantize( x_with_error_max , 0.1 , static_cast<double *>(0) , &b );

	unquantize( log(a) , quantize_step , &aa  , static_cast<double *>(0) );
	unquantize( log(b) , quantize_step , static_cast<double *>(0) , &bb  );

	*x_min = exp(aa) - SERVER_EPS;
	*x_max = exp(bb) - SERVER_EPS;

	if ( *x_min < 0.0 )
	{
		*x_min = 0.0;
	}

	if ( *x_max < 0.0 )
	{
		*x_max = 0.0;
	}
}


double  quantize( double  x ,  double  q )
{
	return( rint(x / q) * q );
}

void	unquantize( double  x ,  double  q ,
		    double *  x_min ,  double *  x_max )
{
	const	double	n = rint(x / q);

	if ( x_min )
	{
		*x_min = (n - 0.5) * q;

		if ( *x_min < 0.0 )
		{
			*x_min = 0.0;
		}
	}

	if ( x_max )
	{
		*x_max = (n + 0.5) * q;
	}
}
