#ifndef	   S_BASIC_H_INCLUDED
#define	   S_BASIC_H_INCLUDED

#include  "d2_vector.h"
#include  <cstddef>
#include  <string>

static	const int	MAX_PLAYER = 11;	// max player in a team

///
///  Side
///

//
//    S_Side
//
class  S_Side
{
public:
	typedef  enum{ Unknown , Our_Side , Opponent_Side }  Side;

protected:
	S_Side::Side	side;

public:
	S_Side() throw()
		: side( S_Side::Unknown )
		{
		}

	S_Side( S_Side::Side  s ) throw()
		: side( s )
		{
		}

	S_Side &	operator= ( S_Side::Side  s ) throw()
		{
			this -> side = s;
			return( *this );
		}

	bool	operator== ( S_Side::Side  s ) const throw()
		{
			return( this -> side == s );
		}

	bool	operator!= ( S_Side::Side  s ) const throw()
		{
			return( this -> side != s );
		}

	operator S_Side::Side () const throw()
		{
			return( this -> side );
		}

	S_Side	reverse() const throw()
		{
			switch( this -> side )
			{
			case Our_Side:
				return( Opponent_Side );
				break;

			case Opponent_Side:
				return( Our_Side );
				break;

			case Unknown:
			default:
				return( Unknown );
				break;
			}
		}

	operator std::string() const
		{
			switch( this -> side )
			{
			case Our_Side:
				return( "Our_Side" );
				break;

			case Opponent_Side:
				return( "Opponent_Side" );
				break;

			case Unknown:
			default:
				return( "Unknown" );
				break;
			}
		}
};


//
//    S_Side_LR
//
class  S_Side_LR
{
public:
	typedef  enum{ Unknown , Left_Side , Right_Side }  Side;

protected:
	S_Side_LR::Side	side;

public:
	S_Side_LR() throw()
		: side( S_Side_LR::Unknown )
		{
		}

	S_Side_LR( S_Side_LR::Side  s ) throw()
		: side( s )
		{
		}

	S_Side_LR &  operator= ( S_Side_LR::Side  s ) throw()
		{
			this -> side = s;
			return( *this );
		}

	bool	operator== ( S_Side_LR::Side  s ) const throw()
		{
			return( this -> side == s );
		}

	bool	operator!= ( S_Side_LR::Side  s ) const throw()
		{
			return( this -> side != s );
		}

	operator S_Side_LR::Side () const throw()
		{
			return( this -> side );
		}

	S_Side_LR	reverse() const throw()
		{
			switch( this -> side )
			{
			case Left_Side:
				return( Right_Side );
				break;

			case Right_Side:
				return( Left_Side );
				break;

			case Unknown:
			default:
				return( Unknown );
				break;
			}
		}

	operator std::string() const
		{
			switch( this -> side )
			{
			case Left_Side:
				return( "Left_Side" );
				break;

			case Right_Side:
				return( "Right_Side" );
				break;

			case Unknown:
			default:
				return( "Unknown" );
				break;
			}
		}
};



//
// View mode
//

// Observational Angle of View
//     VA_Narrow: 45 degree.
//     VA_Normal: 90 degree.
//     VA_Wide:  180 degree.
//
class  View_Width
{
public:
	enum  Width { Unknown , Narrow , Normal , Wide };

protected:
	View_Width::Width	wid;

public:
	View_Width() throw()
		: wid( View_Width::Unknown )
		{
		}

	View_Width( View_Width::Width  w ) throw()
		: wid( w )
		{
		}

	View_Width &  operator= ( View_Width::Width  w ) throw()
		{
			this -> wid = w;
			return( *this );
		}

	bool	operator== ( View_Width::Width  w ) const throw()
		{
			return( this -> wid == w );
		}

	bool	operator!= ( View_Width::Width  w ) const throw()
		{
			return( this -> wid != w );
		}

	operator View_Width::Width () const throw()
		{
			return( this -> wid );
		}

	Angle	angle() const throw()
		{
			switch( wid )
			{
			case Narrow:
				return( Degree( 45.0 ) );

			case Normal:
				return( Degree( 90.0 ) );

			case Wide:
				return( Degree( 180.0 ) );

			default: // error
				return( Degree( 0.0 ) );
			}
		}

	Angle	half_angle() const throw()
		{
			return( this -> angle() / 2.0 );
		}
};


// Quality of View
//     VQ_High: distance and direction.
//     VQ_Low:  direction only.
class  View_Quality
{
public:
	typedef enum{ Unknown , High , Low } Quality;

protected:
	View_Quality::Quality	qual;

public:
	View_Quality() throw()
		: qual( View_Quality::Unknown )
		{
		}

	View_Quality( View_Quality::Quality  q ) throw()
		: qual( q )
		{
		}

	View_Quality &  operator= ( View_Quality::Quality  q ) throw()
		{
			this -> qual = q;
			return( *this );
		}

	bool	operator== ( View_Quality::Quality  q ) const throw()
		{
			return( this -> qual == q );
		}

	bool	operator!= ( View_Quality::Quality  q ) const throw()
		{
			return( this -> qual != q );
		}

	operator View_Quality::Quality () const throw()
		{
			return( this -> qual );
		}
};




//
//  SObject_Identifier
//
struct  SObject_Ball_Identifier
{
};

struct  SObject_Player_Identifier
{
	S_Side	side;
	int	player_number;

public:
	SObject_Player_Identifier( const S_Side &  s = S_Side::Unknown ,
				   int  n = -1 )
		: side( s ) , player_number( n ) {}

	bool	player_number_valid() const
	{
		return( 1 <= player_number  &&  player_number <= MAX_PLAYER );
	}

	bool	operator ==( const SObject_Player_Identifier &  id ) const
	{
		return(    (this -> side == id.side)
			&& (this -> player_number == id.player_number ) );
	}

	bool	operator !=( const SObject_Player_Identifier &  id ) const
	{
		return( ! (*this == id) );
	}
};

struct  SObject_Field_Marker_Identifier
{
	bool		marker_flag;
	bool		location_known;
	D2_Vector	location;
};

struct  SObject_Line_Identifier
{
	typedef  enum { Opponent_Goal_Line , Left_Wing_Line ,
			Our_Goal_Line      , Right_Wing_Line }  Which_Line;

	Which_Line	which_line;
};




//
// Play_Mode
//
#include  <string>
#include  <iostream>

class  Play_Mode
{
public:
	enum Mode { Unknown ,

		    Before_Kick_Off ,
		    Play_On ,
		    Time_Over ,

		    Our_Kick_Off ,
		    Our_Kick_In ,
		    Our_Free_Kick ,
		    Our_Corner_Kick ,
		    Our_Goal_Kick ,
		    Our_Goal ,
		    Our_Catch ,

		    Opponent_Kick_Off ,
		    Opponent_Kick_In ,
		    Opponent_Free_Kick ,
		    Opponent_Corner_Kick ,
		    Opponent_Goal_Kick ,
		    Opponent_Goal ,
		    Opponent_Catch
	};

	operator std::string() const throw()
		{
			const char *	play_mode_str[] = {
				"Unknown" ,

				"Before Kick Off" ,
				"Play On" ,
				"Time Over" ,

				"Our Kick Off" ,
				"Our Kick In" ,
				"Our Free Kick" ,
				"Our Corner Kick" ,
				"Our Goal Kick" ,
				"Our Goal" ,
				"Our Catch" ,

				"Opponent Kick Off" ,
				"Opponent Kick In" ,
				"Opponent Free Kick" ,
				"Opponent Corner Kick" ,
				"Opponent Goal Kick" ,
				"Opponent Goal"
				"Opponent Catch"
			};

			return( static_cast<std::string>(
					    play_mode_str[ this -> mode ]) );
		}

private:
	Play_Mode::Mode		mode;

public:
	Play_Mode() throw()
		: mode( Play_Mode::Unknown )
		{
		}

	Play_Mode( Play_Mode::Mode  m ) throw()
		: mode( m )
		{
		}

	operator Play_Mode::Mode() const throw()
		{
			return( this -> mode );
		}

	Play_Mode	operator= ( Play_Mode::Mode  m ) throw()
		{
			this -> mode = m;
			return( *this );
		}

	bool	operator== ( Play_Mode::Mode  mode ) const throw()
		{
			return( this -> mode  ==  mode );
		}

	bool	operator!= ( Play_Mode::Mode  mode ) const throw()
		{
			return( this -> mode  !=  mode );
		}

#if 0
	// XXX
	bool	we_must_kick() const throw()
		{
			return( this -> mode == Our_Kick_Off
			     || this -> mode == Our_Kick_In
			     || this -> mode == Our_Free_Kick
			     || this -> mode == Our_Corner_Kick
			     || this -> mode == Our_Goal_Kick );
		}

	// XXX
	bool	we_may_kick() const throw()
		{
			return( this -> mode == Play_On
			     || this -> we_must_kick() );
		}

	// XXX
	bool	can_move() const throw()
		{
			return( this -> mode == Before_Kick_Off );
		}
#endif
};

inline
std::ostream &  operator << ( std::ostream &  ostr ,  const Play_Mode &  mode )
{
	return( ostr << static_cast<std::string>(mode) );
}


//
// Judgement_Type
//
#include  <string>
#include  <iostream>

class  Judgement_Type
{
public:
	enum Type {
		Unknown ,
		Goal , Foul , Offside , Drop_Ball ,
		Goalie_Catch_Ball , Half_Time ,
		Time_Up , Time_Up_Without_A_Team ,
		Time_Extended ,
		One_of_Play_Modes
	};

	operator std::string() const throw()
		{

			const char *	judgement_type_str[] = {
				"Unknown" ,
				"Goal" , "Foul" , "Offside" , "Drop_Ball" ,
				"Goalie_Catch_Ball" , "Half_Time" ,
				"Time_Up" , "Time_Up_Without_A_Team" ,
				"Time_Extended" ,
				"One_of_Play_Modes"
			};

			return( static_cast<std::string>(
				    judgement_type_str[ this -> type ]) );
		}
protected:
	Judgement_Type::Type	type;

public:
	Judgement_Type() throw()
		: type( Judgement_Type::Unknown )
		{
		}

	Judgement_Type( Judgement_Type::Type  t ) throw()
		: type( t )
		{
		}

	operator Judgement_Type::Type() const throw()
		{
			return( this -> type );
		}

	Judgement_Type	operator= ( Judgement_Type::Type  t ) throw()
		{
			this -> type = t;
			return( *this );
		}

	bool	operator== ( Judgement_Type::Type  type ) const throw()
		{
			return( this -> type  ==  type );
		}

	bool	operator!= ( Judgement_Type::Type  type ) const throw()
		{
			return( this -> type  !=  type );
		}
};

inline
std::ostream&  operator << ( std::ostream &  ostr ,
			     const Judgement_Type &  type )
{
	return( ostr << static_cast<std::string>(type) );
}

#endif	/* S_BASIC_H_INCLUDED */
