#include  "server_raw_info.h"
#include  <cassert>

using namespace std;

//
// Server_Raw_Info
//
Server_Raw_Info::Server_Raw_Info()
	: type_of_info( Type_Unknown ) ,
	  time_of_info( 0 ) ,
	  raw_mes( new std::string("") ) ,
	  sight  ( static_cast<Server_Raw_Sight_Info *>       (0) ) ,
	  audio  ( static_cast<Server_Raw_Audio_Info *>       (0) ) ,
	  whistle( static_cast<Server_Raw_Whistle_Info *>     (0) ) ,
	  body   ( static_cast<Server_Raw_Body_Info *>        (0) ) ,
	  err    ( static_cast<Server_Raw_Error_Info *>       (0) ) ,
	  s_param( static_cast<Server_Raw_Server_Param_Info *>(0) ) ,
	  p_param( static_cast<Server_Raw_Player_Param_Info *>(0) ) ,
	  pl_type( static_cast<Server_Raw_Player_Type_Info *> (0) ) ,
	  debug  ( static_cast<Server_Raw_Debug_Info *>       (0) )
{
}

Server_Raw_Info::~Server_Raw_Info()
{
}


void   Server_Raw_Info::reset_info()
{
	type_of_info = Type_Unknown;

	sight   = static_cast<Server_Raw_Sight_Info *>       (0);
	audio   = static_cast<Server_Raw_Audio_Info *>       (0);
	whistle = static_cast<Server_Raw_Whistle_Info *>     (0);
	body    = static_cast<Server_Raw_Body_Info *>        (0);
	err     = static_cast<Server_Raw_Error_Info *>       (0);
	s_param = static_cast<Server_Raw_Server_Param_Info *>(0);
	p_param = static_cast<Server_Raw_Player_Param_Info *>(0);
	pl_type = static_cast<Server_Raw_Player_Type_Info *> (0);
	debug   = static_cast<Server_Raw_Debug_Info *>       (0);
}


void   Server_Raw_Info::set_raw_message
				( const ref_count_ptr<const string> &  mes )
{
	this -> raw_mes = mes;
}


void   Server_Raw_Info::set_time( long  t )
{
	time_of_info = t;
}


void   Server_Raw_Info::set_sight_info(
		 const ref_count_ptr< const Server_Raw_Sight_Info > &  si )
{
	reset_info();
	this -> type_of_info = Type_Sight;
	this -> sight = si;
}


void   Server_Raw_Info::set_audio_info(
		 const ref_count_ptr< const Server_Raw_Audio_Info > &  au )
{
	reset_info();
	this -> type_of_info = Type_Audio;
	this -> audio = au;
}

void   Server_Raw_Info::set_whistle_info(
		 const ref_count_ptr< const Server_Raw_Whistle_Info > &  wi )
{
	reset_info();
	this -> type_of_info = Type_Whistle;
	this -> whistle = wi;
}


void   Server_Raw_Info::set_body_info(
		 const ref_count_ptr< const Server_Raw_Body_Info > &  bd )
{
	reset_info();
	this ->  type_of_info = Type_Body;
	this ->  body = bd;
}

void   Server_Raw_Info::set_error_info(
		 const ref_count_ptr< const Server_Raw_Error_Info > &  er )
{
	reset_info();
	this ->  type_of_info = Type_Error;
	this ->  err = er;
}

void   Server_Raw_Info::set_server_param_info(
	 const ref_count_ptr< const Server_Raw_Server_Param_Info > &  sp )
{
	reset_info();
	this ->  type_of_info = Type_Server_Param;
	this ->  s_param = sp;
}

void   Server_Raw_Info::set_player_param_info(
	 const ref_count_ptr< const Server_Raw_Player_Param_Info > &  pp )
{
	reset_info();
	this ->  type_of_info = Type_Player_Param;
	this ->  p_param = pp;
}

void   Server_Raw_Info::set_player_type_info(
	 const ref_count_ptr< const Server_Raw_Player_Type_Info > &  pt )
{
	reset_info();
	this ->  type_of_info = Type_Player_Type;
	this ->  pl_type = pt;
}

void   Server_Raw_Info::set_debug_info(
		const  ref_count_ptr< const Server_Raw_Debug_Info > &  de )
{
	reset_info();
	this ->  type_of_info = Type_Debug;
	this ->  debug = de;
}


void   Server_Raw_Info::set_no_info()
{
	reset_info();
	this ->  type_of_info = Type_No_Info;
}




const string &  Server_Raw_Info::raw_message() const
{
	return( *raw_mes );
}


Server_Raw_Info::Info_Type  Server_Raw_Info::type() const
{
	return( this -> type_of_info );
}


long   Server_Raw_Info::time() const
{
	return( this -> time_of_info );
}


bool   Server_Raw_Info::illegal() const
{
	return( this -> type_of_info  ==  Type_Unknown );
}


bool   Server_Raw_Info::no_info() const
{
	return( this -> type_of_info  ==  Type_No_Info );
}


const ref_count_ptr<const Server_Raw_Sight_Info> &
  Server_Raw_Info::get_sight_info() const
{
	return( sight );
}

const ref_count_ptr<const Server_Raw_Audio_Info> &
  Server_Raw_Info::get_audio_info() const
{
	return( audio );
}

const ref_count_ptr<const Server_Raw_Whistle_Info> &
  Server_Raw_Info::get_whistle_info() const
{
	return( whistle );
}

const ref_count_ptr<const Server_Raw_Body_Info> &
  Server_Raw_Info::get_body_info() const
{
	return( body );
}

const ref_count_ptr<const Server_Raw_Error_Info> &
  Server_Raw_Info::get_error_info() const
{
	return( err );
}

const ref_count_ptr<const Server_Raw_Server_Param_Info> &
  Server_Raw_Info::get_server_param_info() const
{
	return( s_param );
}

const ref_count_ptr<const Server_Raw_Player_Param_Info> &
  Server_Raw_Info::get_player_param_info() const
{
	return( p_param );
}

const ref_count_ptr<const Server_Raw_Player_Type_Info> &
  Server_Raw_Info::get_player_type_info() const
{
	return( pl_type );
}

const ref_count_ptr<const Server_Raw_Debug_Info> &
  Server_Raw_Info::get_debug_info() const
{
	return( debug );
}
