#ifndef	   SERVER_RAW_INFO_H_INCLUDED
#define	   SERVER_RAW_INFO_H_INCLUDED

#include  "s_basic.h"
#include  "angle.h"

///////////////////////////////////////////////////////////////////////////////
//			      Body_Info					     //
///////////////////////////////////////////////////////////////////////////////
struct  Server_Raw_Body_Info
{
	View_Width	v_width;
	View_Quality	v_quality;

	double	stamina;
	double	effort;

	bool	have_speed_angle;
	double	speed;
	Angle	speed_angle;

	Angle	neck_angle;

	int	n_kick;
	int	n_dash;
	int	n_turn;
	int	n_say;
	int	n_turn_neck;
	int	n_catch;
	int	n_move;
	int	n_change_view;

	Server_Raw_Body_Info()
		: v_width( View_Width::Normal ) ,
		  v_quality( View_Quality::High ) ,
		  stamina(0.0) , effort(0.0) ,
		  have_speed_angle(false) ,
		  speed(0.0) , speed_angle( Angle::Radian , 0.0 ) ,
		  neck_angle( Angle::Radian , 0.0 ) ,
		  n_kick(0) , n_dash(0) , n_turn(0) ,
		  n_say(0) , n_turn_neck(0),
		  n_catch(0) , n_move(0) , n_change_view(0) {}
};



///////////////////////////////////////////////////////////////////////////////
//			     Whistle_Info				     //
///////////////////////////////////////////////////////////////////////////////
struct  Server_Raw_Whistle_Info
{
	Judgement_Type	type;

	Play_Mode	play_mode;
	S_Side		side;
	int		player_number;
	int		score;

	Server_Raw_Whistle_Info()
		: type( Judgement_Type::Unknown ) ,
		  play_mode( Play_Mode::Unknown ) ,
		  side( S_Side::Unknown ) , player_number( 0 ) , score( 0 ) {}
};


///////////////////////////////////////////////////////////////////////////////
//			   Audio_Info					     //
///////////////////////////////////////////////////////////////////////////////
#include  <string>

struct  Server_Raw_Audio_Info
{
	enum  Sender_Type { ST_Self ,
			    ST_Player ,
			    ST_Our_Online_Coach ,
			    ST_Opponent_Online_Coach };

	Angle		direction;
	Sender_Type	sender;
	std::string	message;

	Server_Raw_Audio_Info()
		: direction( Angle::Radian , 0.0 ) , sender( ST_Self ) ,
		  message() {}
};



///////////////////////////////////////////////////////////////////////////////
//			      Sight_Info				     //
///////////////////////////////////////////////////////////////////////////////

#include  "d2_vector.h"
//
//  Object Location
//
struct  Raw_SObject_Locational_Info
{
	bool	have_distance;
	bool	have_direction;
	bool	have_d_distance;
	bool	have_d_direction;
	bool	have_body_direction;
	bool	have_face_direction;

	double	distance;
	Angle	direction;
	double	d_distance;
	Angle	d_direction;
	Angle	body_direction;
	Angle	face_direction;

	bool	in_sight;

	Raw_SObject_Locational_Info()
		: have_distance( false ) , have_direction( false ) ,
		  have_d_distance( false ) , have_d_direction( false ) ,
		  have_face_direction( false ) ,
		  in_sight( true )
		{
		}
};


//
//  Object and Locational Information
//
struct  Raw_Ball_Info
{
	SObject_Ball_Identifier		entity;
	Raw_SObject_Locational_Info	relative;
};

struct  Raw_Player_Info
{
	SObject_Player_Identifier	entity;
	Raw_SObject_Locational_Info	relative;
	bool	have_goalie_info;
	bool	goalie;

public:
	Raw_Player_Info()
		: have_goalie_info( false ) , goalie( false ) {}
};

struct  Raw_Field_Marker_Info
{
	SObject_Field_Marker_Identifier	entity;
	Raw_SObject_Locational_Info	relative;
};

struct  Raw_Line_Info
{
	SObject_Line_Identifier		entity;
	Raw_SObject_Locational_Info	relative;
};

//
//  Server_Raw_Sight_Info
//
#include  <vector>

struct  Server_Raw_Sight_Info
{
	std::vector<         Raw_Ball_Info >	ball;
	std::vector<       Raw_Player_Info >	player;
	std::vector< Raw_Field_Marker_Info >	field_marker;
	std::vector<         Raw_Line_Info >	line;

	 Server_Raw_Sight_Info()
		 : ball() , player() , field_marker() , line() {}

#ifdef LIB_MEMORY
	~Server_Raw_Sight_Info()
		{
			ball.clear();
			player.clear();
			field_marker.clear();
			line.clear();
		}
#endif
};


///////////////////////////////////////////////////////////////////////////////
//			      Error_Info				     //
///////////////////////////////////////////////////////////////////////////////
#include  <string>

struct  Server_Raw_Error_Info
{
	// XXX
	std::string	error_message;

public:
	Server_Raw_Error_Info() : error_message() {}
};


///////////////////////////////////////////////////////////////////////////////
//			      OK_Info					     //
///////////////////////////////////////////////////////////////////////////////
struct  Server_Raw_OK_Info
{
	// XXX
	typedef  enum { Move , Look , Check_Ball ,
			Say , Ear , Chamge_Mode } OK_Type;
	OK_Type		type;

	typedef  enum { In_Field , Out_of_Field ,
			In_Our_Goal , In_Oppornent_Goal } Ball_Position;

	Ball_Position	ball_position;

	bool	ear;

	Server_Raw_OK_Info()
		: type( Move ) , ball_position( In_Field ) , ear( true ) {}
};



///////////////////////////////////////////////////////////////////////////////
//			      Server_Param_Info				     //
///////////////////////////////////////////////////////////////////////////////
struct  Server_Raw_Server_Param_Info
{
	// XXX
	double	goal_width;
	double	inertia_moment;
	double	player_size;
	double	player_decay;
	double	player_rand;
	double	player_weight;
	double	player_speed_max;
	double	player_accel_max;
	double	stamina_max;
	double	stamina_inc_max;
	double	recover_init;
	double	recover_dec_thr;
	double	recover_min;
	double	recover_dec;
	double	effort_init;
	double	effort_dec_thr;
	double	effort_min;
	double	effort_dec;
	double	effort_inc_thr;
	double	effort_inc;
	double	kick_rand;
	double	team_actuator_noise;
	double	player_rand_factor_l;
	double	player_rand_factor_r;
	double	kick_rand_factor_l;
	double	kick_rand_factor_r;
	double	ball_size;
	double	ball_decay;
	double	ball_rand;
	double	ball_weight;
	double	ball_speed_max;
	double	ball_accel_max;
	double	dash_power_rate;
	double	kick_power_rate;
	double	kickable_margin;
	double	control_radius;
	double	control_radius_width;
	double	max_power;
	double	min_power;
	double	max_moment;
	double	min_moment;
	double	max_neck_moment;
	double	min_neck_moment;
	double	max_neck_angle;
	double	min_neck_angle;
	double	visible_angle;
	double	visible_distance;
	double	wind_direction;
	double	wind_force;
	double	wind_angle;
	double	wind_rand;
	double	kickable_area;
	double	catch_area_l;
	double	catch_area_w;
	double	catch_probability;
	int	goalie_max_moves;
	double	corner_kick_margin;
	double	offside_active_area;
	int	wind_factor_none;
	int	wind_random;
	int	say_cnt_max;
	int	say_coach_message_size;
	int	clang_win_size;
	double	clang_define_win;
	double	clang_meta_win;
	double	clang_advice_win;
	double	clang_info_win;
	double	clang_mess_delay;
	double	clang_mess_per_cycle;
	int	half_time;
	int	simulator_step;
	int	send_step;
	int	recv_step;
	int	sense_body_step;
	int	lcm_st;
	int	say_message_size;
	int	hear_max;
	int	hear_inc;
	int	hear_decay;
	int	catch_ban_cycle;
	int	slow_down_factor;
	int	use_offside;
	int	kick_off_offside;
	double	offside_kick_margin;
	double	audio_cut_dist;
	double	dist_quantize_step;
	double	dist_quantize_step_land;
	double	dir_quantize_step;
	double	dist_quantize_step_left;
	double	dist_quantize_step_right;
	double	land_quantize_step_left;
	double	land_quantize_step_right;
	double	dir_quantize_step_left;
	double	dir_quantize_step_right;
	int	coach_mode;
	int	coach_with_referee_mode;
	int	old_hear;
	int	online_coach_look_step;

	Server_Raw_Server_Param_Info(){}; // initial value is not controllable
};


///////////////////////////////////////////////////////////////////////////////
//			      Player_Param_Info				     //
///////////////////////////////////////////////////////////////////////////////
struct  Server_Raw_Player_Param_Info
{
	int	player_types;
	int	subs_max;
	int	pt_max;
	double	player_speed_max_delta_min;
	double	player_speed_max_delta_max;
	double	stamina_inc_max_delta_factor;
	double	player_decay_delta_min;
	double	player_decay_delta_max;
	double	inertia_moment_delta_factor;
	double	dash_power_rate_delta_min;
	double	dash_power_rate_delta_max;
	double	player_size_delta_factor;
	double	kickable_margin_delta_min;
	double	kickable_margin_delta_max;
	double	kick_rand_delta_factor;
	double	extra_stamina_delta_min;
	double	extra_stamina_delta_max;
	double	effort_max_delta_factor;
	double	effort_min_delta_factor;

	// XXX
	Server_Raw_Player_Param_Info(){}; // initial value is not controllable
};

///////////////////////////////////////////////////////////////////////////////
//			      Player_Type_Info				     //
///////////////////////////////////////////////////////////////////////////////
struct  Server_Raw_Player_Type_Info
{
	int	id;
	double	player_speed_max;
	double	stamina_inc_max;
	double	player_decay;
	double	inertia_moment;
	double	dash_power_rate;
	double	player_size;
	double	kickable_margin;
	double	kick_rand;
	double	extra_stamina;
	double	effort_max;
	double	effort_min;

	Server_Raw_Player_Type_Info()
		: id(0) , // standard player
		  player_speed_max(0.0) , stamina_inc_max(0.0) ,
		  player_decay(0.0) , inertia_moment(0.0) ,
		  dash_power_rate(0.0) , player_size(0.0) ,
		  kickable_margin(0.0) , kick_rand(0.0) ,
		  extra_stamina(0.0) , effort_max(0.0) , effort_min(0.0) {}
};

///////////////////////////////////////////////////////////////////////////////
//			      Debug_Info				     //
///////////////////////////////////////////////////////////////////////////////
struct  Server_Raw_Debug_Info
{
	D2_Vector	ball_true_coordinate;
	D2_Vector	ball_true_velocity;

	struct  Player_Debug_Info
	{
		bool		have_info;

		D2_Vector	true_coordinate;
		D2_Vector	true_velocity;
		Angle		true_body_angle;
		Angle		true_neck_angle;
		double		true_stamina;
		double		true_effort;

		Player_Debug_Info()
			: have_info( false ) ,
			  true_coordinate( 0.0 , 0.0 ) ,
			  true_velocity( 0.0 , 0.0 ) ,
			  true_body_angle( Angle::Radian , 0.0 ) ,
			  true_neck_angle( Angle::Radian , 0.0 ) ,
			  true_stamina( 0.0 ) ,
			  true_effort( 0.0 ) {}
	};

	Player_Debug_Info	teammate[MAX_PLAYER];
	Player_Debug_Info	opponent[MAX_PLAYER];

	Player_Debug_Info	self;

#if 0
	bool		offside_position;
#endif

	Server_Raw_Debug_Info()
		: ball_true_coordinate( 0.0 , 0.0 ) ,
		  ball_true_velocity( 0.0 , 0.0 ) ,
		  teammate() , opponent() , self() {}
};


///////////////////////////////////////////////////////////////////////////////
//		       Server_Raw_Info					     //
///////////////////////////////////////////////////////////////////////////////
#include  "ref_count_ptr.h"

class  Server_Raw_Info
{
public:
	enum  Info_Type
	{
		Type_Unknown ,
		Type_Sight , Type_Audio , Type_Whistle , Type_Body ,
		Type_OK ,
		Type_Error ,
		Type_No_Info ,
		Type_Server_Param ,
		Type_Player_Param ,
		Type_Player_Type ,
		Type_Debug
	};

protected:
	Info_Type				type_of_info;
	long					time_of_info;
	ref_count_ptr<const std::string>	raw_mes;

	ref_count_ptr< const Server_Raw_Sight_Info        >	sight;
	ref_count_ptr< const Server_Raw_Audio_Info        >	audio;
	ref_count_ptr< const Server_Raw_Whistle_Info      >	whistle;
	ref_count_ptr< const Server_Raw_Body_Info         >	body;
	ref_count_ptr< const Server_Raw_Error_Info        >	err;
	ref_count_ptr< const Server_Raw_Server_Param_Info >	s_param;
	ref_count_ptr< const Server_Raw_Player_Param_Info >	p_param;
	ref_count_ptr< const Server_Raw_Player_Type_Info  >	pl_type;
	ref_count_ptr< const Server_Raw_Debug_Info        >	debug;

public:
	 Server_Raw_Info();
	~Server_Raw_Info();

	void	reset_info(); // to Type_Unknown

	void	set_raw_message( const ref_count_ptr<const std::string> & );
	void	set_time( long );

	void	set_sight_info
		    ( const ref_count_ptr<const Server_Raw_Sight_Info  > & );
	void	set_audio_info
		    ( const ref_count_ptr<const Server_Raw_Audio_Info  > & );
	void	set_whistle_info
		    ( const ref_count_ptr<const Server_Raw_Whistle_Info> & );
	void	set_body_info
		    ( const ref_count_ptr<const Server_Raw_Body_Info   > & );
	void	set_error_info
		    ( const ref_count_ptr<const Server_Raw_Error_Info  > & );
	void	set_debug_info
		    ( const ref_count_ptr<const Server_Raw_Debug_Info  > & );
	void	set_server_param_info
		 ( const ref_count_ptr<const Server_Raw_Server_Param_Info> & );
	void	set_player_param_info
		 ( const ref_count_ptr<const Server_Raw_Player_Param_Info> & );
	void	set_player_type_info
		 ( const ref_count_ptr<const Server_Raw_Player_Type_Info> & );
	void	set_no_info(); // to Type_No_Info

public:
	const std::string &	raw_message() const;

	Info_Type		type() const;
	long			time() const;
	bool			illegal() const;
	bool			no_info() const;

	const ref_count_ptr<const Server_Raw_Sight_Info  > &
						get_sight_info() const;
	const ref_count_ptr<const Server_Raw_Audio_Info  > &
						get_audio_info() const;
	const ref_count_ptr<const Server_Raw_Whistle_Info> &
						get_whistle_info() const;
	const ref_count_ptr<const Server_Raw_Body_Info   > &
						get_body_info() const;
	const ref_count_ptr<const Server_Raw_Error_Info  > &
						get_error_info() const;
	const ref_count_ptr<const Server_Raw_Server_Param_Info  > &
						get_server_param_info() const;
	const ref_count_ptr<const Server_Raw_Player_Param_Info  > &
						get_player_param_info() const;
	const ref_count_ptr<const Server_Raw_Player_Type_Info  > &
						get_player_type_info() const;
	const ref_count_ptr<const Server_Raw_Debug_Info  > &
						get_debug_info() const;
};


#endif	/* SERVER_RAW_INFO_H_INCLUDED */
