#ifndef	   SOCCER_COMMAND_H_INCLUDED
#define	   SOCCER_COMMAND_H_INCLUDED

#include  "s_basic.h"
#include  <string>
#include  <cassert>

class  Soccer_Command
{
public:
	typedef  enum { Move_Command , Dash_Command , Kick_Command ,
			Turn_Command , Catch_Ball_Command ,
			Turn_Neck_Command , Change_View_Command ,
			Sense_Body_Command , Say_Command ,
			Wait_Command , No_Command_Command ,
			Change_Player_Type_Command ,
			Bye_Command ,
			Illegal_Command } Command_Type;

protected:
	Command_Type	command;

	double		arg1;
	double		arg2;
	Angle		angle;
	std::string	mes;
	View_Width	view_width;
	View_Quality	view_quality;
	int		player_number;
	int		player_type;

public:
		 Soccer_Command()
		   : command( No_Command_Command ) ,
		     arg1( 0.0 ) , arg2( 0.0 ) , angle( Angle::Radian , 0.0 ) ,
		     mes() ,
		     view_width( View_Width::Normal ) ,
		     view_quality( View_Quality::High ) ,
		     player_number( -1 ) ,
		     player_type( -1 )
		{
		}

	virtual	~Soccer_Command()
		{
		}

	virtual	Command_Type	type() const
		{
			return( command );
		}

	virtual	Soccer_Command &  move( double  x ,  double  y )
		{
			command = Move_Command;
			arg1    = x;
			arg2    = y;
			return( *this );
		}

	virtual	Soccer_Command &  move( const D2_Vector &  p )
		{
			command = Move_Command;
			arg1    = p.x();
			arg2    = p.y();
			return( *this );
		}

	virtual	Soccer_Command &  dash( double  power )
		{
			command = Dash_Command;
			arg1    = power;
			return( *this );
		}

	virtual	Soccer_Command &  kick( double  power ,
					const Angle &  direction )
		{
			command = Kick_Command;
			arg1    = power;
			angle   = direction;
			return( *this );
		}

	virtual	Soccer_Command &  turn( const Angle &  moment )
		{
			command = Turn_Command;
			angle   = moment;
			return( *this );
		}


	virtual	Soccer_Command &  catch_command( const Angle &  direction )
		{
			command = Catch_Ball_Command;
			angle   = direction;
			return( *this );
		}

	virtual	Soccer_Command &  change_player_type( int  number ,
						      int  type )
		{
			command = Change_Player_Type_Command;
			player_number = number;
			player_type = type;
			return( *this );
		}

	virtual	Soccer_Command &  turn_neck( const Angle &  direction )
		{
			command = Turn_Neck_Command;
			angle   = direction;
			return( *this );
		}

	virtual	Soccer_Command &  change_view( View_Width  width ,
					       View_Quality  quality )
		{
			command      = Change_View_Command;
			view_quality = quality;
			view_width   = width;

			return( *this );
		}

	virtual	Soccer_Command &  sense_body()
		{
			command = Sense_Body_Command;
			return( *this );
		}

	virtual	Soccer_Command &  say( const std::string &  m )
		{
			command     = Say_Command;
			this -> mes = m;
			return( *this );
		}

	virtual	Soccer_Command &  wait()
		{
			command = Wait_Command;
			return( *this );
		}

	virtual	Soccer_Command &  no_command()
		{
			command = No_Command_Command;
			return( *this );
		}

	virtual	Soccer_Command &  bye()
		{
			command = Bye_Command;
			return( *this );
		}

	virtual	Soccer_Command &  illegal()
		{
			command = Illegal_Command;
			return( *this );
		}

	virtual	operator Soccer_Command::Command_Type() const
		{
			return( command );
		}

	virtual	double	move_x() const
		{
			assert( command == Move_Command );
			return( arg1 );
		}

	virtual	double	move_y() const
		{
			assert( command == Move_Command );
			return( arg2 );
		}

	virtual	double	dash_power() const
		{
			assert( command == Dash_Command );
			return( arg1 );
		}

	virtual	double	kick_power() const
		{
			assert( command == Kick_Command );
			return( arg1 );
		}

	virtual	const Angle &	kick_direction() const
		{
			assert( command == Kick_Command );
			return( angle );
		}

	virtual	const Angle &	turn_moment() const
		{
			assert( command == Turn_Command );
			return( angle );
		}

	virtual	const Angle &	catch_direction() const
		{
			assert( command == Catch_Ball_Command );
			return( angle );
		}

	virtual	const int	change_player_type_player_number() const
		{
			assert( command == Change_Player_Type_Command );
			return( player_number );
		}

	virtual	const int	change_player_type_player_type() const
		{
			assert( command == Change_Player_Type_Command );
			return( player_type );
		}

	virtual	const Angle &	turn_neck_direction() const
		{
			assert( command == Turn_Neck_Command );
			return( angle );
		}

	virtual	View_Width	change_view_view_width() const
		{
			assert( command == Change_View_Command );
			return( view_width );
		}

	virtual	View_Quality	change_view_view_quality() const
		{
			assert( command == Change_View_Command );
			return( view_quality );
		}

	virtual	std::string	say_message() const
		{
			assert( command == Say_Command );
			return( mes );
		}


	static	Soccer_Command	Move( double  x ,  double  y )
		{
			Soccer_Command	com;
			com.move( x , y );
			return( com );
		}

	static	Soccer_Command	Move( const D2_Vector &  p )
		{
			Soccer_Command	com;
			com.move( p );
			return( com );
		}

	static	Soccer_Command	Dash( double  power )
		{
			Soccer_Command	com;
			com.dash( power );
			return( com );
		}

	static	Soccer_Command	Kick( double  power ,
				      const Angle &  direction )
		{
			Soccer_Command	com;
			com.kick( power , direction );
			return( com );
		}

	static	Soccer_Command	Turn( const Angle &  moment )
		{
			Soccer_Command	com;
			com.turn( moment );
			return( com );
		}


	static	Soccer_Command	Catch_Ball( const Angle &  direction )
		{
			Soccer_Command	com;
			com.catch_command( direction );
			return( com );
		}

	static	Soccer_Command	Change_Player_Type( int  number ,  int  type )
		{
			Soccer_Command	com;
			com.change_player_type( number , type );
			return( com );
		}

	static	Soccer_Command	Turn_Neck( const Angle &  direction )
		{
			Soccer_Command	com;
			com.turn_neck( direction );
			return( com );
		}

	static	Soccer_Command	Change_View( View_Width  width ,
					     View_Quality  quality )
		{
			Soccer_Command	com;
			com.change_view( width , quality );
			return( com );
		}

	static	Soccer_Command	Sense_Body()
		{
			Soccer_Command	com;
			com.sense_body();
			return( com );
		}

	static	Soccer_Command	Say( const std::string &  m )
		{
			Soccer_Command	com;
			com.say( m );
			return( com );
		}

	static	Soccer_Command	Wait()
		{
			Soccer_Command	com;
			com.wait();
			return( com );
		}

	static	Soccer_Command	No_Command()
		{
			Soccer_Command	com;
			com.no_command();
			return( com );
		}

	static	Soccer_Command	Bye()
		{
			Soccer_Command	com;
			com.bye();
			return( com );
		}

	static	Soccer_Command	Illegal()
		{
			Soccer_Command	com;
			com.illegal();
			return( com );
		}
};


#endif	/* SOCCER_COMMAND_H_INCLUDED */
