#ifndef	   SSERVER_PARAM_H_INCLUDED
#define	   SSERVER_PARAM_H_INCLUDED

#include  "server_raw_info.h"
#include  "d2_vector.h"
#include  "s_basic.h"
#include  "ip_address.h"
#include  "range.h"
#include  <vector>

class  SServer_Param
{
public:
	static	const	ip_port_number_t	DEFAULT_PORT;

	static	const	double	DEFAULT_BALL_SIZE;
	static	const	double	DEFAULT_PLAYER_SIZE;

	static	const	double	DEFAULT_BALL_DECAY;
	static	const	double	DEFAULT_PLAYER_DECAY;

	static	const	double	DEFAULT_BALL_SPEED_MAX;
	static	const	double	DEFAULT_PLAYER_SPEED_MAX;

	static	const	double	DEFAULT_BALL_RAND;
	static	const	double	DEFAULT_PLAYER_RAND;

	static	const	double	DEFAULT_DASH_POWER_RATE;
	static	/*XXX*/	double	DEFAULT_KICK_POWER_RATE;

	static	const	double	DEFAULT_CATCHABLE_AREA_L;
	static	const	double	DEFAULT_CATCHABLE_AREA_W;
	static	const	int	DEFAULT_CATCH_BAN_CYCLE;

	static	const	double	DEFAULT_KICKABLE_MARGIN;

	static	/*XXX*/	double	DEFAULT_STAMINA_MAX;

	static	/*XXX*/	double	DEFAULT_STAMINA_INC_MAX;

	static	const	double	DEFAULT_EFFORT_DEC_THR;
	static	const	double	DEFAULT_EFFORT_DEC;
	static	const	double	DEFAULT_EFFORT_INC_THR;
	static	const	double	DEFAULT_EFFORT_INC;
	static	const	double	DEFAULT_EFFORT_MIN;

	static	const	double	DEFAULT_RECOVER_DEC_THR;
	static	const	double	DEFAULT_RECOVER_DEC;
	static	const	double	DEFAULT_RECOVER_MIN;

	static	const	size_t	DEFAULT_SAY_MESSAGE_LENGTH;

	static	const	double	DEFAULT_MAX_POWER;
	static	const	double	DEFAULT_MIN_POWER;

	static	const	double	DEFAULT_MAX_MOMENT;
	static	const	double	DEFAULT_MIN_MOMENT;

	static	const	double	DEFAULT_INERTIA_MOMENT;

	static	const	int	DEFAULT_RECV_STEP;

	static	const	double	DEFAULT_SHORT_SENSOR_LENGTH;

	static	const	Angle	DEFAULT_MAX_NECK_MOMENT;
	static	const	Angle	DEFAULT_MIN_NECK_MOMENT;
	static	const	Angle	DEFAULT_MAX_NECK_ANGLE;
	static	const	Angle	DEFAULT_MIN_NECK_ANGLE;

	static	const	int	DEFAULT_HALF_TIME;
	static	const	int	DEFAULT_SIMULATOR_STEP;

	static	const	double	DEFAULT_QUANTIZE_STEP;
	static	const	double	DEFAULT_QUANTIZE_STEP_L;

	static	const	double	DEFAULT_GOAL_WIDTH;

	static	const	double	DEFAULT_OFFSIDE_ACTIVE_AREA_SIZE;
	static	const	double	DEFAULT_OFFSIDE_KICK_MARGIN;

public:
	static	const	size_t	SSERVER_MAX_MESSAGE_LENGTH;


private:
	void		make_cache() const;

	static	const	size_t	N_STEP_TO_REACH_CACHE_SIZE;
	mutable	std::vector<double>	n_step_to_reach_cache;

public:
	 SServer_Param() throw();
	~SServer_Param() throw();

	// XXX
	void	overwrite_server_param( const Server_Raw_Server_Param_Info & );
	void	overwrite_player_param( const Server_Raw_Player_Param_Info & );
	void	overwrite_server_param( double  kick_power_rate ,
					double  stamina_max ,
					double  stamina_inc_max );

	ip_port_number_t	PORT() const throw();

	double	BALL_SIZE() const throw();
	double	PLAYER_SIZE() const throw();
	double	BALL_DECAY() const throw();
	double	PLAYER_DECAY() const throw();
	double	PLAYER_SPEED_MAX() const throw();
	double	BALL_SPEED_MAX() const throw();
	double	BALL_RAND() const throw();
	double	PLAYER_RAND() const throw();
	double	DASH_POWER_RATE() const throw();
	double	KICK_POWER_RATE() const throw();
	double	CATCHABLE_AREA_L() const throw();
	double	CATCHABLE_AREA_W() const throw();
	int	CATCH_BAN_CYCLE() const throw();
	double	KICKABLE_MARGIN() const throw();
	double	STAMINA_MAX() const throw();
	double	STAMINA_INC_MAX() const throw();
	double	EFFORT_DEC_THR() const throw();
	double	EFFORT_DEC() const throw();
	double	EFFORT_INC_THR() const throw();
	double	EFFORT_INC() const throw();
	double	EFFORT_MIN() const throw();
	double	RECOVER_DEC_THR() const throw();
	double	RECOVER_DEC() const throw();
	double	RECOVER_MIN() const throw();
	size_t	SAY_MESSAGE_LENGTH() const throw();
	double	MAX_POWER() const throw();
	double	MIN_POWER() const throw();
	double	MAX_MOMENT() const throw();
	double	MIN_MOMENT() const throw();
	double	INERTIA_MOMENT() const throw();
	int	RECV_STEP() const throw();
	double	SHORT_SENSOR_LENGTH() const throw();
	Angle	MAX_NECK_MOMENT() const throw();
	Angle	MIN_NECK_MOMENT() const throw();
	Angle	MAX_NECK_ANGLE() const throw();
	Angle	MIN_NECK_ANGLE() const throw();
	int	HALF_TIME() const throw();
	int	SIMULATOR_STEP() const throw();
	double	QUANTIZE_STEP() const throw();
	double	QUANTIZE_STEP_L() const throw();
	double	GOAL_WIDTH() const throw();
	double	OFFSIDE_ACTIVE_AREA_SIZE() const throw();
	double	OFFSIDE_KICK_MARGIN() const throw();


	double	half_time_step() const throw();

	double	field_half_length() const throw();
	double	field_length() const throw();
	double	field_half_width() const throw();
	double	field_width() const throw();
	double	field_diagonal_length() const throw();
	double	center_circle_r() const throw();
	double	penalty_area_length() const throw();
	double	penalty_area_half_width() const throw();
	double	our_penalty_area_line_x() const throw();
	double	opponent_penalty_area_line_x() const throw();
	double	goal_area_length() const throw();
	double	goal_area_half_width() const throw();
	double	our_goal_area_line_x() const throw();
	double	opponent_goal_area_line_x() const throw();
	double	goal_width() const throw();
	double	goal_half_width() const throw();

	double	kick_off_clear_distance() const throw();
	double	free_kick_clear_distance() const throw();


	double	kickable_distance() const throw();

	double	catchable_length() const throw();
	double	catchable_width() const throw();
	double	catchable_half_width() const throw();
	double	catchable_diagona_distance() const throw();

	double	player_speed_max_max() const throw();

	Double_Range	server_stamina_info_to_real_range( double  stamina )
								const throw();

	Double_Range	server_effort_info_to_real_range( double  effort )
								const throw();

	Angle_Range	server_neck_angle_info_to_real_range
				( const Angle &  neck_angle ) const throw();

	Double_Range	server_speed_info_to_real_range( double  speed )
								const throw();

	double	dash_power_to_stamina_dec( double  dash_power ) const throw();

	double	stamina_safe_threshold( bool  use_back_dash = true )
								const throw();

	double	stamina_safe_dash_power( double  stamina ,
					 bool  use_back_dash = true )
								const throw();

	double	stamina_safe_dash_power_filter( double  stamina ,
						double  dash_power )
								const throw();

	D2_Vector	initial_position( S_Side_LR  side ,
					  int  player_number ) const throw();

	D2_Vector	ball_basic_point_n_step_later
					( const D2_Vector &  current_point ,
					  const D2_Vector &  vec ,
					  int  n ) const throw();

	double		n_step_for_ball_move( double  distance ,
					      double  ball_speed )
							const throw();

	double		ball_reach_distance( double  ball_speed )
							const throw();

	double		ball_reach_distance_to_ball_speed( double  dist )
							const throw();

	D2_Vector	ball_reach_point( const D2_Vector &  current_point ,
					  const D2_Vector &  vec )
							const throw();

	D2_Vector	player_basic_point_n_step_later
					( const D2_Vector &  current_point ,
					  const D2_Vector &  vec ,
					  int  n ) const throw();

	double	required_dash_power_to_reach_next_step( double  dist )
								const throw();
	double	player_stop_power( double  current_speed ) const throw();

	double	dash_power_to_accel( double  dash_power ) const throw();

	Angle	actual_moment( const Angle &  dir ,
			       double  self_speed ,
			       bool *  succeeded = 0 ) const throw();

	Angle	turn_moment_to_angle( const Angle &  dir ,
				      double  self_speed ) const throw();

	double	kick_accel_to_power( double  accel ,
				     double  ball_dist = 0.0 ,
				     const Angle &  ball_dir = Radian(0.0) ,
				     bool *  succeeded = 0 ) const throw();

	double	kick_power_to_accel( double  power ,
				     double  ball_dist = 0.0 ,
				     const Angle &  ball_dir = Radian(0.0) )
								const throw();

	double	kick_power_to_ball_reach_distance( double  power ,
						   double  ball_dist ,
						   const Angle &  ball_dir )
								const throw();
	long	n_step_to_turn_body( const Angle &  angle ,
				     double  speed ) const throw();
	long	n_step_to_reach( double  dist ) const throw();
};


#endif	/* SSERVER_PARAM_H_INCLUDED */
