#include  "client_debug_view.h"
#include  "debug_server_connection.h"
#include  "field_recog_interface.h"
#include  "s_basic.h"
#include  "d2_region.h"
#include  <strstream>
#include  <iostream>
#include  <cfloat>
#include  <cstring>
#include  <stdexcept>
#include  <cassert>

using namespace std;

Client_Debug_View::Client_Debug_View( const SServer_Param *  param )
	: param( param ) ,
	  b_comment() , t_comment( MAX_PLAYER ) , o_comment( MAX_PLAYER ) ,
	  have_target_teammate_flag( false ) , target_teammate( -1 ) ,
	  have_target_point_flag( false ) , target_point() ,
	  have_message_flag( false ) , message()
{
}

Client_Debug_View::~Client_Debug_View()
{
}

void   Client_Debug_View::set_field_snapshot
       ( const ref_count_ptr<const Field_Recog_Abstract
					::Field_Recog_Snapshot> &  f )
{
	field = f;
}

ref_count_ptr<const Field_Recog_Abstract::Field_Recog_Snapshot>
	Client_Debug_View::field_snapshot() const
{
	return( field );
}

const std::string &  Client_Debug_View::ball_comment() const
{
	return( b_comment );
}

const std::string &  Client_Debug_View::teammate_comment( int  num ) const
{
	assert( 1 <= num && num <= MAX_PLAYER );
	return( t_comment[num -1] );
}

const std::string &  Client_Debug_View::opponent_comment( int  num ) const
{
	assert( 1 <= num && num <= MAX_PLAYER );
	return( o_comment[num -1] );
}


bool   Client_Debug_View::encode( std::string *  buf ) const
try
{
	if ( ! field )
	{
		*buf = "";

		return( false );
	}


	static	char	str_buf[Debug_Server_Connection::MAX_MESSAGE_LENGTH];
	ostrstream	str( str_buf , sizeof( str_buf ) );

#if 0
	str.precision( DBL_DIG );
#endif

	Field_Recog_Interface	f( field );

	string	side;
	switch( f.our_team().side_lr() )
	{
	case S_Side_LR::Left_Side:
		side = "left";
		break;

	case S_Side_LR::Right_Side:
		side = "right";
		break;

	case S_Side_LR::Unknown:
	default:
		*buf = "";
		return( false );
	}

	int	my_uniform_number = f.self().player_number();

	str << "((debug (format-version 1))";

	str << " (time " << f.current_time().main_step() << ")";

	str << " (self"
	    <<  " (side " << side << ")"
	    <<  " (uniform-number " << my_uniform_number << ")"
	    <<  " (coordinate "
	    <<     f.self().coordinate().x() << " "
	    <<     f.self().coordinate().y() << ")"
	    <<  " (body-direction "
	    <<     f.self().body_angle().degree() << ")"
	    <<  " (neck-direction "
	    <<     f.self().face_angle().degree() << "))";

	if ( f.ball().coordinate().have_info() )
	{
		str << " "
		    << "(ball "
		    <<  "(coordinate "
		    <<    f.ball().coordinate().x() << " "
		    <<    f.ball().coordinate().y() << ")";

		if ( f.ball().velocity().have_info() )
		{
			str << " "
			    << "(velocity "
			    <<   f.ball().velocity().x() << " "
			    <<   f.ball().velocity().y() << ")";
		}

		str << " (comment "
		    <<    f.ball().coordinate().accuracy_level() << ")";

		str << ")";
	}


	for ( int  i = 1  ;  i <= MAX_PLAYER  ;  i ++ )
	{
		if ( f.teammate(i).coordinate().have_info() )
		{
			if ( i == my_uniform_number )
			{
				continue;
			}

			str << " "
			    << "(teammate"
			    << " (uniform-number " << i << ")"
			    << " (coordinate "
			    <<	  f.teammate(i).coordinate().x() << " "
			    <<    f.teammate(i).coordinate().y() << ")"
			    << " (comment "
			    <<    f.teammate(i).coordinate().accuracy_level()
			    << ")";

			if ( f.teammate(i).body_angle().accuracy_check() )
			{
				str << " "
				    << "(body-direction "
				    <<   f.teammate(i).body_angle().degree()
				    << ")";
			}

			str << ")";
		}
	}

	for ( int  i = 1  ;  i <= MAX_PLAYER  ;  i ++ )
	{
		if ( f.opponent(i).coordinate().have_info() )
		{
			str << " "
			    << "(opponent"
			    << " (uniform-number " << i << ")"
			    << " (coordinate "
			    <<    f.opponent(i).coordinate().x() << " "
			    <<    f.opponent(i).coordinate().y() << ")"
			    << " (comment "
			    <<    f.opponent(i).coordinate().accuracy_level()
			    << ")";

			if ( f.opponent(i).body_angle().accuracy_check() )
			{
				str << " "
				    << "(body-direction "
				    <<   f.opponent(i).body_angle().degree()
				    << ")";
			}

			str << ")";
		}
	}

	for ( size_t  i = 0  ;  i < f.n_unknown_player()  ;  i ++ )
	{
		if ( f.unknown_player(i).coordinate().have_info() )
		{
			str << " "
			    << "(unknown-player"
			    << " (coordinate "
			    <<    f.unknown_player(i).coordinate().x()
			    <<   " "
			    <<    f.unknown_player(i).coordinate().y()
			    <<  "))";
		}
	}

#if 0
	str << " "
	    << "(defence-line " << f.our_team().defence_line() << ")";

	str << " "
	    << "(offence-line " << f.our_team().offence_line() << ")";
#endif

	// Warning: This protocol is only in transition period.
	//          Don't use (or use carefully) this protocol !!
	if ( this -> have_target_teammate() )
	{
		str << " (unofficial-target-teammate "
		    <<    this -> get_target_teammate() << ")";
	}

	// Warning: This protocol is only in transition period.
	//          Don't use (or use carefully) this protocol !!
	if ( this -> have_target_point() )
	{
		str << " (unofficial-target-point "
		    <<    this -> get_target_point().x() << " "
		    <<    this -> get_target_point().y() << ")";
	}

	// Warning: This protocol is only in transition period.
	//          Don't use (or use carefully) this protocol !!
	if ( this -> have_message() )
	{
		str << " (unofficial-message \""
		    <<    this -> get_message() << "\")";
	}

	str << ")" << ends;


	*buf = str.str();

	return( true );
}
catch( const std::bad_alloc & )
{
	cerr << "Not enough memory for send debug info !!" << endl;

	*buf = "";

	return( false );
}


bool   Client_Debug_View::decode( const std::string &  buf )
{
	ref_count_ptr<Field_Recog_Abstract::Field_Recog_Snapshot>	f
		= new Field_Recog_Abstract::Field_Recog_Snapshot( param );

	int	read_offset = 0;

	if ( std::sscanf( buf.c_str() ,
			  " ( ( debug ( format-version 1 ) ) %n" ,
			  &read_offset) != 0 )
	{
		std::cerr << "bad format-version" << endl;

		return( false );
	}


	for(;;)
	{


	    // teammate player
	    {
		int	n_read = 0;
		if ( std::sscanf( buf.c_str() + read_offset ,
				  " ( teammate %n" , &n_read ) == 0
		     && (n_read != 0) )
		{
			read_offset += n_read;

			int	uniform_number = -1;
			for(;;)
			{
			    // uniform-number
			    {
				int	n = 0;

				if ( std::sscanf( buf.c_str() + read_offset ,
						  "( uniform-number %d ) %n" ,
						  &uniform_number ,
						  &n ) == 1
				     && (n != 0) )
				{
					read_offset += n;

					if ( uniform_number < 1
					  || uniform_number > MAX_PLAYER )
					{
						std::cerr
						 << "bad uniform-number"
						 << endl;
						return( false );
					}

					continue;
				}
			    }

			    // coordinate
			    {
				int	n = 0;
				double	player_x = 0.0;
				double	player_y = 0.0;
				if ( std::sscanf
				     ( buf.c_str() + read_offset ,
				       "( coordinate %lf %lf ) %n" ,
				       &player_x , &player_y ,
				       &n ) == 2
				     && (n != 0) )
				{
					read_offset += n;

					if ( uniform_number < 1
					  || uniform_number > MAX_PLAYER )
					{
						std::cerr
						 << "uniform-number must be "
						    "specified before "
						    "coordinate" << endl;

						return( false );
					}

					f -> teammate[uniform_number - 1]
					.coordinate
					 .set( D2_Region::universal_region() ,
					       D2_Vector( player_x ,
							  player_y ) );

					f -> teammate[uniform_number - 1]
					 .coordinate_accuracy = 0;

					continue;
				}
			    }

			    // body-direction
			    {
				int	n = 0;
				double	body_direction = 0.0;
				if ( std::sscanf
				     ( buf.c_str() + read_offset ,
				       " ( body-direction %lf ) %n" ,
				       &body_direction , &n ) == 1
				     && (n != 0) )
				{
					read_offset += n;

					f -> body.my_body_angle
					      .set( Degree(body_direction) ,
						    Degree(body_direction) ,
						    Degree(body_direction) );

					if ( uniform_number < 1
					  || uniform_number > MAX_PLAYER )
					{
						std::cerr
						 << "body_direction must be "
						    "specified before "
						    "body-direction" << endl;
						return( false );
					}

					f -> teammate[uniform_number - 1]
					 .body_angle
					  .set( Degree(body_direction) ,
						Degree(body_direction) ,
						Degree(body_direction) );

					continue;
				}
			    }

			    // comment
			    {
				int	n = 0;
				char	buffer[256 + 1];

				if ( std::sscanf
				     ( buf.c_str() + read_offset ,
				       "( comment %256[^) ] ) %n" ,
				       buffer , &n ) == 1
				     && (n != 0) )
				{
					read_offset += n;
					if ( uniform_number < 1
					     || uniform_number > MAX_PLAYER )
					{
						std::cerr
						 << "uniform-number must be "
						    "specified before comment"
						 << endl;

						return( false );
					}

					this -> t_comment[uniform_number - 1]
								    = buffer;

					continue;
				}
			    }

			    // close paren
			    {
				    int	n = 0;
				    if ( std::sscanf
					 ( buf.c_str() + read_offset ,
					   " ) %n" , &n ) == 0
					 && (n != 0) )
				    {
					    read_offset += n;
					    break;
				    }
			    }

			    return( false );
			}

			continue;
		}
	    }


	    // opponent player
	    {
		int	n_read = 0;
		if ( std::sscanf( buf.c_str() + read_offset ,
				  " ( opponent %n" , &n_read ) == 0
		     && (n_read != 0) )
		{
			read_offset += n_read;

			int	uniform_number = -1;
			for(;;)
			{
			    // uniform-number
			    {
				int	n = 0;

				if ( std::sscanf( buf.c_str() + read_offset ,
						  "( uniform-number %d ) %n" ,
						  &uniform_number ,
						  &n ) == 1
				     && (n != 0) )
				{
					read_offset += n;

					if ( uniform_number < 1
					  || uniform_number > MAX_PLAYER )
					{
						std::cerr
						 << "bad uniform-number"
						 << endl;
						return( false );
					}

					continue;
				}
			    }

			    // coordinate
			    {
				int	n = 0;
				double	player_x = 0.0;
				double	player_y = 0.0;
				if ( std::sscanf
				     ( buf.c_str() + read_offset ,
				       "( coordinate %lf %lf ) %n" ,
				       &player_x , &player_y ,
				       &n ) == 2
				     && (n != 0) )
				{
					read_offset += n;

					if ( uniform_number < 1
					  || uniform_number > MAX_PLAYER )
					{
						std::cerr
						 << "uniform-number must be "
						    "specified before "
						    "coordinate" << endl;

						return( false );
					}

					f -> opponent[uniform_number - 1]
					.coordinate
					 .set( D2_Region::universal_region() ,
						D2_Vector( player_x ,
							   player_y ) );

					f -> opponent[uniform_number - 1]
					 .coordinate_accuracy = 0;

					continue;
				}
			    }

			    // body-direction
			    {
				int	n = 0;
				double	body_direction = 0.0;
				if ( std::sscanf
				     ( buf.c_str() + read_offset ,
				       " ( body-direction %lf ) %n" ,
				       &body_direction , &n ) == 1
				     && (n != 0) )
				{
					read_offset += n;

					f -> body.my_body_angle
					      .set( Degree(body_direction) ,
						    Degree(body_direction) ,
						    Degree(body_direction) );

					if ( uniform_number < 1
					  || uniform_number > MAX_PLAYER )
					{
						std::cerr
						 << "body_direction must be "
						    "specified before "
						    "body-direction" << endl;
						return( false );
					}

					f -> opponent[uniform_number - 1]
					 .body_angle
					  .set( Degree(body_direction) ,
						Degree(body_direction) ,
						Degree(body_direction) );

					continue;
				}
			    }

			    // comment
			    {
				int	n = 0;
				char	buffer[256 + 1];

				if ( std::sscanf
				     ( buf.c_str() + read_offset ,
				       "( comment %256[^) ] ) %n" ,
				       buffer , &n ) == 1
				     && (n != 0) )
				{
					read_offset += n;

					if ( uniform_number < 1
					     || uniform_number > MAX_PLAYER )
					{
						std::cerr
						 << "uniform-number must be "
						    "specified before comment"
						 << endl;

						return( false );
					}

					this -> o_comment[uniform_number - 1]
								    = buffer;
					continue;
				}
			    }

			    // close paren
			    {
				    int	n = 0;
				    if ( std::sscanf
					 ( buf.c_str() + read_offset ,
					   " ) %n" , &n ) == 0
					 && (n != 0) )
				    {
					    read_offset += n;
					    break;
				    }
			    }

			    return( false );
			}

			continue;
		}
	    }


	    // unknown player
	    {
		int	n_read = 0;
		if ( std::sscanf( buf.c_str() + read_offset ,
				  " ( unknown-player %n" , &n_read ) == 0
		     && (n_read != 0) )
		{
			read_offset += n_read;

			for(;;)
			{
			    // coordinate
			    {
				int	n = 0;
				double	player_x = 0.0;
				double	player_y = 0.0;
				if ( std::sscanf
				     ( buf.c_str() + read_offset ,
				       "( coordinate %lf %lf ) %n" ,
				       &player_x , &player_y ,
				       &n ) == 2
				     && (n != 0) )
				{
					read_offset += n;

					Field_Recog_Abstract::Player_Info
						pl;

					pl.coordinate
					 .set( D2_Region::universal_region() ,
					       D2_Vector( player_x ,
							  player_y ) );

					f -> unknown_player.push_back( pl );
					continue;
				}
			    }

			    // close paren
			    {
				    int	n = 0;
				    if ( std::sscanf
					 ( buf.c_str() + read_offset ,
					   " ) %n" , &n ) == 0
					 && (n != 0) )
				    {
					    read_offset += n;
					    break;
				    }
			    }

			    return( false );
			}

			continue;
		}
	    }

	    // time
	    {
		long	current_time = -1;
		int	n_read = 0;

		if ( std::sscanf( buf.c_str() + read_offset ,
				  " ( time %ld ) %n" ,
				  &current_time , &n_read ) == 1
		     && (n_read != 0) )
		{
			f -> game_state.current_time.set( current_time );

			read_offset += n_read;

			continue;
		}
	    }


	    // ball
	    {
		int	n_read = 0;
		if ( std::sscanf( buf.c_str() + read_offset ,
				  " ( ball %n" , &n_read ) == 0
		     && (n_read != 0) )
		{
			read_offset += n_read;

			for(;;)
			{
			    // coordinate
			    {
				int	n = 0;
				double	ball_x = 0.0;
				double	ball_y = 0.0;
				if ( std::sscanf
				     ( buf.c_str() + read_offset ,
				       "( coordinate %lf %lf ) %n" ,
				       &ball_x , &ball_y ,
				       &n ) == 2
				     && (n != 0) )
				{
					read_offset += n;
					f -> ball.coordinate
					 .set( D2_Region::universal_region() ,
					       D2_Vector( ball_x , ball_y ) );
					f -> ball.coordinate_accuracy = 0;

					continue;
				}
			    }

			    // velocity
			    {
				int	n = 0;
				double	ball_velocity_x = 0.0;
				double	ball_velocity_y = 0.0;
				if ( std::sscanf
				     ( buf.c_str() + read_offset ,
				       "( velocity %lf %lf ) %n" ,
				       &ball_velocity_x , &ball_velocity_y ,
				       &n ) == 2
				     && (n != 0) )
				{
					read_offset += n;
					f -> ball.velocity
					 .set( D2_Region::universal_region() ,
					       D2_Vector( ball_velocity_x ,
							  ball_velocity_y ) );
					f -> ball.velocity_accuracy = 0;

					continue;
				}
			    }

			    // comment
			    {
				int	n = 0;
				char	buffer[256 + 1];
				if ( std::sscanf
				     ( buf.c_str() + read_offset ,
				       "( comment %256[^) ] ) %n" ,
				       buffer , &n ) == 1
				     && (n != 0) )
				{
					read_offset += n;
					this -> b_comment = buffer;

					continue;
				}
			    }

			    // close paren
			    {
				    int	n = 0;
				    if ( std::sscanf
					 ( buf.c_str() + read_offset ,
					   " ) %n" , &n ) == 0
					 && (n != 0) )
				    {
					    read_offset += n;
					    break;
				    }
			    }

			    return( false );
			}

			continue;
		}
	    }


	    // self
	    {
		int	n_read = 0;
		if ( std::sscanf( buf.c_str() + read_offset ,
				  " ( self %n" , &n_read ) == 0
		     && (n_read != 0) )
		{
			read_offset += n_read;

			int	uniform_number = -1;
			for(;;)
			{
			    // side
			    {
				int	n = 0;
				char	side[256 + 1];
				if ( std::sscanf( buf.c_str() + read_offset ,
						  "( side %256[^) ] ) %n" ,
						  side , &n ) == 1
				     && (n != 0) )
				{
					read_offset += n;
					if ( std::strcmp( side ,
							  "left" ) == 0 )
					{
						f -> game_state
							.game_info.our_side
						       = S_Side_LR::Left_Side;
					}
					else if ( std::strcmp( side ,
							       "right" ) == 0 )
					{
						f -> game_state
						       .game_info.our_side
						      = S_Side_LR::Right_Side;
					}
					else
					{
						std::cerr << "bad team side"
							  << endl;
						return( false );
					}

					continue;
				}
			    }

			    // uniform-number
			    {
				int	n = 0;

				if ( std::sscanf( buf.c_str() + read_offset ,
						  "( uniform-number %d ) %n" ,
						  &uniform_number ,
						  &n ) == 1
				     && (n != 0) )
				{
					read_offset += n;

					if ( uniform_number < 1
					  || uniform_number > MAX_PLAYER )
					{
						std::cerr
						 << "bad uniform-number"
						 << endl;
						return( false );
					}

					f -> game_state.game_info
					      .self_player_number
						= uniform_number;

					continue;
				}
			    }

			    // coordinate
			    {
				int	n = 0;
				double	player_x = 0.0;
				double	player_y = 0.0;
				if ( std::sscanf( buf.c_str() + read_offset ,
						  "( coordinate %lf %lf ) %n" ,
						  &player_x , &player_y ,
						  &n ) == 2
				     && (n != 0) )
				{
					read_offset += n;

					f -> body.my_coordinate
					 .set( D2_Region::universal_region() ,
					       D2_Vector( player_x ,
							  player_y ) );

					if ( uniform_number < 1
					  || uniform_number > MAX_PLAYER )
					{
						std::cerr
						 << "uniform-number must be "
						    "specified before "
						    "coordinate" << endl;

						return( false );
					}

					f -> teammate[uniform_number - 1]
					.coordinate
					 .set( D2_Region::universal_region() ,
						D2_Vector( player_x ,
							   player_y ) );

					f -> teammate[uniform_number - 1]
					 .coordinate_accuracy = 0;

					continue;
				}
			    }

			    // body-direction
			    {
				int	n = 0;
				double	body_direction = 0.0;
				if ( std::sscanf
				     ( buf.c_str() + read_offset ,
				       " ( body-direction %lf ) %n" ,
				       &body_direction , &n ) == 1
				     && (n != 0) )
				{
					read_offset += n;

					f -> body.my_body_angle
					      .set( Degree(body_direction) ,
						    Degree(body_direction) ,
						    Degree(body_direction) );

					if ( uniform_number < 1
					  || uniform_number > MAX_PLAYER )
					{
						std::cerr
						 << "body_direction must be "
						    "specified before "
						    "body-direction" << endl;
						return( false );
					}

					f -> teammate[uniform_number - 1]
					 .body_angle
					  .set( Degree(body_direction) ,
						Degree(body_direction) ,
						Degree(body_direction) );

					continue;
				}
			    }

			    // neck-direction
			    {
				int	n = 0;
				double	neck_direction = 0.0;
				if ( std::sscanf
				     ( buf.c_str() + read_offset ,
				       " ( neck-direction %lf ) %n" ,
				       &neck_direction , &n ) == 1
				     && (n != 0) )
				{
					read_offset += n;

					f -> body.neck_angle
					      .set( Degree(neck_direction) ,
						    Degree(neck_direction) ,
						    Degree(neck_direction) );

					if ( uniform_number < 1
					  || uniform_number > MAX_PLAYER )
					{
						std::cerr
						 << "neck-direction must be "
						    "specified before "
						    "neck-direction"
						 << endl;
						return( false );
					}

					f -> teammate[uniform_number - 1]
					 .face_angle
					  .set( Degree(neck_direction) ,
						Degree(neck_direction) ,
						Degree(neck_direction) );

					continue;
				}
			    }

			    // view-mode
			    {
				int	n = 0;
				char	view_width[256];
				char	view_quality[256];
				if ( std::sscanf
				     ( buf.c_str() + read_offset ,
				       " ( view-mode "
				        "%256[^) ] %256[^) ] ) %n" ,
				       view_width , view_quality , &n ) == 2
				     && (n != 0) )
				{
					read_offset += n;

					if ( strcmp( view_width ,
						     "narrow" ) == 0 )
					{
						f -> body.view_width
						    .set( View_Width::Narrow );
					}
					else if ( strcmp( view_width ,
							  "normal" ) == 0 )
					{
						f -> body.view_width
						    .set( View_Width::Normal );
					}
					else if ( strcmp( view_width ,
							  "wide" ) == 0 )
					{
						f -> body.view_width
						    .set( View_Width::Wide );
					}
					else
					{
						std::cerr
						 << "bad view-width: "
						 << "candidates = "
						 << "[wide|normal|narrow]"
						 << endl;

						return( false );
					}

					if ( strcmp( view_quality ,
						     "high" ) == 0 )
					{
						f -> body.view_quality
						    .set( View_Quality::High );
					}
					else if ( strcmp( view_quality ,
							  "normal" ) == 0 )
					{
						f -> body.view_quality
						    .set( View_Quality::Low );
					}
					else
					{
						std::cerr
						 << "bad view-quality: "
						 << "candidates = "
						 << "[high|low]"
						 << endl;

						return( false );
					}

					continue;
				}
			    }

			    // close paren
			    {
				    int	n = 0;
				    if ( std::sscanf
					 ( buf.c_str() + read_offset ,
					   " ) %n" , &n ) == 0
					 && (n != 0) )
				    {
					    read_offset += n;
					    break;
				    }
			    }

			    return( false );
			}

			continue;
		}
	    }


	    // Warning: This protocol is only in transition period.
	    //          Don't use (or use carefully) this protocol !!
	    // target-player
	    {
		int	n_read = 0;
		int	pl_num;
		if ( std::sscanf( buf.c_str() + read_offset ,
				  " ( unofficial-target-teammate %d ) %n" ,
				  &pl_num , &n_read ) == 1
		     && (n_read != 0) )
		{
			read_offset += n_read;
			this -> set_target_teammate( pl_num );
			continue;
		}
	    }

	    // Warning: This protocol is only in transition period.
	    //          Don't use (or use carefully) this protocol !!
	    // target-point
	    {
		int	n_read = 0;
		double	target_x;
		double	target_y;

		if ( std::sscanf( buf.c_str() + read_offset ,
				  " ( unofficial-target-point %lf %lf ) %n" ,
				  &target_x , &target_y , &n_read ) == 2
		     && (n_read != 0) )
		{
			read_offset += n_read;
			this -> set_target_point( D2_Vector( target_x ,
							     target_y ) );
			continue;
		}
	    }

	    // Warning: This protocol is only in transition period.
	    //          Don't use (or use carefully) this protocol !!
	    // message
	    {
		int	n_read = 0;
		char	mes[256 + 1];
		mes[sizeof(mes) - 1] = '\0';

		if ( std::sscanf( buf.c_str() + read_offset ,
				  " ( unofficial-message \"%256[^\"]\" ) %n" ,
				  mes , &n_read ) == 1
		     && (n_read != 0) )
		{
			read_offset += n_read;
			this -> set_message( mes );
			continue;
		}
	    }


	    // close paren
	    {
		int	n_read = 0;
		if ( std::sscanf( buf.c_str() + read_offset ,
				  " ) %n" ,
				  &n_read ) == 0
		     && (n_read != 0) )
		{
			read_offset += n_read;
			break;
		}
	    }

	    return( false );
	}


	// if message is still remained,
	//   treat this message as a bad format one.
	if ( *(buf.c_str() + read_offset) != '\0'
	  || (   *(buf.c_str() + read_offset    ) == '\n'
	      && *(buf.c_str() + read_offset + 1) == '\0' ) )
	{
		return( false );
	}

	field = f;

	return( true );
}

// XXX
void   Client_Debug_View::set_target_teammate( int  num ) const
{
	this -> target_teammate = num;
	this -> have_target_teammate_flag = true;
}

// XXX
bool   Client_Debug_View::have_target_teammate() const
{
	return( this -> have_target_teammate_flag );
}

// XXX
int    Client_Debug_View::get_target_teammate() const
{
	return( this -> target_teammate );
}


// XXX
void   Client_Debug_View::set_target_point( const D2_Vector &  point ) const
{
	this -> target_point = point;
	this -> have_target_point_flag = true;
}

// XXX
bool   Client_Debug_View::have_target_point() const
{
	return( this -> have_target_point_flag );
}

// XXX
D2_Vector  Client_Debug_View::get_target_point() const
{
	return( this -> target_point );
}


// XXX
void   Client_Debug_View::set_message( const std::string &  mes ) const
{
	this -> message = mes;
	this -> have_message_flag = true;
}

// XXX
bool   Client_Debug_View::have_message() const
{
	return( this -> have_message_flag );
}

// XXX
std::string  Client_Debug_View::get_message() const
{
	return( this -> message );
}
