#ifndef	   CLIENT_DEBUG_VIEW_H_INCLUDED
#define	   CLIENT_DEBUG_VIEW_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	May 25 2000
// Created:		May 25 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  May 25 2000    base version.
//
//

#include  "field_recog_abstract.h"
#include  "ref_count_ptr.h"
#include  <string>
#include  <vector>

class  Client_Debug_View
{
protected:
	ref_count_ptr<const Field_Recog_Abstract::Field_Recog_Snapshot>	field;
	const SServer_Param *						param;

	std::string			b_comment;
	std::vector<std::string>	t_comment;
	std::vector<std::string>	o_comment;

	// XXX
	mutable	bool			have_target_teammate_flag;
	mutable	int			target_teammate;

	mutable	bool			have_target_point_flag;
	mutable	D2_Vector		target_point;

	mutable	bool			have_message_flag;
	mutable	std::string		message;

public:
	 Client_Debug_View( const SServer_Param * );
	~Client_Debug_View();

	void	set_field_snapshot
		    ( const ref_count_ptr<const Field_Recog_Abstract
						  ::Field_Recog_Snapshot> & );

	ref_count_ptr<const Field_Recog_Abstract::Field_Recog_Snapshot>
		field_snapshot() const;

	const std::string &	ball_comment() const;
	const std::string &	teammate_comment( int  num ) const;
	const std::string &	opponent_comment( int  num ) const;

	// XXX
	void		set_target_teammate( int  num ) const;
	bool		have_target_teammate() const;
	int		get_target_teammate() const;

	// XXX
	void		set_target_point( const D2_Vector & ) const;
	bool		have_target_point() const;
	D2_Vector	get_target_point() const;

	// XXX
	void		set_message( const std::string & ) const;
	bool		have_message() const;
	std::string	get_message() const;

	bool		encode( std::string *  buf ) const;
	bool		decode( const std::string &  buf );
};


#endif	/* CLIENT_DEBUG_VIEW_H_INCLUDED */
