#ifndef	   FIELD_MOMENTARY_INFO_H_INCLUDED
#define	   FIELD_MOMENTARY_INFO_H_INCLUDED

#include  "d2_region.h"
#include  "d2_vector.h"
#include  "range.h"
#include  "angle.h"
#include  "s_basic.h"
#include  <vector>


//
// Region_Info
//
class  Region_Info
{
private:
	bool		have_info;
	D2_Region	r;
	D2_Vector	p;

public:
	Region_Info()
		: have_info( false ) ,
		  r( D2_Region::empty_region() ) ,
		  p() {}

	Region_Info( const D2_Region &  rg , const D2_Vector &  pt )
		: have_info( true ) , r( rg ) , p( pt ) {}

	bool	valid() const
	{
		return( have_info );
	}

	const D2_Region &	region() const
	{
		return( r );
	}

	const D2_Vector &	point() const
	{
		return( p );
	}

	void	set( const D2_Region &  rg ,  const D2_Vector &  pt )
	{
		r = rg;
		p = pt;
		have_info = true;
	}

	void	set( const Region_Info &  rg )
	{
		r = rg.region();
		p = rg.point();
		have_info = rg.valid();
	}

	void	reset()
	{
		have_info = false;
		r = D2_Region::empty_region();
		p = D2_Vector::origin();
	}
};

//
// Angle_Info
//
class  Angle_Info
{
private:
	bool		have_info;
	Angle_Range	r;
	Angle		p;

public:
	Angle_Info() : have_info( false ) ,
		       r( Radian(0.0) , Radian(0.0) ) , p( Radian(0.0) ) {}

	Angle_Info( const Angle &  min , const Angle &  max ,
		    const Angle &  pt )
		: have_info( true ) , r( min , max ) , p( pt ) {}

	bool	valid() const
	{
		return( have_info );
	}

	const Angle &	point() const
	{
		return( p );
	}

	const Angle_Range &	range() const
	{
		return( r );
	}

	void	set( const Angle &  min , const Angle &  max ,
		     const Angle &  pt )
	{
		r.set( min , max );
		p = pt;
		have_info = true;
	}

	void	set( const Angle_Range &  rg ,  const Angle &  pt )
	{
		r = rg;
		p = pt;
		have_info = true;
	}

	void	set( const Angle_Info &  a )
	{
		r = a.range();
		p = a.point();

		have_info = a.have_info;
	}

	void	reset()
	{
		have_info = false;
		r.set( Radian(0.0) , Radian(0.0) );
		p = Radian(0.0);
	}
};


//
// Double_Info
//
class  Double_Info
{
private:
	bool		have_info;
	Double_Range	r;
	double		p;

public:
	Double_Info() : have_info( false ) , r( 0.0 , 0.0 ) , p( 0.0 ) {}

	Double_Info( double  min ,  double  max ,  double  pt )
		: have_info( true ) , r( min , max ) , p( pt ) {}

	bool	valid() const
	{
		return( have_info );
	}

	double	point() const
	{
		return( p );
	}

	const Double_Range &	range() const
	{
		return( r );
	}

	void	set( double  min ,  double  max ,  double  pt )
	{
		r.set( min , max );
		p = pt;
		have_info = true;
	}

	void	set( const Double_Range &  rg ,  double  pt )
	{
		r = rg;
		p = pt;
		have_info = true;
	}

	void	set( const Double_Info &  d )
	{
		r = d.range();
		p = d.point();
		have_info = d.have_info;
	}

	void	reset()
	{
		have_info = false;
		r.set( 0.0 , 0.0 );
		p = 0.0;
	}
};


//
// Bool_Info
//
class  Bool_Info
{
private:
	bool	have_info;
	bool	value;

public:
	Bool_Info()
		: have_info( false ) , value( false )
	{
	}

	Bool_Info( bool  b )
		: have_info( true ) , value( b )
	{
	}

	operator bool() const
	{
		return( value );
	}

	bool	valid() const
	{
		return( have_info );
	}

	Bool_Info &  operator= ( bool  val )
	{
		value     = val;
		have_info = true;

		return( *this );
	}
};


//
// View_Width_Info
//
class  View_Width_Info
{
private:
	bool		have_info;
	View_Width	view_width;

public:
	View_Width_Info() : have_info( false ) ,
			    view_width( View_Width::Normal ) {}

	bool	valid() const
	{
		return( have_info );
	}

	const View_Width &	width() const
	{
		return( view_width );
	}

	void	set( const View_Width &  w )
	{
		view_width = w;
		have_info  = true;
	}
};

//
// View_Quality_Info
//
class  View_Quality_Info
{
private:
	bool		have_info;
	View_Quality	view_quality;

public:
	View_Quality_Info() : have_info( false ) ,
			      view_quality( View_Quality::High ) {}

	bool	valid() const
	{
		return( have_info );
	}

	const View_Quality &	quality() const
	{
		return( view_quality );
	}

	void	set( const View_Quality &  q )
	{
		view_quality = q;
		have_info    = true;
	}
};


#endif	/* FIELD_MOMENTARY_INFO_H_INCLUDED */
