#ifndef	   FIELD_RECOG_H_INCLUDED
#define	   FIELD_RECOG_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Apr 26 2000
// Created:		Apr 26 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Apr 26 2000    base version.
//
//

#include  "field_recog_abstract.h"
#include  "field_momentary_info.h"
#include  "server_raw_info.h"
#include  "sserver_param.h"
#include  "game_info.h"
#include  "soccer_composite_command.h"
#include  "soccer_command.h"
#include  "sserver_time.h"
#include  "time_stamp.h"
#include  "angle.h"
#include  "sight_info_analyzer.h"
#include  <vector>
#include  <cstddef>


class  Field_Recog : public Field_Recog_Abstract
{
protected:
	struct  Info_Buffer
	{
		ref_count_ptr<const Server_Raw_Sight_Info>	sight_info;
		ref_count_ptr<const Server_Raw_Body_Info >	body_info;
		ref_count_ptr<const Server_Raw_Debug_Info>	debug_info;

		long		info_time;
		long		sight_info_time;
		long		body_info_time;
		long		audio_info_time;
		long		whistle_info_time;
		long		debug_info_time;

		Time_Stamp	sight_info_time_stamp;
		Time_Stamp	body_info_time_stamp;
		Time_Stamp	debug_info_time_stamp;

		bool		turn_neck_sent;
		Angle		turn_neck_moment;
		Time_Stamp	turn_neck_time_stamp;

		Soccer_Command	command;

		long		ball_seen_count;

	public:
		Info_Buffer() : info_time( -1 ) ,
				sight_info_time  ( -1 ) ,
				body_info_time   ( -1 ) ,
				audio_info_time  ( -1 ) ,
				whistle_info_time( -1 ) ,
				debug_info_time  ( -1 ) ,
				turn_neck_sent( false ) ,
				command( Soccer_Command::No_Command() ) ,
				ball_seen_count( 0 ) {}

		void	reset()
		{
			sight_info = static_cast<Server_Raw_Sight_Info *>(0);
			body_info  = static_cast<Server_Raw_Body_Info  *>(0);
			debug_info = static_cast<Server_Raw_Debug_Info *>(0);
		}
	};

	struct  Field_Recog_State : public Field_Recog_Snapshot
	{
	protected:
		static	const double	EPS;

	public:
		Info_Buffer	buffer;

	protected:
		void	update_stamina_effort
			  ( const ref_count_ptr<const Field_Recog_State> & ,
			    const SServer_Param *  param ,
			    const Soccer_Composite_Command &  prev_com ,
			    bool  last_command_accepted ,
			    bool  have_current_body_info );

		void	update_speed
			  ( const ref_count_ptr<const Field_Recog_State> & ,
			    const SServer_Param *  param ,
			    const Soccer_Composite_Command &  prev_com ,
			    bool  last_command_accepted ,
			    bool  have_current_body_info );

		void	update_neck_angle
			  ( const ref_count_ptr<const Field_Recog_State> & ,
			    const SServer_Param *  param ,
			    bool  have_current_body_info ,
			    bool  last_turn_neck_accepted );

		void	update_body_angle
			  ( const ref_count_ptr<Sight_Info_Analyzer> & ,
			    const ref_count_ptr<const Field_Recog_State> & ,
			    const SServer_Param *  param ,
			    const Soccer_Composite_Command &  prev_com ,
			    bool  last_command_accepted );

		void	update_self_coordinate
			  ( const ref_count_ptr<Sight_Info_Analyzer> & ,
			    const ref_count_ptr<const Field_Recog_State> & ,
			    const Soccer_Composite_Command &  prev_com ,
			    bool  last_command_accepted );

		void	update_self_velocity
			  ( const ref_count_ptr<const Field_Recog_State> & ,
			    const SServer_Param *  param ,
			    bool  have_current_body_info );

		void	update_ball_coordinate_and_velocity
			  ( const ref_count_ptr<const Field_Recog_State> & ,
			    const SServer_Param *  param ,
			    const ref_count_ptr<Sight_Info_Analyzer> & ,
			    const Soccer_Composite_Command &  prev_com );

		void	update_player_coordinate
			  ( const ref_count_ptr<const Field_Recog_State> & ,
			    const SServer_Param *  param ,
			    const ref_count_ptr<Sight_Info_Analyzer> & );

		void   match_unknown_player
			  ( const ref_count_ptr<const Field_Recog_State> & ,
			    const SServer_Param *  param );

		void	update_offside();

	public:
			 Field_Recog_State( const SServer_Param *  p );

			 Field_Recog_State( const Field_Recog_State &  old );

		virtual	~Field_Recog_State();

		void	update_state
			  ( const ref_count_ptr<const Field_Recog_State> & ,
			    const SServer_Param *  param ,
			    const Soccer_Composite_Command &  prev_com ,
			    bool  true_view );
	};

protected:
	const SServer_Param *			param;
	const bool				self_goalie_flag;
	const bool				true_view_flag;

	ref_count_ptr<Field_Recog_State>	current_state;
	ref_count_ptr<Field_Recog_State>	next_state;

protected:
	void	register_whistle_info(
		  const ref_count_ptr<Field_Recog_State> &  state ,
		  const ref_count_ptr<const Server_Raw_Whistle_Info> &  w ,
		  long  info_time );

public:
		 Field_Recog( const SServer_Param *  param ,
			      const Game_Info &  g_info ,
			      bool  self_goalie_flag = false ,
			      bool  true_view = false );

	virtual	~Field_Recog();

	//
	// protocol between Soccer_Scheduler and Field_Recog
	//
	virtual	void	register_info( const Server_Raw_Info &  info ,
				       const Time_Stamp &  time_stamp );

	// XXX
	virtual	void	turn_neck_sent( const Angle &  moment ,
					const Time_Stamp &  time_stamp );

	// XXX
	virtual	void	base_command_sent( const Soccer_Command &  command ,
					   const Time_Stamp &  time_stamp );

	// XXX
	virtual	void	update();


	//
	// protocol between User and Field_Recog
	//
	virtual	const SServer_Param &		sserver_param() const;

	virtual	ref_count_ptr<const Field_Recog_Snapshot>	snapshot()
									 const;
	virtual	Soccer_Composite_Command	previous_command() const;

	virtual	const Ball_Info &			ball_info() const;
	virtual	const std::vector<Player_Info> &	teammate_info() const;
	virtual	const std::vector<Player_Info> &	opponent_info() const;
	virtual	const std::vector<Player_Info> &	unknown_player_info()
									 const;
	virtual	const Body_Info &			body_info() const;
	virtual	const Sight_Info &			sight_info() const;
	virtual	const Game_State_Info &			game_state_info()
									 const;
	virtual	const Debug_Info &			debug_info() const;
};


#endif	/* FIELD_RECOG_H_INCLUDED */
