#include  "field_recog_abstract.h"

using namespace std;

//
// Field_Recog_Abstract
//

static	SServer_Param	dummy_sserver_param;

Field_Recog_Abstract::Field_Recog_Abstract()
{
}

Field_Recog_Abstract::~Field_Recog_Abstract()
{
}

//
// protocol between Soccer_Scheduler and Field_Recog
//
void   Field_Recog_Abstract::register_info( const Server_Raw_Info & ,
					    const Time_Stamp & )
{
}

void   Field_Recog_Abstract::turn_neck_sent( const Angle & ,
					     const Time_Stamp & )
{
}

void   Field_Recog_Abstract::base_command_sent( const Soccer_Command & ,
						const Time_Stamp & )
{
}

void   Field_Recog_Abstract::update()
{
}


//
// protocol between User and Field_Recog
//
ref_count_ptr<const Field_Recog_Abstract::Field_Recog_Snapshot>
	Field_Recog_Abstract::snapshot() const
{
	return( ref_count_ptr<const Field_Recog_Snapshot>
		  ( new Field_Recog_Snapshot( &dummy_sserver_param ) ) );
}

Soccer_Composite_Command  Field_Recog_Abstract::previous_command() const
{
	return( Soccer_Command::No_Command() );
}




//
// Field_Recog_Snapshot
//
Field_Recog_Abstract::Field_Recog_Snapshot::Field_Recog_Snapshot
					( const SServer_Param *  param )
	: sserver_param( param ) ,
	  teammate( MAX_PLAYER ) , opponent( MAX_PLAYER ) ,
	  unknown_teammate() , unknown_opponent() , unknown_player() ,
	  body() , sight() ,
	  game_state( *param ) ,
	  offence_line( 0.0 ) , defence_line( 0.0 ) ,
	  debug()
{
}

Field_Recog_Abstract::Field_Recog_Snapshot::Field_Recog_Snapshot
					( const Field_Recog_Snapshot &  old )
	: sserver_param( old.sserver_param ) ,
	  ball( old.ball ) ,
	  teammate( old.teammate ) , opponent( old.opponent ) ,
	  unknown_teammate() , unknown_opponent() , unknown_player() ,
	  body( old.body ) , sight( old.sight ) ,
	  game_state( old.game_state ) ,
	  our_team_goalie_number( old.our_team_goalie_number ) ,
	  opponent_team_goalie_number( old.opponent_team_goalie_number ) ,
	  offence_line( old.offence_line ) , defence_line( old.defence_line ) ,
	  debug( old.debug )
{
}

Field_Recog_Abstract::Field_Recog_Snapshot::~Field_Recog_Snapshot()
{
}




//
// Ball_Info
//
Field_Recog_Abstract::Ball_Info::Ball_Info()
	: coordinate() , velocity() ,
	  last_coordinate_info_time( -1 ) , last_velocity_info_time( -1 ) ,
	  in_sight( false ) ,
	  coordinate_accuracy( INVALID_ACCURACY ) ,
	  velocity_accuracy( INVALID_ACCURACY )
{
}


//
// Player_Info
//
Field_Recog_Abstract::Player_Info::Player_Info()
	: coordinate() , velocity() ,
	  body_angle() , face_angle() ,
	  last_info_time( -1 ) ,
	  coordinate_accuracy( INVALID_ACCURACY ) ,
	  velocity_accuracy( INVALID_ACCURACY )
{
}


//
// Sight_Info
//
Field_Recog_Abstract::Sight_Info::Sight_Info()
	: latest_sight() , last_info_time( -1 )
{
}


//
// Game_State_Info
//
Field_Recog_Abstract::Game_State_Info::Game_State_Info
					( const SServer_Param &  param )
	: game_over_flag( false ) ,
	  current_time() ,
	  game_info() ,
	  play_mode_start_time( -1 ) ,
	  last_judgement_time( -1 ) , last_judgement() ,
	  player_type( new Player_Type_Manager( param ) )
{
}

Server_Raw_Whistle_Info
Field_Recog_Abstract::Game_State_Info::play_mode_start_reason() const
{
	if ( play_mode_start_time == last_judgement_time
	  || (play_mode_start_time == last_judgement_time + 1
	      && last_judgement.type == Judgement_Type::Offside) )
	{
		return( last_judgement );
	}
	else
	{
		Server_Raw_Whistle_Info		unknown;

		return( unknown );
	}
}


//
// Debug_Info
//
Field_Recog_Abstract::Debug_Info::Debug_Info()
	: latest_debug_time( -1 ) ,
	  latest_debug( static_cast<Server_Raw_Debug_Info *>(0) )
{
}
