#ifndef	   FIELD_RECOG_ABSTRACT_H_INCLUDED
#define	   FIELD_RECOG_ABSTRACT_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Apr 26 2000
// Created:		Apr 26 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Apr 26 2000    base version.
//
//

#include  "field_momentary_info.h"
#include  "player_type_manager.h"
#include  "server_raw_info.h"
#include  "sserver_param.h"
#include  "game_info.h"
#include  "soccer_composite_command.h"
#include  "soccer_command.h"
#include  "sserver_time.h"
#include  "time_stamp.h"
#include  "ref_count_ptr.h"
#include  <vector>

class  Field_Recog_Abstract
{
public:
	struct  Ball_Info
	{
	public:
		enum{ INVALID_ACCURACY = LONG_MIN };

	public:
		Region_Info	coordinate;
		Region_Info	velocity;

		SServer_Time	last_coordinate_info_time;
		SServer_Time	last_velocity_info_time;

		bool		in_sight;

		long		coordinate_accuracy;
		long		velocity_accuracy;

	public:
		Ball_Info();
	};

	struct  Player_Info
	{
	public:
		enum{ INVALID_ACCURACY = LONG_MIN };

	public:
		Region_Info	coordinate;
		Region_Info	velocity;
		Angle_Info	body_angle;
		Angle_Info	face_angle;

		SServer_Time	last_info_time;

		long		coordinate_accuracy;
		long		velocity_accuracy;

	public:
		Player_Info();
	};

	struct  Body_Info
	{
		View_Width_Info		view_width;
		View_Quality_Info	view_quality;
		Double_Info		stamina;
		Double_Info		effort;
		Double_Info		speed;
		Angle_Info		neck_angle;

		Angle_Info		my_body_angle;
		Region_Info		my_coordinate;
		Region_Info		my_velocity;

		Server_Raw_Body_Info	latest_body;
		SServer_Time		last_info_time;
	};

	struct  Sight_Info
	{
		ref_count_ptr<const Server_Raw_Sight_Info>	latest_sight;
		SServer_Time					last_info_time;

	public:
		Sight_Info();
	};

	struct  Game_State_Info
	{
		bool				game_over_flag;

		SServer_Time			current_time;

		Game_Info			game_info;
		long				play_mode_start_time;

		long				last_judgement_time;
		Server_Raw_Whistle_Info		last_judgement;

		ref_count_ptr<Player_Type_Manager>	player_type;

	public:
		Game_State_Info( const SServer_Param &  param );
		Server_Raw_Whistle_Info		play_mode_start_reason() const;
	};

	struct  Debug_Info
	{
		long				latest_debug_time;
		ref_count_ptr<const Server_Raw_Debug_Info>	latest_debug;

	public:
		Debug_Info();
	};


	struct  Field_Recog_Snapshot
	{
	public:
		const SServer_Param *		sserver_param;

		Ball_Info			ball;
		std::vector<Player_Info>	teammate;
		std::vector<Player_Info>	opponent;

		std::vector<Player_Info>	unknown_teammate;
		std::vector<Player_Info>	unknown_opponent;
		std::vector<Player_Info>	unknown_player;

		Body_Info			body;
		Sight_Info			sight;

		Game_State_Info			game_state;

		int				our_team_goalie_number;
		int				opponent_team_goalie_number;

		double				offence_line;
		double				defence_line;

		Debug_Info			debug;

	public:
		Field_Recog_Snapshot( const SServer_Param *  param );
		Field_Recog_Snapshot( const Field_Recog_Snapshot &  old );

		virtual	~Field_Recog_Snapshot();
	};


public:
		 Field_Recog_Abstract();
	virtual	~Field_Recog_Abstract();

	//
	// protocol between Soccer_Scheduler and Field_Recog
	//
	virtual	void	register_info( const Server_Raw_Info & ,
				       const Time_Stamp & );

	// XXX
	virtual	void	turn_neck_sent( const Angle &  moment ,
					const Time_Stamp &  time_stamp );

	// XXX
	virtual	void	base_command_sent( const Soccer_Command &  command ,
					   const Time_Stamp &  time_stamp );

	// XXX
	virtual	void	update();


	//
	// protocol between User and Field_Recog_Abstract
	//
	virtual	ref_count_ptr<const Field_Recog_Snapshot>  snapshot() const;

	virtual	Soccer_Composite_Command	previous_command() const;
};


#endif	/* FIELD_RECOG_ABSTRACT_H_INCLUDED */
