#ifndef	   FIELD_RECOG_INTERFACE_H_INCLUDED
#define	   FIELD_RECOG_INTERFACE_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	May 21 2000
// Created:		May 21 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  May 21 2000    base version.
//
//

#include  "soccer_object_reference.h"
#include  "player_set.h"

#include  "field_recog_abstract.h"
#include  "sserver_param.h"
#include  "sserver_time.h"
#include  "d2_vector.h"

#include  <string>
#include  <climits>


//
// Field_Recog_Interface
//
class  Field_Recog_Interface
{
protected:
	const Field_Recog_Abstract *	field;
	ref_count_ptr<const Field_Recog_Abstract::Field_Recog_Snapshot>	snap;

	// XXX: don't use this !!
	mutable	bool		have_target_teammate_flag;
	mutable	int		target_teammate;

	// XXX: don't use this !!
	mutable	bool		have_target_point_flag;
	mutable	D2_Vector	target_point;

	// XXX: don't use this !!
	mutable	bool		have_message_flag;
	mutable	std::string	message;

public:
	const Field_Recog_Abstract::Field_Recog_Snapshot &	snapshot()
									const;
public:
	virtual	void	update();

private:
	mutable	ref_count_ptr<Ball_Reference>	ball_reference_cache;
	mutable	std::vector<Player_Reference>	teammate_reference_cache;
	mutable	std::vector<Player_Reference>	opponent_reference_cache;
	mutable	Player_Reference *		self_reference_cache;

	void					make_cache() const;

public:
		 Field_Recog_Interface( const Field_Recog_Abstract *  field );
		 Field_Recog_Interface
		 ( const ref_count_ptr<const Field_Recog_Abstract
					   ::Field_Recog_Snapshot> &  snap );
		 Field_Recog_Interface();
	virtual	~Field_Recog_Interface();

	// XXX: should return ref_count_ptr<Field_Recog_Interface>
	virtual	const Field_Recog_Abstract::Debug_Info	debug() const;

	// XXX: this interface might be changed
	virtual	const SServer_Param &	sserver_param() const;

	virtual	bool			game_over() const;

	virtual	SServer_Time		current_time() const;
	virtual	Play_Mode_Reference	play_mode() const;


	virtual	const Ball_Reference &		ball() const;

	virtual	const Player_Reference &	self() const;
	virtual	const Player_Reference &	teammate( int  number ) const;
	virtual	const Player_Reference &	opponent( int  number ) const;
	virtual	Player_Reference		player( const S_Side &  side ,
							int  number ) const;

	// XXX
	virtual	size_t			n_unknown_teammate() const;
	virtual	Player_Reference	unknown_teammate( int  indx ) const;

	virtual	size_t			n_unknown_opponent() const;
	virtual	Player_Reference	unknown_opponent( int  indx ) const;

	virtual	size_t			n_unknown_player() const;
	virtual	Player_Reference	unknown_player( int  indx ) const;


	virtual	Team_Reference	our_team() const;
	virtual	Team_Reference	opponent_team() const;
	virtual	Team_Reference	team( const S_Side &  side ) const;

	// XXX: temporary interface
	virtual	bool	offside_position( const D2_Vector & ) const;

	// XXX: temporary interface
	virtual	const Player_Type_Manager &	player_type_manager() const;

	virtual	Player_Set	player_set( const Player_Predicate & ) const;

	virtual	Soccer_Composite_Command	previous_command() const;

	virtual	D2_Vector	ball_predict_point( long  t = LONG_MIN ) const;

	virtual	long	strict_ball_lose_step( long  max_step = 10 ,
					       long  acc_level = - 50 ) const;

	// XXX: temporary interface
	virtual	void	ball_access_step( const Player_Set &  players ,
					  long *  self_access_step ,
					  long *  teammate_access_step ,
					  long *  opponent_access_step ,
					  long *  unknown_access_step ,
					  long  max_step = -1 ,
					  long  acc_level = -50 ) const;

	// XXX: temporary interface
	virtual	void	ball_access_step( long *  self_access_step ,
					  long *  teammate_access_step ,
					  long *  opponent_access_step ,
					  long *  unknown_access_step ,
					  long  max_step = -1 ,
					  long  acc_level = -50 ) const;

	// XXX: don't use this !!
	virtual	void		set_target_teammate( int  num ) const;
	// XXX: don't use this !!
	virtual	bool		have_target_teammate() const;
	// XXX: don't use this !!
	virtual	int		get_target_teammate() const;

	// XXX: don't use this !!
	virtual	void		set_target_point( const D2_Vector &  point )
									 const;
	// XXX: don't use this !!
	virtual	bool		have_target_point() const;
	// XXX: don't use this !!
	virtual	D2_Vector	get_target_point() const;

	// XXX: don't use this !!
	virtual	void		set_message( const std::string &  message )
									 const;
	// XXX: don't use this !!
	virtual	bool		have_message() const;
	// XXX: don't use this !!
	virtual	std::string	get_message() const;
};


#endif	/* FIELD_RECOG_INTERFACE_H_INCLUDED */
