#include  "player_set.h"
#include  "field_recog_interface.h"

//
// Player_Predicate_Entity
//
Player_Predicate_Entity::~Player_Predicate_Entity()
{
}

bool   Player_Predicate_Entity::operator () ( const Player_Reference & )
	const
{
	return( false );
}



//
// Player_Predicate
//
Player_Predicate::Player_Predicate
	( const ref_count_ptr<const Player_Predicate_Entity> &  predicate )
	: ent( predicate )
{
}

Player_Predicate::Player_Predicate
	( const Player_Predicate_Entity *  predicate )
	: ent( predicate )
{
}


bool   Player_Predicate::operator () ( const Player_Reference &  pl ) const
{
	if ( ent )
	{
		return( ent -> operator()(pl) );
	}
	else
	{
		return( false );
	}
}


//
// Player_Set
//
bool	Player_Set::Player_Reference_Compare::operator()
		( const Player_Reference &  a ,
		  const Player_Reference &  b ) const
{
	return( &a > &b );
}

Player_Set::Player_Set( const Field_Recog_Interface &  f ,
			const Player_Predicate &  predicate )
	: pl_set()
{
	for ( int  i = 1  ;  i <= MAX_PLAYER  ;  i ++ )
	{
		if ( f.teammate(i).valid() && predicate( f.teammate(i) ) )
		{
			this -> pl_set.insert( f.teammate(i) );
		}

		if ( f.opponent(i).valid() && predicate( f.opponent(i) ) )
		{
			this -> pl_set.insert( f.opponent(i) );
		}
	}

	for( size_t  i = 0  ;  i < f.n_unknown_teammate()  ;  i ++ )
	{
		if ( f.unknown_teammate(i).valid()
		  && predicate( f.unknown_teammate(i) ) )
		{
			this -> pl_set.insert( f.unknown_teammate(i) );
		}
	}

	for( size_t  i = 0  ;  i < f.n_unknown_opponent()  ;  i ++ )
	{
		if ( f.unknown_opponent(i).valid()
		  && predicate( f.unknown_opponent(i) ) )
		{
			this -> pl_set.insert( f.unknown_opponent(i) );
		}
	}

	for( size_t  i = 0  ;  i < f.n_unknown_player()  ;  i ++ )
	{
		if ( f.unknown_player(i).valid()
		  && predicate( f.unknown_player(i) ) )
		{
			this -> pl_set.insert( f.unknown_player(i) );
		}
	}
}

Player_Set::iterator  Player_Set::begin() const
{
	return( this -> pl_set.begin() );
}

Player_Set::iterator  Player_Set::end() const
{
	return( this -> pl_set.end() );
}

size_t  Player_Set::size() const
{
	return( this -> pl_set.size() );
}


//
// concrete Player_Predicate_Entity
//

//
// predicate for combination predicate
//
bool   And_Player_Predicate::operator ()
				 ( const Player_Reference &  player ) const
{
	return( (*p1)( player ) && (*p2)( player ) );
}

bool   Or_Player_Predicate::operator ()
				 ( const Player_Reference &  player ) const
{
	return( (*p1)( player ) || (*p2)( player ) );
}

bool   Not_Player_Predicate::operator ()
				 ( const Player_Reference &  player ) const
{
	return( ! (*p)( player ) );
}


//
// predicate for each player
//
bool   All_Player_Predicate::operator () ( const Player_Reference & ) const
{
	return( true );
}

bool   All_Player_Except_Self_Predicate
		::operator () ( const Player_Reference &  player ) const
{
	return( ! player.self_player() );
}

bool   Teammate_Predicate::operator () ( const Player_Reference &  player )
	const
{
	return( player.side() == S_Side::Our_Side );
}

bool   Teammate_Except_Self_Predicate::operator ()
				 ( const Player_Reference &  player ) const
{
	return( player.teammate() && ! player.self_player() );
}

bool   Opponent_Predicate::operator ()
				 ( const Player_Reference &  player ) const
{
	return( player.opponent() );
}

bool   Unknown_Player_Predicate::operator ()
				 ( const Player_Reference &  player ) const
{
	return( player.unknown() );
}

bool   Opponent_Or_Unknown_Player_Predicate
		::operator () ( const Player_Reference &  player ) const
{
	return( player.opponent() || player.unknown() );
}

bool   Goalie_Predicate::operator () ( const Player_Reference &  player ) const
{
	return( player.goalie() );
}

bool   Field_Player_Predicate
		::operator () ( const Player_Reference &  player ) const
{
	return( player.field_player() );
}

bool   Our_Team_Goalie_Predicate
		::operator () ( const Player_Reference &  player ) const
{
	return( player.teammate() && player.goalie() );
}

bool   Our_Team_Field_Player_Predicate
		::operator () ( const Player_Reference &  player ) const
{
	return( player.teammate() && player.field_player() );
}

bool   Opponent_Team_Goalie_Predicate
		::operator () ( const Player_Reference &  player ) const
{
	return( player.opponent() && player.goalie() );
}

bool   Opponent_Team_Field_Player_Predicate
		::operator () ( const Player_Reference &  player ) const
{
	return( player.opponent() && player.field_player() );
}


bool   Coordinate_Accurate_Player_Predicate::operator ()
				 ( const Player_Reference &  player ) const
{
	return( player.coordinate().accuracy_level() >= accuracy_level );
}

bool   Velocity_Accurate_Player_Predicate::operator ()
				 ( const Player_Reference &  player ) const
{
	return( player.velocity().accuracy_level() >= accuracy_level );
}

bool   Ball_Kickable_Player_Predicate::operator ()
				( const Player_Reference &  player ) const
{
	return( (player.coordinate() - f.ball().coordinate()).r()
		<= player.ball_kickable_distance() );
}

bool   Ball_Controllable_Player_Predicate::operator ()
				( const Player_Reference &  player ) const
{
	return( (player.coordinate() - f.ball().coordinate()).r()
		<= player.ball_controllable_distance() );
}

bool   Point_Close_Player_Predicate::operator()
				( const Player_Reference &  player ) const
{
	return( (player.coordinate() - this -> point).r()
		<= this -> dist );
}

bool   Ball_Close_Player_Predicate::operator()
				( const Player_Reference &  player ) const
{
	return( (player.coordinate() - f.ball().coordinate()).r()
		<= this -> dist );
}

bool   Self_Close_Player_Predicate::operator()
				( const Player_Reference &  player ) const
{
	return( (player.coordinate() - f.self().coordinate()).r()
		<= this -> dist );
}

bool   Offside_Position_Player_Predicate::operator()
				( const Player_Reference &  player ) const
{
	return( player.offside_position() );
}
