#ifndef	   PLAYER_SET_H_INCLUDED
#define	   PLAYER_SET_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Jan 18 2001
// Created:		Jan 18 2001
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Jan 18 2001    base version.
//
//

#include  "soccer_object_reference.h"
#include  "ref_count_ptr.h"
#include  <set>

//-----------------------------------------------------------------------------
// abstract Player_Predicate definition
//-----------------------------------------------------------------------------

// Real Predicate Class
//   Inherit this to create new predicate.
class  Player_Predicate_Entity
{
public:
	virtual	~Player_Predicate_Entity();
	virtual	bool	operator () ( const Player_Reference & ) const;
};

// Wrapper class for Player_Predicate_Entity
class  Player_Predicate
{
private:
	ref_count_ptr<const Player_Predicate_Entity>	ent;

public:
	Player_Predicate
		( const ref_count_ptr<const Player_Predicate_Entity> & );

	Player_Predicate( const Player_Predicate_Entity * );

	/*non-virtual*/	bool	operator () ( const Player_Reference & ) const;
};


//-----------------------------------------------------------------------------
// abstract Player Set definition
//-----------------------------------------------------------------------------
class  Player_Set
{
private:
	class  Player_Reference_Compare
	{
	public:
		bool	operator() ( const Player_Reference & ,
				     const Player_Reference & ) const;
	};

private:
	typedef std::multiset<Player_Reference,
			      Player_Reference_Compare> Set_Type;

	Set_Type	pl_set;


public:
	typedef Set_Type::iterator	iterator;

public:
		Player_Set( const Field_Recog_Interface & ,
			    const Player_Predicate & );

	Player_Set::iterator	begin() const;
	Player_Set::iterator	end() const;

	size_t			size() const;
};


//-----------------------------------------------------------------------------
// concrete Player_Predicate definition
//-----------------------------------------------------------------------------

//
// composite Player_Predicate classes
//
class  And_Player_Predicate : public Player_Predicate_Entity
{
protected:
	const ref_count_ptr<const Player_Predicate_Entity>	p1;
	const ref_count_ptr<const Player_Predicate_Entity>	p2;

public:
		 And_Player_Predicate
		 ( const ref_count_ptr<const Player_Predicate_Entity> &  p1 ,
		   const ref_count_ptr<const Player_Predicate_Entity> &  p2 )
		: p1( p1 ) , p2( p2 ) {}

	virtual	~And_Player_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Or_Player_Predicate : public Player_Predicate_Entity
{
protected:
	const ref_count_ptr<const Player_Predicate_Entity>	p1;
	const ref_count_ptr<const Player_Predicate_Entity>	p2;

public:
		 Or_Player_Predicate
		 ( const ref_count_ptr<const Player_Predicate_Entity> &  p1 ,
		   const ref_count_ptr<const Player_Predicate_Entity> &  p2 )
		: p1( p1 ) , p2( p2 ) {}
	virtual	~Or_Player_Predicate() {}

	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Not_Player_Predicate : public Player_Predicate_Entity
{
protected:
	const ref_count_ptr<const Player_Predicate_Entity>	p;

public:
		 Not_Player_Predicate
		 ( const ref_count_ptr<const Player_Predicate_Entity> &  p )
		 : p( p ) {}
	virtual	~Not_Player_Predicate() {}

	virtual	bool	operator () ( const Player_Reference & ) const;
};


//
// single Player_Predicate classes
//
class  All_Player_Predicate : public Player_Predicate_Entity
{
public:
	virtual	~All_Player_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  All_Player_Except_Self_Predicate : public Player_Predicate_Entity
{
public:
	virtual	~All_Player_Except_Self_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Teammate_Predicate : public Player_Predicate_Entity
{
public:
	virtual	~Teammate_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Teammate_Except_Self_Predicate : public Player_Predicate_Entity
{
public:
	virtual	~Teammate_Except_Self_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Opponent_Predicate : public Player_Predicate_Entity
{
public:
	virtual	~Opponent_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Unknown_Player_Predicate : public Player_Predicate_Entity
{
public:
	virtual	~Unknown_Player_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Opponent_Or_Unknown_Player_Predicate : public Player_Predicate_Entity
{
public:
	virtual	~Opponent_Or_Unknown_Player_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Goalie_Predicate : public Player_Predicate_Entity
{
public:
	virtual	~Goalie_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Field_Player_Predicate : public Player_Predicate_Entity
{
public:
	virtual	~Field_Player_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Our_Team_Goalie_Predicate : public Player_Predicate_Entity
{
public:
	virtual	~Our_Team_Goalie_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Our_Team_Field_Player_Predicate : public Player_Predicate_Entity
{
public:
	virtual	~Our_Team_Field_Player_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Opponent_Team_Goalie_Predicate : public Player_Predicate_Entity
{
public:
	virtual	~Opponent_Team_Goalie_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Opponent_Team_Field_Player_Predicate : public Player_Predicate_Entity
{
public:
	virtual	~Opponent_Team_Field_Player_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Coordinate_Accurate_Player_Predicate : public Player_Predicate_Entity
{
	long	accuracy_level;

public:
		 Coordinate_Accurate_Player_Predicate( long  accuracy_level )
			 : accuracy_level( accuracy_level ) {}
	virtual	~Coordinate_Accurate_Player_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Velocity_Accurate_Player_Predicate : public Player_Predicate_Entity
{
protected:
	long	accuracy_level;

public:
		 Velocity_Accurate_Player_Predicate( long  accuracy_level )
			 : accuracy_level( accuracy_level ) {}
	virtual	~Velocity_Accurate_Player_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Ball_Kickable_Player_Predicate : public Player_Predicate_Entity
{
protected:
	const Field_Recog_Interface &	f;

public:
		 Ball_Kickable_Player_Predicate
					( const Field_Recog_Interface &  f )
			: f( f ) {}
	virtual	~Ball_Kickable_Player_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Point_Close_Player_Predicate : public Player_Predicate_Entity
{
protected:
	const Field_Recog_Interface &	f;
	const D2_Vector			point;
	const double			dist;

public:
		 Point_Close_Player_Predicate
					( const Field_Recog_Interface &  f ,
					  const D2_Vector &  point ,
					  double  dist )
			: f( f ) , point( point ) , dist( dist ) {} 
	virtual	~Point_Close_Player_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Ball_Close_Player_Predicate : public Player_Predicate_Entity
{
protected:
	const Field_Recog_Interface &	f;
	const double			dist;

public:
		 Ball_Close_Player_Predicate
					( const Field_Recog_Interface &  f ,
					  double  dist )
			: f( f ) , dist( dist ) {} 
	virtual	~Ball_Close_Player_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Self_Close_Player_Predicate : public Player_Predicate_Entity
{
protected:
	const Field_Recog_Interface &	f;
	const double			dist;

public:
		 Self_Close_Player_Predicate
					( const Field_Recog_Interface &  f ,
					  double  dist )
			: f( f ) , dist( dist ) {} 
	virtual	~Self_Close_Player_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Ball_Controllable_Player_Predicate : public Player_Predicate_Entity
{
protected:
	const Field_Recog_Interface &	f;

public:
		 Ball_Controllable_Player_Predicate
					( const Field_Recog_Interface &  f )
			: f( f ) {}
	virtual	~Ball_Controllable_Player_Predicate() {}
	virtual	bool	operator () ( const Player_Reference & ) const;
};

class  Offside_Position_Player_Predicate : public Player_Predicate_Entity
{
public:
	virtual	bool	operator () ( const Player_Reference & ) const;
};


#endif	/* PLAYER_SET_H_INCLUDED */
