#include  "player_type_manager.h"

Player_Type_Manager::Player_Type_Manager( const SServer_Param &  param )
	: param( param )
{
	this -> types.push_back( new Server_Raw_Player_Type_Info );
}

Player_Type_Manager::~Player_Type_Manager()
{
}

void	Player_Type_Manager::register_server_param
	    ( const ref_count_ptr<const Server_Raw_Server_Param_Info> &  sp )
{
	// XXX: must update player types
	(void)sp;
}

void   Player_Type_Manager::register_player_param
	    ( const ref_count_ptr<const Server_Raw_Player_Param_Info> &  pp )
{
	if ( this -> types.size()
	     != static_cast<size_t>( pp -> player_types ) )
	{
		this -> types.clear();

		for ( int i = 0  ;  i < (pp -> player_types)  ;  i ++ )
		{
			this -> types.push_back
			  ( ref_count_ptr<Server_Raw_Player_Type_Info>(0) );
		}
	}
	else
	{
		// XXX
	}
}

void   Player_Type_Manager::register_player_type
	    ( const ref_count_ptr<const Server_Raw_Player_Type_Info> &  pt )
{
	if ( 0 <= (pt -> id)
	  && static_cast<size_t>(pt -> id) < this -> types.size() )
	{
		this -> types[(pt -> id)] = pt;
	}
	else
	{
		// XXX
	}
}


int    Player_Type_Manager::n_type() const
{
	return( static_cast<int>(this -> types.size()) );
}

ref_count_ptr<const Server_Raw_Player_Type_Info>
				Player_Type_Manager::get_type( int  id ) const
{
	if ( 0 <= id  &&  static_cast<size_t>(id) < this -> types.size() )
	{
		return( this -> types[id] );
	}
	else
	{
		return( static_cast<Server_Raw_Player_Type_Info *>(0) );
	}
}

bool   Player_Type_Manager::valid() const
{
	for ( size_t  i = 0  ;  i < this -> types.size()  ;  i ++ )
	{
		if ( ! (this -> get_type(i)) )
		{
			return( false );
		}
	}

	return( true );
}
