#ifndef	   SIGHT_INFO_ANALYZER_H_INCLUDED
#define	   SIGHT_INFO_ANALYZER_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	May  5 2000
// Created:		May  5 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  May  5 2000    base version.
//
//

#include  "server_raw_info.h"
#include  "sserver_param.h"
#include  "field_recog_abstract.h"
#include  "ref_count_ptr.h"
#include  "angle.h"
#include  "range.h"
#include  <vector>

class  Sight_Info_Analyzer
{
protected:
	//
	// source
	//
	const ref_count_ptr<const Server_Raw_Sight_Info>	sight;
	const SServer_Param *	param;
	const Angle_Range	neck_angle;

protected:
	//
	// cache
	//

	// view angle
	mutable	bool		view_angle_cached;
	mutable	Angle_Info	view_angle;

	// body angle
	mutable	bool		body_angle_cached;
	mutable	Angle_Info	body_angle;

	// self_coordinate
	mutable	bool		self_coordinate_cached;
	mutable	Region_Info	self_coordinate;

#if 1
	// self_velocity
	mutable	bool		self_velocity_cached;
	mutable	Region_Info	self_velocity;
#endif

	// ball
	mutable	bool				ball_info_cached;
	mutable	bool				ball_info_valid;
	mutable	Field_Recog_Abstract::Ball_Info	ball_info;

	// player
	mutable	bool					player_info_cached;
	mutable	bool					player_info_valid;
	mutable	std::vector<Field_Recog_Abstract::Player_Info>	teammate_info;
	mutable	std::vector<Field_Recog_Abstract::Player_Info>	opponent_info;
	mutable	std::vector<Field_Recog_Abstract::Player_Info>
							unknown_teammate_info;
	mutable	std::vector<Field_Recog_Abstract::Player_Info>
							unknown_opponent_info;
	mutable	std::vector<Field_Recog_Abstract::Player_Info>
							unknown_player_info;

protected:
	//
	// calculation methods
	//
	void	require_relative_field_marker_info() const;

	bool	require_view_angle() const;
	bool	require_body_angle() const;
	bool	require_self_coordinate() const;
#if 1
	bool	require_self_velocity() const;
#endif
	bool	require_ball_info() const;
	bool	require_player_info() const;


	// view angle calculation
	bool	calc_view_angle_from_line( Angle_Info *  result ) const;

	// body angle calculation
	bool	calc_body_angle( Angle_Info *  result ) const;

	// self_coordinate calculation
	bool	calc_self_coordinate_by_composite( Region_Info *  result )
									const;
	bool	calc_self_coordinate_by_sum( D2_Vector *  res_vec )
									const;
	bool	calc_self_coordinate_by_region_cut( D2_Region *  res_reg )
									const;

	// ball info calculation
	bool	calc_ball_info( Field_Recog_Abstract::Ball_Info *  result )
									const;

	// player info calculation
	bool	calc_player_info
	( std::vector<Field_Recog_Abstract::Player_Info> *  teammate ,
	  std::vector<Field_Recog_Abstract::Player_Info> *  opponent ,
	  std::vector<Field_Recog_Abstract::Player_Info> *  unknown_teammate ,
	  std::vector<Field_Recog_Abstract::Player_Info> *  unknown_opponent ,
	  std::vector<Field_Recog_Abstract::Player_Info> *  unknown_player )
									const;

	struct  Relative_Field_Marker_Info
	{
		Raw_Field_Marker_Info	ident;

		D2_Vector		absolute_point;

		Angle_Range		relative_angle_range;
		Double_Range		relative_dist_range;
	};
	mutable	bool	relative_field_marker_info_cached;
	mutable	std::vector<Relative_Field_Marker_Info>
						relative_field_marker_info;
	mutable	std::vector<Relative_Field_Marker_Info>	unknown_marker_info;

protected:
	//
	// internal methods
	//
	static	bool	relative_sight_to_relative_point
			    ( D2_Vector * ,
			      const Raw_SObject_Locational_Info & );

	static	bool	relative_sight_to_relative_velocity
			    ( D2_Vector *  vel ,
			      const Raw_SObject_Locational_Info & );

	static	bool	relative_sight_to_absolute_point_and_velocity
			    ( Region_Info *  coord ,  Region_Info *  vec ,
			      const Raw_SObject_Locational_Info & ,
			      const Region_Info &  self_coord ,
			      const Angle_Info &  view_ang
#if 1
			      ,
			      const Region_Info &  self_vel
#endif
			      );

	static	void	relative_sight_to_player_info
			    ( Region_Info *  coord ,  Region_Info *  vel ,
			      Angle_Info *  body_angle ,
			      Angle_Info *  face_angle ,
			      const Raw_SObject_Locational_Info & ,
			      const Region_Info &  self_coord ,
			      const Angle_Info &  view_ang
#if 1
			      ,
			      const Region_Info &  self_vel
#endif
			    );

	static	D2_Vector	object_coordinate_info_to_self_coordinate
				  ( const Relative_Field_Marker_Info &  info ,
				    const Angle_Info &  view_angle );

	static	void	server_angle_to_angle_range
			    ( Angle_Range *  range ,  const Angle &  angle ,
			      bool  do_normalize = true );

public:
	//
	// external interface
	//
	 Sight_Info_Analyzer(
	     const ref_count_ptr<const Server_Raw_Sight_Info> &  sight ,
	     const SServer_Param *  param ,
	     const Angle_Range &  neck_angle );

	~Sight_Info_Analyzer();

	bool	get_body_angle_range( Angle_Info *  result ) const;

	bool	get_self_coordinate( Region_Info *  result ) const;

#if 1
	bool	get_self_velocity( Region_Info *  result ) const;
#endif

	void	get_ball_info( Field_Recog_Abstract::Ball_Info *  result )
									const;

	bool	get_player_info
	( std::vector<Field_Recog_Abstract::Player_Info> *  teammate ,
	  std::vector<Field_Recog_Abstract::Player_Info> *  opponent ,
	  std::vector<Field_Recog_Abstract::Player_Info> *  unknown_teammate ,
	  std::vector<Field_Recog_Abstract::Player_Info> *  unknown_opponent ,
	  std::vector<Field_Recog_Abstract::Player_Info> *  unknown_player )
									const;

	void	get_goalie_number( int *  our_team ,  int *  opponent_team )
									const;

#if 1
	void	advice_self_velocity( const Region_Info &  v );
#endif
};


#endif	/* SIGHT_INFO_ANALYZER_H_INCLUDED */
