#include  "soccer_composite_command.h"

using namespace std;

Soccer_Composite_Command::Soccer_Composite_Command()
{
	this -> base.no_command();
}

Soccer_Composite_Command::~Soccer_Composite_Command()
{
}

Soccer_Composite_Command::Soccer_Composite_Command( const Soccer_Command &  c )
{
	this -> base.no_command();

	(*this) += c;
}

Soccer_Composite_Command  Soccer_Composite_Command::operator +
				( const Soccer_Composite_Command &  c ) const
{
	Soccer_Composite_Command	ret( *this );

	ret += c;

	return( ret );
}

Soccer_Composite_Command &  Soccer_Composite_Command::operator +=
					( const Soccer_Composite_Command &  c )
{
	if ( c.base_type() == Soccer_Command::Illegal_Command )
	{
		base.illegal();
		return( *this );
	}

	if ( base.type() == Soccer_Command::No_Command_Command )
	{
		base = c.base_command();
	}

	if ( ! turn_neck_command )
	{
		turn_neck_command = c.turn_neck();
	}

	if ( ! change_view_command )
	{
		change_view_command = c.change_view();
	}

	if ( ! sense_body_command )
	{
		sense_body_command = c.sense_body();
	}

	if ( ! say_command )
	{
		say_command = c.say();
	}

	return( *this );
}

Soccer_Composite_Command &  Soccer_Composite_Command::operator +=
					( const Soccer_Command &  c )
{
	switch( c.type() )
	{
	case Soccer_Command::Move_Command:
	case Soccer_Command::Dash_Command:
	case Soccer_Command::Kick_Command:
	case Soccer_Command::Turn_Command:
	case Soccer_Command::Catch_Ball_Command:
	case Soccer_Command::Change_Player_Type_Command:
	case Soccer_Command::Wait_Command:
	case Soccer_Command::Bye_Command:
		if ( base.type() == Soccer_Command::No_Command_Command )
		{
			base = c;
		}
		break;

	case Soccer_Command::No_Command_Command:
		// nothing to do
		break;

	case Soccer_Command::Illegal_Command:
		base.illegal();
		break;

	case Soccer_Command::Turn_Neck_Command:
		if ( ! turn_neck_command )
		{
			turn_neck_command = new Soccer_Command( c );
		}
		break;

	case Soccer_Command::Change_View_Command:
		if ( ! change_view_command )
		{
			change_view_command = new Soccer_Command( c );
		}
		break;

	case Soccer_Command::Sense_Body_Command:
		if ( ! sense_body_command )
		{
			sense_body_command = new Soccer_Command( c );
		}
		break;

	case Soccer_Command::Say_Command:
		if ( ! say_command )
		{
			say_command = new Soccer_Command( c );
		}
		break;
	}

	return( *this );
}


Soccer_Command::Command_Type  Soccer_Composite_Command::base_type() const
{
	return( base.type() );
}

const Soccer_Command &  Soccer_Composite_Command::base_command() const
{
	return( base );
}

Soccer_Command &  Soccer_Composite_Command::base_command()
{
	return( base );
}

const ref_count_ptr<Soccer_Command>  Soccer_Composite_Command::say()
	const
{
	return( say_command );
}

const ref_count_ptr<Soccer_Command>  Soccer_Composite_Command::change_view()
	const
{
	return( change_view_command );
}

const ref_count_ptr<Soccer_Command>  Soccer_Composite_Command::turn_neck()
	const
{
	return( turn_neck_command );
}

const ref_count_ptr<Soccer_Command>  Soccer_Composite_Command::sense_body()
	const
{
	return( sense_body_command );
}



Soccer_Composite_Command &  Soccer_Composite_Command::add_say
						( const string &  message )
{
	if ( ! say_command )
	{
		change_view_command = new Soccer_Command();
		change_view_command -> say( message );
	}

	return( *this );
}

Soccer_Composite_Command &  Soccer_Composite_Command::add_change_view
				( View_Width  width , View_Quality  quality )
{
	if ( ! change_view_command )
	{
		change_view_command = new Soccer_Command();
		change_view_command -> change_view( width , quality );
	}

	return( *this );
}

Soccer_Composite_Command &  Soccer_Composite_Command::add_turn_neck
						( const Angle &  direction )
{
	if ( ! turn_neck_command )
	{
		turn_neck_command = new Soccer_Command();
		turn_neck_command -> turn_neck( direction );
	}

	return( *this );
}

Soccer_Composite_Command &  Soccer_Composite_Command::add_sense_body()
{
	if ( ! sense_body_command )
	{
		sense_body_command = new Soccer_Command();
		sense_body_command -> sense_body();
	}

	return( *this );
}


Soccer_Composite_Command &  Soccer_Composite_Command::overwrite_say
						( const string &  message )
{
	change_view_command = new Soccer_Command();
	change_view_command -> say( message );

	return( *this );
}

Soccer_Composite_Command &  Soccer_Composite_Command::overwrite_change_view
				( View_Width  width , View_Quality  quality )
{
	change_view_command = new Soccer_Command();
	change_view_command -> change_view( width , quality );

	return( *this );
}

Soccer_Composite_Command &  Soccer_Composite_Command::overwrite_turn_neck
						( const Angle &  direction )
{
	turn_neck_command = new Soccer_Command();
	turn_neck_command -> turn_neck( direction );

	return( *this );
}

Soccer_Composite_Command &  Soccer_Composite_Command::overwrite_sense_body()
{
	sense_body_command = new Soccer_Command();
	sense_body_command -> sense_body();

	return( *this );
}
