#ifndef	   SOCCER_COMPOSITE_COMMAND_H_INCLUDED
#define	   SOCCER_COMPOSITE_COMMAND_H_INCLUDED

#include  "soccer_command.h"
#include  "ref_count_ptr.h"
#include  <string>

class  Soccer_Composite_Command
{
protected:
	Soccer_Command			base;

	ref_count_ptr<Soccer_Command>	turn_neck_command;
	ref_count_ptr<Soccer_Command>	change_view_command;
	ref_count_ptr<Soccer_Command>	say_command;
	ref_count_ptr<Soccer_Command>	sense_body_command;

public:
	static	Soccer_Composite_Command	Move( double  x ,  double  y )
		{
			return( Soccer_Command::Move( x , y ) );
		}

	static	Soccer_Composite_Command	Move( const D2_Vector &  p )
		{
			return( Soccer_Command::Move( p ) );
		}

	static	Soccer_Composite_Command	Dash( double  power )
		{
			return( Soccer_Command::Dash( power ) );
		}

	static	Soccer_Composite_Command
			Kick( double  power ,  const Angle &  direction )
		{
			return( Soccer_Command::Kick( power , direction ) );
		}

	static	Soccer_Composite_Command	Turn( const Angle &  moment )
		{
			return( Soccer_Command::Turn( moment ) );
		}

	static	Soccer_Composite_Command
			Catch_Ball( const Angle &  direction )
		{
			return( Soccer_Command::Catch_Ball( direction ) );
		}

	static	Soccer_Composite_Command
			Change_Player_Type( int  number ,  int  type )
		{
			return( Soccer_Command::Change_Player_Type( number ,
								    type ) );
		}

	static	Soccer_Composite_Command
			Turn_Neck( const Angle &  direction )
		{
			return( Soccer_Command::Turn_Neck( direction ) );
		}

	static	Soccer_Composite_Command
			Change_View( View_Width  width ,
				     View_Quality  quality )
		{
			return( Soccer_Command::Change_View( width ,
							     quality ) );
		}

	static	Soccer_Composite_Command	Sense_Body()
		{
			return( Soccer_Command::Sense_Body() );
		}

	static	Soccer_Composite_Command	Say( const std::string &  m )
		{
			return( Soccer_Command::Say( m ) );
		}

	static	Soccer_Composite_Command	Wait()
		{
			return( Soccer_Command::Wait() );
		}

	static	Soccer_Composite_Command	No_Command()
		{
			return( Soccer_Command::No_Command() );
		}

	static	Soccer_Composite_Command	Bye()
		{
			return( Soccer_Command::Bye() );
		}

	static	Soccer_Composite_Command	Illegal()
		{
			return( Soccer_Command::Illegal() );
		}

public:
	 Soccer_Composite_Command();
	 Soccer_Composite_Command( const Soccer_Command & );
	~Soccer_Composite_Command();

	Soccer_Composite_Command	operator +
					( const Soccer_Composite_Command & )
									const;
	Soccer_Composite_Command &	operator +=
					( const Soccer_Composite_Command & );

	Soccer_Composite_Command &	operator +=
					( const Soccer_Command &  c );


	Soccer_Command::Command_Type		base_type() const;

	const Soccer_Command &			base_command() const;
	Soccer_Command &			base_command();

	const ref_count_ptr<Soccer_Command>	say() const;
	const ref_count_ptr<Soccer_Command>	change_view() const;
	const ref_count_ptr<Soccer_Command>	turn_neck() const;
	const ref_count_ptr<Soccer_Command>	sense_body() const;

	Soccer_Composite_Command &	add_say
					( const std::string &  message );

	Soccer_Composite_Command &	add_change_view
					( View_Width  width ,
					  View_Quality  quality );

	Soccer_Composite_Command &	add_turn_neck
					( const Angle &  direction );

	Soccer_Composite_Command &	add_sense_body();

	Soccer_Composite_Command &	overwrite_say
					( const std::string &  message );

	Soccer_Composite_Command &	overwrite_change_view
					( View_Width  width ,
					  View_Quality  quality );

	Soccer_Composite_Command &	overwrite_turn_neck
					( const Angle &  direction );

	Soccer_Composite_Command &	overwrite_sense_body();
};


#endif	/* SOCCER_COMPOSITE_COMMAND_H_INCLUDED */
