#ifndef	   SOCCER_MANAGER_H_INCLUDED
#define	   SOCCER_MANAGER_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Apr 27 2000
// Created:		Apr 27 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Apr 27 2000    base version.
//
//

#include  "sserver_param.h"
#include  "sserver_player_connection.h"
#include  "debug_client_connection.h"
#include  "field_recog_abstract.h"
#include  "field_recog_interface.h"
#include  "soccer_command.h"
#include  "client_debug_view.h"
#include  <string>

class  Soccer_Manager
{
private:
	class	Time_Manager
	{
	protected:
		const bool	true_view;

		bool		have_debug_server;

		View_Width	view_width;
		View_Quality	view_quality;

		long		latest_body_info_time;
		long		latest_sight_info_time;
		long		latest_debug_info_time;
		bool		this_step_sight_info;

		Time_Stamp	latest_body_info_time_stamp;

		long		old_step_count;

	protected:
		bool		internal_step_started() const;
		Time_Stamp	internal_step_start_time_stamp() const;
		long		internal_step_count() const;

	public:
		Time_Manager( bool  true_view );

		void	register_info( const Server_Raw_Info &  info ,
				       const Time_Stamp &  stamp ,
				       bool *  time_manager_only ,
				       Soccer_Command *  adjust_command );

		bool	next_step_ready() const;
		void	start_step_notify();

		void	change_view_notify( View_Width  w ,  View_Quality  q );
	};

private:
	ref_count_ptr<SServer_Param>	param;
	SServer_Player_Connection *	server_connection;

	std::vector< Field_Recog_Abstract * >	field_recog_list;
	Field_Recog_Abstract *			main_field_recog;

	std::vector< Field_Recog_Interface * >	field_recog_interface_list;

	Debug_Client_Connection *		debug_connection;
	ref_count_ptr<Client_Debug_View>	debug_view;


	Time_Manager				time_manager;

	// XXX
	bool		have_target_teammate;
	int		target_teammate;

	// XXX
	bool		have_target_point;
	D2_Vector	target_point;

	// XXX
	bool		have_message;
	std::string	message;

protected:
	void	register_info( const Server_Raw_Info &  info ,
			       const Time_Stamp &  stamp );

	// send debug info to debug monitor
	void	send_debug();

public:
	 Soccer_Manager( const ref_count_ptr<SServer_Param> & ,
			 SServer_Player_Connection * ,
			 bool  true_view );
	~Soccer_Manager();

	//
	// Register Field_Recog
	//
	void	register_field_recog( Field_Recog_Abstract * ,
				      bool  main_field_recog_flag = true );

	//
	// Register Field_Recog_Interface
	//
	void	register_field_recog_interface( Field_Recog_Interface * );


	//
	// Register Debug Connection
	//
	void	register_debug_connection( Debug_Client_Connection * );


	//
	// now, playing game or not.
	//
	bool	game_over() const throw();

	//
	// server responsive or not.
	//
	bool	server_no_response() const throw();

	//
	// go to beginning of next step
	//
	void	next_step();


	//
	// now, ready for forward a step or not
	//
	bool	next_step_ready() const;

	//
	// update
	//
	void	update( bool  block );



	// XXX
	void	set_target_teammate( int  num );
	void	set_target_point( const D2_Vector &  point );
	void	set_message( const std::string &  message );


	//
	// establish connection
	//
	int	init_connection
			( const std::string &  team_name ,
			  bool  goalie = false ,
			  Game_Info *  g_info = static_cast<Game_Info *>(0) ,
			  int  major_version
				  = SServer_Player_Connection
					::SSERVER_DEFAULT_MAJOR_VERSION ,
			  int  minor_version
				  = SServer_Player_Connection
					::SSERVER_DEFAULT_MINOR_VERSION ,
			  int  n_trial = 2 )
			  throw();

	int	reconnect_connection
			( const std::string &  team_name ,
			  int  player_number ,
			  Game_Info *  g_info  = static_cast<Game_Info *>(0) ,
			  int  n_trial = 60 ) throw();

	int	send_bye( long  interval_usec = 0 ) throw();
	int	send_bye( bool  default_wait ) throw();

	int	send_composite_command
			( const Soccer_Composite_Command &  composite_command ,
			  long  interval_usec = 0 ) throw();
	int	send_composite_command
			( const Soccer_Composite_Command &  composite_command ,
			  bool  default_wait ) throw();


	int	send_raw_message( const std::string &  str ,
				  long  interval_usec = 0 ) throw();
	int	send_raw_message( const std::string &  str ,
				  bool  default_wait ) throw();

	int	send_command( const Soccer_Command &  command ,
			      long  interval_usec = 0 )	throw();
	int	send_command( const Soccer_Command &  command ,
			      bool  default_wait ) throw();

};


#endif	/* SOCCER_MANAGER_H_INCLUDED */
