#include  "soccer_option_analyser.h"
#include  "debug_server_connection.h"
#include  <utility>

using namespace std;

void   Soccer_Option_Analyser::usage( std::ostream &  ostr ) const
{
	ostr << "Usage: " << this -> program_name() << " [option ...]" << endl
	     << "Possible options are:" << endl
	     << "      --help" << endl
	     << "  -h, --host, --server-host HOST" << endl
	     << "  -p, --port, --server-port PORT" << endl
	     << "  -H, --debug-host HOST" << endl
	     << "  -P, --debug-port PORT" << endl
	     << "  -d, --with-debug-server" << endl
	     << "      --without-debug-server" << endl
	     << "  -t, --teamname TEAMNAME" << endl
	     << "  -r, --reconnect PLAYER_NUMBER" << endl
	     << "  -g, --goalie" << endl
	     << "  -f, --field-player" << endl
	     << "  -c, --online-coach" << endl
	     << "  -v, --server-version MAJOR[.MINOR]" << endl
	     << "  -R, --role ROLE" << endl
	     << "  -T, --true-view" << endl
	     << "  -D, --debug" << endl;
}


//
// local class for --server-version option
//
class  Soccer_Server_Version_Option_Descripter
	: public Option_Analyser::Option_Descripter
{
private:
	void	print_error( const std::string &  version_string ) const
	{
		cerr << "version number option"
		     << " error [" << version_string << "]" << endl;
	}

protected:
	std::pair<int,int> *	version;

public:
		 Soccer_Server_Version_Option_Descripter
		   ( std::pair<int,int> *  v ) : version(v) {}
	virtual	~Soccer_Server_Version_Option_Descripter() {}

	virtual	int	execute( const std::vector<std::string> &  arg ) const
	{
		if ( arg.size() < 1 )
		{
			return( -1 );
		}

		if ( ! version )
		{
			return( 1 );
		}

		char *	r;
		long	major_num;
		major_num = std::strtol( arg[0].c_str() , &r , 10 );

		if ( major_num == LONG_MIN || major_num == LONG_MAX
		  || major_num < INT_MIN   || major_num > INT_MAX )
		{
			this -> print_error( arg[0] );

			return( -1 );
		}

		if ( *r == '\0' )
		{
			version -> first = static_cast<int>( major_num );
			version -> second = 0;
		}
		else if ( r[0] == '.'  &&  r[1] != '\0' )
		{
			long	minor_num;
			char *	e;
			minor_num = std::strtol( r + 1 , &e , 10 );

			if ( *e != '\0'
			     || minor_num == LONG_MIN || minor_num == LONG_MAX
			     || minor_num < INT_MIN   || minor_num > INT_MAX )
			{
				this -> print_error( arg[0] );

				return( -1 );
			}

			version -> first  = static_cast<int>( major_num );
			version -> second = static_cast<int>( minor_num );
		}
		else
		{
			this -> print_error( arg[0] );

			return( -1 );
		}

		return( 1 );
	}
};



//
// local class for --debug option
//   Warning: this interface will be changed!!
//
class  Soccer_Debug_Option_Descripter
	: public Option_Analyser::Option_Descripter
{
protected:
	Soccer_Option_Analyser::Debug_Option *	debug;

public:
		 Soccer_Debug_Option_Descripter
		   ( Soccer_Option_Analyser::Debug_Option *  d ) : debug(d) {}
	virtual	~Soccer_Debug_Option_Descripter() {}

	virtual	int	execute( const std::vector<std::string> & ) const
	{
		if ( debug )
		{
			// XXX: interface will be changed !!
			debug -> inhibit = ! (debug -> inhibit);
		}

		return( 0 );
	};
};


const ip_port_number_t	Soccer_Option_Analyser::DEBUG_PORT_RELATIVE    = 0;
const std::string	Soccer_Option_Analyser::DEBUG_HOST_SERVER_HOST = "";

Soccer_Option_Analyser::Soccer_Option_Analyser(
				const string &  default_team_name ,
				bool  default_goalie_flag ,
				bool  default_coach_flag ,
				const string &  default_host_name ,
				ip_port_number_t  default_port_number ,
				bool  default_with_debug_server ,
				const string &  default_debug_host_name ,
				ip_port_number_t  default_debug_port_number ,
				int  default_server_major_version ,
				int  default_server_minor_version )
{
	//
	// Initialize
	//
	this -> help_flag = false;

	this -> host        = default_host_name;
	this -> port        = default_port_number;

	this -> debug_host  = default_debug_host_name;
	this -> debug_port  = default_debug_port_number;
	this -> with_debug_server_flag = default_with_debug_server;

	this -> team        = default_team_name;
	this -> goalie_flag = default_goalie_flag;
	this -> coach_flag  = default_coach_flag;

	this -> reconnect_player_num = -1;

	this -> server_version.first  = default_server_major_version;
	this -> server_version.second = default_server_minor_version;

	this -> role_name = "";

	this -> true_view_flag = false;

	this -> debug_option.inhibit = true;


	//
	// Add Options
	//
	this -> add_long_option_flag_on(      "--help"        , &help_flag );
	this -> add_option_string     ( 'h' , "--host"        , &host );
	this -> add_long_option_string(       "--server-host" , &host );
	this -> add_option_integer    ( 'p' , "--port"        , &port );
	this -> add_long_option_integer(      "--server-port" , &port );
	this -> add_option_string     ( 'H' , "--debug-host"  , &debug_host );
	this -> add_option_integer    ( 'P' , "--debug-port"  , &debug_port );
	this -> add_option_flag_on    ( 'd' , "--with-debug-server" ,
					      &with_debug_server_flag );
	this -> add_long_option_flag_off(     "--without-debug-server" ,
					      &with_debug_server_flag );
	this -> add_option_string     ( 't' , "--teamname"    , &team );
	this -> add_option_flag_on    ( 'g' , "--goalie"      , &goalie_flag );
	this -> add_option_flag_off   ( 'f' , "--field-player", &goalie_flag );
	this -> add_option_flag_on    ( 'c' , "--online-coach", &coach_flag );

	this -> add_option_integer    ( 'r' , "--reconnect" ,
					&reconnect_player_num );

	this -> add_option( 'v' , "--server-version" ,
			    new Soccer_Server_Version_Option_Descripter
							( &server_version ) );

	this -> add_option_string( 'R' , "--role" , &role_name );

	this -> add_option_flag_on( 'T' , "--true-view", &true_view_flag );

	this -> add_option
		  ( 'D' , "--debug" ,
		    new Soccer_Debug_Option_Descripter( &debug_option ) );
}

Soccer_Option_Analyser::~Soccer_Option_Analyser()
{
}

bool   Soccer_Option_Analyser::help() const
{
	return( this -> help_flag );
}

string  Soccer_Option_Analyser::hostname() const
{
	return( this -> host );
}

ip_port_number_t  Soccer_Option_Analyser::port_number() const
{
	return( static_cast<ip_port_number_t>( this -> port ) );
}

string  Soccer_Option_Analyser::debug_hostname() const
{
	if ( this -> debug_host == DEBUG_HOST_SERVER_HOST )
	{
		return( this -> hostname() );
	}
	else
	{
		return( this -> debug_host );
	}
}

ip_port_number_t  Soccer_Option_Analyser::debug_port_number() const
{
	if ( this -> debug_port == DEBUG_PORT_RELATIVE )
	{
		return( this -> port_number()
			  + Debug_Server_Connection::DEFAULT_PORT_OFFSET );
	}
	else
	{
		return( static_cast<ip_port_number_t>( this -> debug_port ) );
	}
}

bool   Soccer_Option_Analyser::with_debug_server() const
{
	return( this -> with_debug_server_flag );
}

string  Soccer_Option_Analyser::teamname() const
{
	return( this -> team );
}

bool   Soccer_Option_Analyser::goalie() const
{
	return( this -> goalie_flag );
}

bool   Soccer_Option_Analyser::coach() const
{
	return( this -> coach_flag );
}

bool   Soccer_Option_Analyser::reconnect() const
{
	return( this -> reconnect_player_num != -1 );
}

int    Soccer_Option_Analyser::reconnect_player_number() const
{
	return( this -> reconnect_player_num );
}

int   Soccer_Option_Analyser::server_major_version() const
{
	return( server_version.first );
}

int   Soccer_Option_Analyser::server_minor_version() const
{
	return( server_version.second );
}

string  Soccer_Option_Analyser::role() const
{
	return( this -> role_name );
}

bool  Soccer_Option_Analyser::true_view() const
{
	return( this -> true_view_flag );
}

Soccer_Option_Analyser::Debug_Option  Soccer_Option_Analyser::debug() const
{
	return( debug_option );
}
