#ifndef	   SOCCER_OPTION_ANALYSER_H_INCLUDED
#define	   SOCCER_OPTION_ANALYSER_H_INCLUDED

#include  <string>
#include  <iostream>
#include  <utility>
#include  "option_analyser.h"
#include  "ip_address.h"
#include  "sserver_param.h"

class  Soccer_Option_Analyser : public Option_Analyser
{
public:
	static	const ip_port_number_t	DEBUG_PORT_RELATIVE;
	static	const std::string	DEBUG_HOST_SERVER_HOST;

public:
	struct  Debug_Option
	{
		bool	inhibit;

		Debug_Option() : inhibit( true ) {}
	};

protected:
	bool			help_flag;

	std::string		host;
	int			port;
	std::string		debug_host;
	int			debug_port;
	bool			with_debug_server_flag;
	std::string		team;
	bool			goalie_flag;
	bool			coach_flag;
	int			reconnect_player_num;
	std::pair<int,int>	server_version;
	std::string		role_name;
	bool			true_view_flag;
	Debug_Option		debug_option;

public:
	 Soccer_Option_Analyser( const std::string &  default_team_name ,
				 bool  default_goalie_flag = false ,
				 bool  default_coach_flag = false ,
				 const std::string &  default_host_name
							      = "localhost" ,
				 ip_port_number_t  default_port_number
				     = SServer_Param::DEFAULT_PORT ,
				 bool  default_with_debug_server = false ,
				 const std::string &  default_debug_host_name
				     = DEBUG_HOST_SERVER_HOST ,
				 ip_port_number_t  default_debug_port_number
				     = DEBUG_PORT_RELATIVE ,
				 int  default_server_major_version = 7 ,
				 int  default_server_minor_version = 8 );

	virtual	~Soccer_Option_Analyser();

	virtual	void	usage( std::ostream &  ostr = std::cerr ) const;

	virtual	bool			help() const;

	virtual	std::string		hostname() const;
	virtual	ip_port_number_t	port_number() const;
	virtual	std::string		debug_hostname() const;
	virtual	ip_port_number_t	debug_port_number() const;
	virtual	bool			with_debug_server() const;
	virtual	std::string		teamname() const;
	virtual	bool			goalie() const;
	virtual	bool			coach() const;
	virtual	bool			reconnect() const;
	virtual	int			reconnect_player_number() const;
	virtual	int			server_major_version() const;
	virtual	int			server_minor_version() const;
	virtual	std::string		role() const;
	virtual	bool			true_view() const;
	virtual	Debug_Option		debug() const;
};


#endif	/* SOCCER_OPTION_ANALYSER_H_INCLUDED */
