#ifndef	   COMMUNICATION_CANNEL_H_INCLUDED
#define	   COMMUNICATION_CANNEL_H_INCLUDED

// Author:		H. Shimora
// Created:		Feb  4 2001
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Feb  4 2001    base version.
//
//

#include  "ip_address.h"
#include  "ref_count_ptr.h"
#include  <string>

template<class Connection_t>
class  Communication_Cannel
{
public:
	static	const	long	DEFAULT_MAX_RESPONCE_TIME
						= 5 * 1000 * 1000; // 5 sec.

protected:
	Connection_t	con;

private:
	// Don't allow copy constructor
	 Communication_Cannel( const Communication_Cannel & );
	// Don't allow copy
	 Communication_Cannel &	 operator=( const Communication_Cannel & );

public:
		 Communication_Cannel( const std::string &  host ,
				       ip_port_number_t  port ,
				       bool  debug ,
				       size_t  max_msg_len ,
				       long  max_response );

		 Communication_Cannel( ip_port_number_t  port ,
				       bool  debug ,
				       size_t  max_msg_len ,
				       long  max_response );

	virtual	~Communication_Cannel();

	virtual			operator bool() const;
	virtual	bool		responsive() const;

	virtual	int		send( const std::string &  mes );

	virtual	bool		recv( ref_count_ptr<std::string> *  data ,
				      bool  block = false );
	virtual	bool		recv( ref_count_ptr<std::string> *  data ,
				      long  usec );
	virtual	bool		recv( std::string *  data ,
				      bool  block = false );
	virtual	bool		recv( std::string *  data ,
				      long  usec );
};


template<class Connection_t>
Communication_Cannel<Connection_t>::Communication_Cannel
			   ( const std::string &  host ,
			     ip_port_number_t  port ,
			     bool  debug ,
			     size_t  max_msg_len ,
			     long  max_response = DEFAULT_MAX_RESPONCE_TIME )
	: con( host , port , debug , max_msg_len , max_response )
{
}

template<class Connection_t>
Communication_Cannel<Connection_t>::Communication_Cannel
			   ( ip_port_number_t  port ,
			     bool  debug ,
			     size_t  max_msg_len ,
			     long  max_response = DEFAULT_MAX_RESPONCE_TIME )
	: con( port , debug , max_msg_len , max_response )
{
}

template<class Connection_t>
Communication_Cannel<Connection_t>::~Communication_Cannel()
{
}

template<class Connection_t>
Communication_Cannel<Connection_t>::operator bool() const
{
	return( this -> con.operator bool() );
}

template<class Connection_t>
bool   Communication_Cannel<Connection_t>::responsive() const
{
	return( this -> con.responsive() );
}

template<class Connection_t>
int    Communication_Cannel<Connection_t>::send( const std::string &  mes )
{
	int	n = this -> con.send( mes );

	// XXX
	// compare int and size_t
	//
	if ( static_cast<size_t>(n) == mes.length() )
	{
		return( n );
	}
	else
	{
		return( -1 );
	}
}

template<class Connection_t>
bool   Communication_Cannel<Connection_t>::
				recv( ref_count_ptr<std::string> *  data ,
				      bool  block )
{
	(void)(this -> con.recv( data  , block ));

	return( (*data) -> length() != 0 );
}

template<class Connection_t>
bool   Communication_Cannel<Connection_t>::
				recv( ref_count_ptr<std::string> *  data ,
				      long  usec )
{
	(void)(this -> con.recv( data , usec ));

	return( (*data) -> length() != 0 );
}

template<class Connection_t>
bool   Communication_Cannel<Connection_t>::recv( std::string *  data ,
						 bool  block )
{
	(void)(this -> con.recv( data  , block ));

	return( data -> length() != 0 );
}

template<class Connection_t>
bool   Communication_Cannel<Connection_t>::recv( std::string *  data ,
						 long  usec )
{
	(void)(this -> con.recv( data , usec ));

	return( data -> length() != 0 );
}


#endif	/* COMMUNICATION_CANNEL_H_INCLUDED */
