#ifndef	   SSERVER_MESSAGE_TRANSLATOR_H_INCLUDED
#define	   SSERVER_MESSAGE_TRANSLATOR_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Aug 11 1998
// Version:		0.10

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.10  Aug 11 1998
//
//

#include  "server_raw_info.h"
#include  "game_info.h"
#include  "soccer_command.h"
#include  "angle.h"
#include  "lisp_lex.h"
#include  <string>

class  SServer_Message_Translator
{
public:
	static	const	size_t	SSERVER_MAX_MESSAGE_LENGTH;

	static	Play_Mode	string_to_play_mode(
					    const std::string & mode ,
					    S_Side_LR  our_side );
#if 0
	static	std::string	play_mode_to_string(
					    const std::string &  mode ,
					    S_Side_LR  our_side );
#endif

	static	bool	str_to_real( double *  num ,
				     const std::string &  str );
	static	bool	str_to_int ( int *     num ,
				     const std::string &  str );

	static	bool	str_to_long( long *  num ,
				     const std::string &  str );

protected:
	enum{ MAX_OBJ_IDENT_LEN = 256 };

	static	void	analyze_sight_info( Server_Raw_Info *  info ,
					    Lisp_Lexical_Object &  input ,
					    S_Side_LR  our_side ,
					    const std::string &  team_name );

	static	bool	analyze_sight_info_get_relative(
			    Raw_SObject_Locational_Info *  relative ,
			    const Lisp_Lexical_Object &  obj );

	static	bool	analyze_sight_info_check_format(
					   const Lisp_Lexical_Object &  obj );

	static	void	analyze_body_info ( Server_Raw_Info *  info ,
					    Lisp_Lexical_Object &  input );

	static	void	analyze_error_info( Server_Raw_Info *  info ,
					    Lisp_Lexical_Object &  input );

	static	bool	analyze_debug_info( Server_Raw_Info *  info ,
					    const std::string &  mes ,
					    S_Side_LR  our_side ,
					    int  self_player_number );

	static	bool	analyze_sight_info_brief(
					Server_Raw_Info *  info ,
					const std::string &  mes ,
					S_Side_LR  our_side ,
					const std::string &  team_name );

	static	bool	analyze_sight_info_brief_get_obj_info(
			    const ref_count_ptr<Server_Raw_Sight_Info> &
								  sight_info ,
			    int  obj_ident_size ,
			    char **  obj_ident ,
			    const Raw_SObject_Locational_Info &  relative ,
			    S_Side_LR  our_side ,
			    const std::string &  team_name );

	static	bool	analyze_sight_info_brief_get_relative(
			    Raw_SObject_Locational_Info *  relative ,
			    int  n_data ,  double  data[] );

	static	bool	analyze_sight_info_danger(
					Server_Raw_Info *  info ,
					const std::string &  mes ,
					S_Side_LR  our_side ,
					const std::string &  team_name );

	static	bool	analyze_audio_info_brief(
					    Server_Raw_Info * info ,
					    const std::string &  mes ,
					    S_Side_LR  our_side );

	static	bool	analyze_body_info_brief(
					Server_Raw_Info *  info ,
					const std::string &  mes );

	static	bool	analyze_server_param_info_brief(
					Server_Raw_Info *  info ,
					const std::string &  mes );

	static	bool	analyze_player_param_info_brief(
					Server_Raw_Info *  info ,
					const std::string &  mes );

	static	bool	analyze_player_type_info_brief(
					Server_Raw_Info *  info ,
					const std::string &  mes );

	static	bool	server_str_to_dir( Angle *  dir ,
					   const std::string &  str );

	static	S_Side	lr_to_side( char  l_or_r ,  S_Side_LR  our_side );

	static	S_Side	lr_to_side( const std::string &  l_or_r ,
				    S_Side_LR  our_side );
#if 0
	static	S_Side	lr_to_side( S_Side_LR  l_or_r ,  S_Side_LR our_side );
#endif

	static	int	double_to_nearest_int( double  x );

public:
	//
	// Commands
	//
	static	std::string	command( const Soccer_Command &  command );

	static	std::string	init_command( const std::string &  team_name ,
					      bool  goalie ,
					      int  major_version ,
					      int  minor_version );
	static	std::string	reconnect_command(
					  const std::string &  team_name ,
					  int  player_number );
	static	std::string	bye_command();
	static	std::string	move_command( double  x ,  double  y );
	static	std::string	dash_command( double  power );
	static	std::string	kick_command( double  power ,
					      const Angle &  direction );
	static	std::string	turn_command( const Angle &  moment );

	static	std::string	catch_command( const Angle &  direction );

	static	std::string	change_player_type_command
				    ( int  player_number ,  int  player_type );

	static	std::string	say_command( const std::string &  message );
	static	std::string	change_view_command( View_Width  width ,
						     View_Quality  quality );
	static	std::string	sense_body_command();
	static	std::string	turn_neck_command( const Angle &  direction );



	//
	// Coach Commands
	//
	static	std::string	look_command();
	static	std::string	check_ball_command();
	static	std::string	ear_command( bool  on_off );
#if 0
	static	std::string	change_mode_command( Play_Mode  mode );
#endif

	//
	// Monitor Commands
	//
	static	std::string	dispinit_command( int  version );
	static	std::string	dispstart_command();
	static	std::string	dispdiscard_command( S_Side_LR  side ,
						     int  player_number );
	static	std::string	dispfoul_command( double  x ,
						  double  y ,
						  S_Side_LR  side );

	//
	// Fuss Monitor Commands
	//
	static	std::string	fuss_monitor_init_command();




	//
	// Parse Message
	//
	static	void	parse_init_message
			    ( Game_Info *  g_info ,
			      const ref_count_ptr<const std::string> &  mes );

	static	void	parse_reconnect_message
			    ( Game_Info *  g_info ,
			      const ref_count_ptr<const std::string> &  mes ,
			      int player_number );

	static	void	parse_message
			    ( Server_Raw_Info *  info ,
			      const ref_count_ptr<const std::string> &  mes ,
			      S_Side_LR  our_side ,
			      const std::string &  team_name ,
			      int  self_player_number ,
			      bool  danger_parse = false );

#if 0
	static	void	parse_monitor_message();
#endif
};


#endif	/* SSERVER_MESSAGE_TRANSLATOR_H_INCLUDED */
