#ifdef SSERVER_MONITOR_CONNECTION_TEST
#include  "sserver_monitor_connection.h"
#include  "ref_count_ptr.h"
#include  <string>

using namespace std;

int    main( void )
{
	SServer_Monitor_Connection	connection;

	connection.send_dispinit();
	connection.send_dispstart();

	for(;;)
	{
		ref_count_ptr<string>	data;
		connection.recv( &data );
	}

	return( 0 );
}
#endif


#include  "sserver_monitor_connection.h"
#include  "sserver_message_translator.h"

using namespace std;

SServer_Monitor_Connection::SServer_Monitor_Connection(
					       const std::string &  host ,
					       ip_port_number_t  port ,
					       long  max_response )
	: Communication_Cannel<UDP_Connection>
			  ( host , port ,
			    false , // without debug output
			    SServer_Param::SSERVER_MAX_MESSAGE_LENGTH ,
			    max_response )
{
}

SServer_Monitor_Connection::~SServer_Monitor_Connection()
{
}

int    SServer_Monitor_Connection::fd() const
{
	return( this -> con.fd() );
}

int    SServer_Monitor_Connection::send_dispinit( int  version )
{
	return( this -> send
		( SServer_Message_Translator::dispinit_command( version ) ) );
}

int    SServer_Monitor_Connection::send_dispstart()
{
	return( this -> send
		( SServer_Message_Translator::dispstart_command() ) );
}

int    SServer_Monitor_Connection::send_dispdiscard( S_Side_LR  side ,
						    int  player_number )
{
	return( this -> send
		( SServer_Message_Translator::dispdiscard_command
		  ( side , player_number ) ) );
}

int    SServer_Monitor_Connection::send_dispfoul( double  x ,
						  double  y ,
						  S_Side_LR  side )
{
	return( this -> send
		( SServer_Message_Translator::dispfoul_command( x , y ,
								side ) ) );
}

int   SServer_Monitor_Connection::send_fuss_init()
{
	return( this -> send
		( SServer_Message_Translator::fuss_monitor_init_command() ) );
}
