#ifndef	   SSERVER_MONITOR_CONNECTION_H_INCLUDED
#define	   SSERVER_MONITOR_CONNECTION_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	Feb  5 2001
// Created:		Apr  7 2000
// Version:		0.20

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.10  Apr  7 2000	base version.
//
// version 0.20  Feb  5 2001	changed to Communication_Cannel base.
//
//

#include  "communication_cannel.h"
#include  "udp_connection.h"
#include  "ip_address.h"
#include  "sserver_param.h"
#include  "s_basic.h"
#include  <string>

class  SServer_Monitor_Connection
	: public Communication_Cannel<UDP_Connection>
{
public:
		 SServer_Monitor_Connection
			( const std::string &  host = "localhost" ,
			  ip_port_number_t  port
					      = SServer_Param::DEFAULT_PORT ,
			  long  max_response
				  = Communication_Cannel<UDP_Connection>::
						  DEFAULT_MAX_RESPONCE_TIME );

	virtual	~SServer_Monitor_Connection();

	virtual	int	fd() const;

	virtual	int	send_dispinit( int  version );
	virtual	int	send_dispstart();
	virtual	int	send_dispdiscard( S_Side_LR  side ,
					  int  player_number );

	virtual	int	send_dispfoul( double  x ,  double  y ,
				       S_Side_LR  side );

	// Fuss
	virtual	int	send_fuss_init();
};


#endif	/* SSERVER_MONITOR_CONNECTION_H_INCLUDED */
