#ifdef SSERVER_PLAYER_CONNECTION_TEST
#include  "sserver_player_connection.h"

int    main( void )
{
	SServer_Player_Connection  server;

	server.send_init( "test" );

	server.send_move( -3.0 , 0.12345678 );

	for(;;)
	{
		Information_from_Server	info;

		server.recv_info( &info );
	}

	return( 0 );
}
#endif




#include  "sserver_player_connection.h"
#include  "sserver_message_translator.h"
#include  "adjust_sleep.h"
#include  <iostream>

using namespace std;

const	double  SServer_Player_Connection::DEFAULT_WAIT_TIME_STEP = 1.1;

SServer_Player_Connection::SServer_Player_Connection(
					const SServer_Param &  param ,
					const string &  host ,
					ip_port_number_t  port ,
					long  max_response ,
					long  default_wait_time ,
					Parse_Policy  p_policy )
	: Communication_Cannel<UDP_Connection>
		( host ,
		  port ,
		  true , // with debug output
		  SServer_Param::SSERVER_MAX_MESSAGE_LENGTH ,
		  max_response ) ,
	  param( param )
{
	this -> team_name          = "";
	this -> our_side           =  S_Side_LR::Unknown;
	this -> self_player_number = -1;
	this -> default_wait_time  = default_wait_time;
	this -> parse_policy       = p_policy;
	this -> send_time.set_current_time();
}


SServer_Player_Connection::~SServer_Player_Connection()
{
}

int    SServer_Player_Connection::fd() const
{
	return( con.fd() );
}

long   SServer_Player_Connection::wait_time() const
{
	if ( this -> default_wait_time == -1 )
	{
		return( static_cast<long>( param.SIMULATOR_STEP() * 1000
					   * DEFAULT_WAIT_TIME_STEP ) );
	}
	else
	{
		return( this -> default_wait_time );
	}
}

long   SServer_Player_Connection::default_wait() const
{
	return( this -> wait_time() );
}


int    SServer_Player_Connection::send_with_interval( const string &  str ,
						      long  interval_usec )
{
	if ( interval_usec != 0 )
	{
		Time_Stamp	current_time;
		current_time.set_current_time();

		long	diff = (current_time - send_time).usec();

		if ( diff  <  interval_usec )
		{
			Adjust_Sleep::usleep( interval_usec - diff );
		}
	}

	int	n = this -> send( str );

	this -> send_time.set_current_time();

	// XXX
	// compare int and size_t
	//
	if ( static_cast<size_t>(n) == str.length() )
	{
		return( n );
	}
	else
	{
		return( -1 );
	}
}


int    SServer_Player_Connection::send_init( const string &  team_name ,
					     bool  goalie ,
					     Game_Info *  g_info ,
					     int  major_version ,
					     int  minor_version )
{
	string	send_string = SServer_Message_Translator::init_command(
							      team_name ,
							      goalie ,
							      major_version ,
							      minor_version );


	int	ret = this -> send( send_string );

	ref_count_ptr<string>	buf;
	for(;;)
	{
		(void)(this -> con.recv( &buf ,
					 /* block */ true ,
					 /* reply */ true ));

		if ( buf -> length() != 0 )
		{
			break;
		}

		if ( ! (this -> responsive()) )
		{
			return( -1 );
		}
	}

#if 0
	cout << "init_string = [" << *buf << "]" << endl;
#endif

	Game_Info	g;
	SServer_Message_Translator::parse_init_message( &g , buf );

	this ->  team_name          = team_name;
	this ->  our_side           = g.our_side;
	this ->  self_player_number = g.self_player_number;

	if ( g_info != static_cast<Game_Info *>(0) )
	{
		*g_info = g;
	}

	return( ret );
}

int    SServer_Player_Connection::send_init( const string &  team_name ,
					     bool  goalie ,
					     Game_Info *  g_info )
{
	return( this -> send_init( team_name ,
				   goalie ,
				   g_info ,
				   SSERVER_DEFAULT_MAJOR_VERSION ,
				   SSERVER_DEFAULT_MINOR_VERSION ) );
}



int    SServer_Player_Connection::send_reconnect( const string &  team_name ,
						  int  player_number ,
						  Game_Info *  g_info ,
						  long  interval_usec )
{
	string	send_string;
	send_string = SServer_Message_Translator::reconnect_command(
							    team_name ,
							    player_number );

	int	ret = this -> send_with_interval( send_string ,
						  interval_usec );

	ref_count_ptr<string>	buf;
	for(;;)
	{
		(void)(this -> con.recv( &buf , true , true ));

		if ( buf -> length() != 0 )
		{
			break;
		}

		if ( ! (this -> responsive()) )
		{
			return( -1 );
		}
	}

#if 0
	cout << "recconect_string = [" << buf << "]" << endl;
#endif

	Game_Info	g;
	SServer_Message_Translator::
		parse_reconnect_message( &g , buf , player_number );

	this ->  team_name          = team_name;
	this ->  our_side           = g.our_side;
	this ->  self_player_number = g.self_player_number;

	// XXX
	if ( g_info != static_cast<Game_Info *>(0) )
	{
		*g_info = g;
	}

	return( ret );
}


int    SServer_Player_Connection::send_bye( long  interval_usec )
{
	string	send_string;
	send_string = SServer_Message_Translator::bye_command();

	return( this -> send_with_interval( send_string , interval_usec ) );
}


int    SServer_Player_Connection::send_move( double  x ,  double  y ,
					     long  interval_usec )
{
	string	send_string;
	send_string = SServer_Message_Translator::move_command( x , y );

	return( this -> send_with_interval( send_string , interval_usec ) );
}


int    SServer_Player_Connection::send_dash( double  power ,
					     long  interval_usec )
{
	string	send_string;
	send_string = SServer_Message_Translator::dash_command( power );

	return( this -> send_with_interval( send_string , interval_usec ) );
}


int    SServer_Player_Connection::send_kick( double  power ,
					     const Angle &  direction ,
					     long  interval_usec )
{
	string	send_string;
	send_string = SServer_Message_Translator::kick_command(
			power ,
			direction.normalize() );

	return( this -> send_with_interval( send_string , interval_usec ) );
}


int    SServer_Player_Connection::send_turn( const Angle &  moment ,
					     long  interval_usec )
{
	string	send_string;
	send_string = SServer_Message_Translator::turn_command( moment );

	return( this -> send_with_interval( send_string , interval_usec ) );
}


int    SServer_Player_Connection::send_catch( const Angle &  direction ,
					      long  interval_usec )
{
	string	send_string;
	send_string
	  = SServer_Message_Translator::catch_command( direction.normalize() );

	return( this -> send_with_interval( send_string , interval_usec ) );
}


int    SServer_Player_Connection::send_change_player_type
					( int  player_number ,
					  int  player_type ,
					  long  interval_usec )
{
	string	send_string;
	send_string = SServer_Message_Translator::change_player_type_command
			( player_number , player_type );

	return( this -> send_with_interval( send_string , interval_usec ) );
}


int    SServer_Player_Connection::send_say( const string &  message ,
					    long  interval_usec )
{
	string	send_string;
	send_string = SServer_Message_Translator::say_command( message );

	return( this -> send_with_interval( send_string , interval_usec ) );
}


int    SServer_Player_Connection::send_change_view( View_Width  width ,
						    View_Quality  quality ,
						    long  interval_usec )
{
	string	send_string;
	send_string = SServer_Message_Translator::change_view_command(
								width ,
								quality );

	return( this -> send_with_interval( send_string , interval_usec ) );
}


int    SServer_Player_Connection::send_sense_body( long  interval_usec )
{
	string	send_string;
	send_string = SServer_Message_Translator::sense_body_command();

	return( this -> send_with_interval( send_string , interval_usec ) );
}


int    SServer_Player_Connection::send_turn_neck( const Angle &  direction ,
						  long  interval_usec )
{
	string	send_string;
	send_string = SServer_Message_Translator::turn_neck_command(
						    direction.normalize() );

	return( this -> send_with_interval( send_string , interval_usec ) );
}


int    SServer_Player_Connection::send_command( const Soccer_Command &  com ,
						long  interval_usec )
{
	int	ret = -1;

	switch( com.type() )
	{
	case Soccer_Command::Move_Command:
		ret = send_move( com.move_x() , com.move_y() , interval_usec );
		break;
	case Soccer_Command::Dash_Command:
		ret = send_dash( com.dash_power() , interval_usec );
		break;
	case Soccer_Command::Kick_Command:
		ret = send_kick( com.kick_power() , com.kick_direction() ,
				 interval_usec );
		break;
	case Soccer_Command::Turn_Command:
		ret = send_turn( com.turn_moment() , interval_usec );
		break;
	case Soccer_Command::Catch_Ball_Command:
		ret = send_catch( com.catch_direction() , interval_usec );
		break;
	case Soccer_Command::Change_Player_Type_Command:
		ret = send_change_player_type
			( com.change_player_type_player_number() ,
			  com.change_player_type_player_type() );
		break;
	case Soccer_Command::Turn_Neck_Command:
		ret = send_turn_neck( com.turn_neck_direction() ,
				      interval_usec );
		break;
	case Soccer_Command::Change_View_Command:
		ret = send_change_view( com.change_view_view_width() ,
					com.change_view_view_quality() ,
					interval_usec );
		break;
	case Soccer_Command::Sense_Body_Command:
		ret = send_sense_body( interval_usec );
		break;
	case Soccer_Command::Say_Command:
		ret = send_say( com.say_message() , interval_usec );
		break;
	case Soccer_Command::Bye_Command:
		ret = send_bye( interval_usec );
		break;
	case Soccer_Command::Wait_Command:
	case Soccer_Command::No_Command_Command:
	case Soccer_Command::Illegal_Command:
		break;
	}

	return( ret );
}


#if 0
//
// coach commands
//
int    SServer_Player_Connection::send_look( long  interval_usec = 0 )
{
	string	send_string;
	send_string = SServer_Message_Translator::look_command();

	return( this -> send_with_interval( send_string , interval_usec ) );
}

int    SServer_Player_Connection::send_check_ball( long  interval_usec = 0 )
{
	string	send_string;
	send_string = SServer_Message_Translator::check_ball_command();

	return( this -> send_with_interval( send_string , interval_usec ) );
}

int    SServer_Player_Connection::send_ear( bool  on_off ,
					    long  interval_usec = 0 )
{
	string	send_string;
	send_string = SServer_Message_Translator::err_command( on_off );

	return( this -> send_with_interval( send_string , interval_usec ) );
}

int    SServer_Player_Connection::send_change_mode( Play_Mode  mode ,
					     long  interval_usec = 0 )
{
	string	send_string;
	send_string = SServer_Message_Translator::change_mode_command( mode );

	return( this -> send_with_interval( send_string , interval_usec ) );
}
#endif




int    SServer_Player_Connection::send_reconnect( const string &  team_name ,
						  int  player_number ,
						  Game_Info *  g_info ,
						  bool  default_wait )
{
	return( send_reconnect( team_name , player_number , g_info ,
				(default_wait ? (this -> wait_time()) : 0) ) );
}

int    SServer_Player_Connection::send_bye( bool  default_wait )
{
	return( send_bye( (default_wait ? (this -> wait_time()) : 0) ) );
}

int    SServer_Player_Connection::send_move( double  x ,  double  y ,
					     bool  default_wait )
{
	return( send_move( x , y ,
			   (default_wait ? (this -> wait_time()) : 0) ) );
}

int    SServer_Player_Connection::send_dash( double  power ,
					     bool  default_wait )
{
	return( send_dash( power ,
			   (default_wait ? (this -> wait_time()) : 0) ) );
}

int    SServer_Player_Connection::send_kick( double  power ,
					     const Angle &  direction ,
					     bool  default_wait )
{
	return( send_kick( power , direction ,
			   (default_wait ? (this -> wait_time()) : 0) ) );
}

int    SServer_Player_Connection::send_turn( const Angle &  moment ,
					     bool  default_wait )
{
	return( send_turn( moment ,
			   (default_wait ? (this -> wait_time()) : 0) ) );
}

int    SServer_Player_Connection::send_catch( const Angle &  direction ,
					      bool  default_wait )
{
	return( send_catch( direction ,
			    (default_wait ? (this -> wait_time()) : 0) ) );
}

int    SServer_Player_Connection::send_change_player_type
					( int  player_number ,
					  int  player_type ,
					  bool  default_wait )
{
	return( this -> send_change_player_type
			( player_number , player_type ,
			  (default_wait ?
			   (this -> wait_time()) : 0) ) );
}

int    SServer_Player_Connection::send_say( const string &  message ,
					    bool  default_wait )
{
	return( send_say( message ,
			  (default_wait ? (this -> wait_time()) : 0) ) );
}

int    SServer_Player_Connection::send_change_view( View_Width  width ,
						    View_Quality  quality ,
						    bool  default_wait )
{
	return( send_change_view( width , quality ,
				  (default_wait ?
				   (this -> wait_time()) : 0) ) );
}

int    SServer_Player_Connection::send_sense_body( bool  default_wait )
{
	return( send_sense_body( (default_wait ?
				  (this -> wait_time()) : 0) ) );
}

int    SServer_Player_Connection::send_turn_neck( const Angle &  direction ,
						  bool  default_wait )
{
	return( send_turn_neck( direction ,
				(default_wait ? (this -> wait_time()) : 0) ) );
}

int    SServer_Player_Connection::send_command(
					 const Soccer_Command &  command ,
					 bool  default_wait )
{
	return( send_command( command ,
			      (default_wait ? (this -> wait_time()) : 0) ) );
}




bool   SServer_Player_Connection::recv_info( Server_Raw_Info *  info ,
					     bool  block )
{
	ref_count_ptr<string>	data;
	this -> recv( &data , block );

	SServer_Message_Translator::parse_message( info ,
						   data ,
						   our_side ,
						   team_name ,
						   self_player_number ,
						   (parse_policy
						    == Fast_Parse) );

	if ( info -> type() == Server_Raw_Info::Type_Unknown )
	{
		cerr << "Unknown format: [" << (info -> raw_message()) << "]"
		     << endl;
	}

	return( ! (info -> no_info()) );
}


bool   SServer_Player_Connection::recv_info( Server_Raw_Info *  info ,
					     long  usec )
{
	ref_count_ptr<string>	data;
	this -> recv( &data , usec );

	SServer_Message_Translator::parse_message( info ,
						   data ,
						   our_side ,
						   team_name ,
						   self_player_number ,
						   (parse_policy
						    == Fast_Parse) );

	if ( info -> type() == Server_Raw_Info::Type_Unknown )
	{
		cerr << "Unknown format: [" << (info -> raw_message()) << "]"
		     << endl;
	}

	return( ! (info -> no_info()) );
}
