#ifndef	   SSERVER_PLAYER_CONNECTION_H_INCLUDED
#define	   SSERVER_PLAYER_CONNECTION_H_INCLUDED

// Author:		H. Shimora
// Created:		Aug 11 1998
// Last-Modified:	Feb  5 2001
// Version:		0.20
//

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.10  Aug 11 1998	base version.
//
// version 0.20  Feb  5 2001	changed to Communication_Cannel base.
//
//

#include  "communication_cannel.h"
#include  "udp_connection.h"
#include  "ip_address.h"
#include  "s_basic.h"
#include  "server_raw_info.h"
#include  "game_info.h"
#include  "sserver_param.h"
#include  "time_stamp.h"
#include  "soccer_command.h"
#include  "angle.h"
#include  <string>

class  SServer_Player_Connection : public Communication_Cannel<UDP_Connection>
{
public:
	enum  Parse_Policy { Strict_Parse , Fast_Parse };

public:
	static	const	int	SSERVER_DEFAULT_MAJOR_VERSION = 7;
	static	const	int	SSERVER_DEFAULT_MINOR_VERSION = 0;

	static	const	double	DEFAULT_WAIT_TIME_STEP;

protected:
	const	SServer_Param &	param;

	std::string		team_name;
	S_Side_LR		our_side;
	int			self_player_number;

	long			default_wait_time;

	Parse_Policy		parse_policy;

	Time_Stamp		send_time;

private:
	long			wait_time() const;

public:
		 SServer_Player_Connection
		  ( const SServer_Param &  param ,
		    const std::string &  host = "localhost" ,
		    ip_port_number_t  port = SServer_Param::DEFAULT_PORT ,
		    long  max_response
			   = Communication_Cannel<UDP_Connection>::
				DEFAULT_MAX_RESPONCE_TIME ,
		    long  default_wait_time = -1 ,
		    Parse_Policy  p_policy = Fast_Parse );

	virtual	~SServer_Player_Connection();

	virtual	int	fd() const;

	virtual	long	default_wait() const;

	virtual	int	send_with_interval( const std::string &  str ,
					    long  interval_usec );

	virtual	int	send_init(
			 const std::string &  team_name ,
			 bool  goalie = false ,
			 Game_Info *  g_info = static_cast<Game_Info *>(0) ,
			 int  major_version = SSERVER_DEFAULT_MAJOR_VERSION ,
			 int  minor_version = SSERVER_DEFAULT_MINOR_VERSION );

	virtual	int	send_init( const std::string &  team_name ,
				   bool  goalie ,
				   Game_Info *  g_info );

	virtual	int	send_reconnect( const std::string &  team_name ,
					int  player_number ,
					Game_Info *  g_info
					  = static_cast<Game_Info *>(0) ,
					long  interval_usec = 0 );

	virtual	int	send_bye( long  interval_usec = 0 );

	virtual	int	send_move( double  x ,  double  y ,
				   long  interval_usec = 0 );
	virtual	int	send_dash( double  power ,  long  interval_usec = 0 );

	virtual	int	send_kick( double  power ,  const Angle &  direction ,
				   long  interval_usec = 0 );
	virtual	int	send_turn( const Angle &  moment ,
				   long  interval_usec = 0 );
	virtual	int	send_catch( const Angle &  direction ,
				    long  interval_usec = 0 );
	virtual	int	send_change_player_type( int  player_number ,
						 int  player_type ,
						 long  interval_usec = 0 );
	virtual	int	send_say( const std::string &  message ,
				  long  interval_usec = 0 );
	virtual	int	send_change_view( View_Width  width ,
					  View_Quality  quality ,
					  long  interval_usec = 0 );
	virtual	int	send_sense_body( long  interval_usec = 0 );
	virtual	int	send_turn_neck( const Angle &  direction ,
					long  interval_usec = 0 );

	virtual	int	send_command( const Soccer_Command &  command ,
				      long  interval_usec = 0 );

	//
	// coach commands
	//
#if 0
	virtual	int	send_look( long  interval_usec = 0 );
	virtual	int	send_check_ball( long  interval_usec = 0 );
	virtual	int	send_ear( bool  on_off , long  interval_usec = 0 );
	virtual	int	send_change_mode( Play_Mode  mode ,
					  long  interval_usec = 0 );
#endif

	virtual	int	send_reconnect( const std::string &  team_name ,
					int  player_number ,
					Game_Info *  g_info ,
					bool  default_wait );

	virtual	int	send_bye( bool  default_wait );

	virtual	int	send_move( double  x ,  double  y ,
				   bool  default_wait );
	virtual	int	send_dash( double  power ,  bool  default_wait );
	virtual	int	send_kick( double  power ,  const Angle &  direction ,
				   bool  default_wait );
	virtual	int	send_turn( const Angle &  moment ,
				   bool  default_wait );
	virtual	int	send_catch( const Angle &  direction ,
				    bool  default_wait );
	virtual	int	send_change_player_type( int  player_number ,
						 int  player_type ,
						 bool  default_wait );
	virtual	int	send_say( const std::string &  message ,
				  bool  default_wait );
	virtual	int	send_change_view( View_Width  width ,
					  View_Quality  quality ,
					  bool  default_wait );
	virtual	int	send_sense_body( bool  default_wait );
	virtual	int	send_turn_neck( const Angle &  direction ,
					bool  default_wait );

	virtual	int	send_command( const Soccer_Command &  command ,
				      bool  default_wait );

	virtual	bool	recv_info( Server_Raw_Info *  info ,
				   bool  block = false );

	virtual	bool	recv_info( Server_Raw_Info *  info ,
				   long  usec );
};


#endif	/* SSERVER_PLAYER_CONNECTION_H_INCLUDED */
