#ifndef	   ACTIVE_REPOSITORY_H_INCLUDED
#define	   ACTIVE_REPOSITORY_H_INCLUDED

// Author:		H. Shimora
// Created:		May 21 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  May 21 2000    base version.
//
//

#include  "sserver_param.h"
#include  "monitor_view_supplyer.h"
#include  "debug_server_connection.h"
#include  "abstruct_updator.h"
#include  "view_snapshot.h"
#include  "ref_count_ptr.h"
#include  "d2_vector.h"
#include  <sys/types.h>
#include  <vector>
#include  <map>
#include  <list>
#include  <utility>

class  Active_Repository
{
public:
	static	const double	PENALTY_AREA_LENGTH;
	static	const double	PENALTY_AREA_HALF_WIDTH;
	static	const double	FIELD_HALF_LENGTH;

public:
	static	const int	SIMULATOR_STEP_MSEC;
	static	const long	AUTO_DROP_WAIT_STEP;
	static	const double	AUTO_DROP_CIRCLE_R;
	static	const int	AUTO_DROP_COUNT;
	static	const long	AUTO_KICK_OFF_WAIT_STEP;
	static	const long	AUTO_QUIT_WAIT_STEP;

public:
	class  Changed_Event_Receiver
	{
	public:
		virtual	~Changed_Event_Receiver() {}
		virtual	void	notify() = 0;
	};


protected:
	class  Callback : public Abstruct_Updator::Callback
	{
	protected:
		Active_Repository &  rep;

	public:
			 Callback( Active_Repository &  rep ) : rep( rep ) {}
		virtual	~Callback(){}

		virtual	int	operator() ()
		{
			rep.update();

			return( true );
		}
	};

	ref_count_ptr<Abstruct_Updator>		updator;
	ref_count_ptr<Callback>			callback;

protected:

	SServer_Param				param;

	std::vector< ref_count_ptr<Changed_Event_Receiver> >
						changed_receiver;

	ref_count_ptr<Monitor_View_Supplyer>	view_supplyer;
	ref_count_ptr<Interactive_Monitor_View_Supplyer>
					      server_controll_message_handler;

	Debug_Server_Connection			debug_connection;
	bool					receive_debug_flag;

	bool					game_over_flag;
	bool					monitor_responsive;

	long					server_time;

	std::map< long , ref_count_ptr<View_Snapshot> >	game_log;

	Monitor_View_Data::Monitor_Play_Mode	old_play_mode;
	std::list<D2_Vector>			ball_track;

	bool					auto_drop_flag;
	long					auto_drop_count;

	bool					auto_kick_off_flag;
	long					auto_kick_off_count;

	bool					auto_quit_flag;
	long					auto_quit_count;

	pid_t					server_process_id;

	std::vector< std::pair<long,S_Side_LR> >	goal_time;

protected:
	int	auto_drop_ball( const D2_Vector & ,
				const Monitor_View_Data::Monitor_Play_Mode & );

protected:
	void	changed_notify() const;

public:
	 Active_Repository
	     ( const ref_count_ptr<Abstruct_Updator> &  updator ,
	       const std::string &  host_name ,
	       ip_port_number_t  server_port_number ,
	       ip_port_number_t  debug_port_number ,
	       int  server_protocol_version ,
	       bool  log_file_source ,
	       const std::string &  log_file_name ,
	       bool  receive_debug ,
	       bool  auto_drop_flag ,
	       bool  auto_kick_off_flag ,
	       bool  auto_quit_flag ,
	       pid_t  server_process_id );

	~Active_Repository();

	void	update();

	void	add_changed_event_receiver
		( const ref_count_ptr<Changed_Event_Receiver> &  receiver );

	const std::map< long , ref_count_ptr<View_Snapshot> > &
							get_game_log() const;


	long	get_server_time() const;

	const std::vector< std::pair<long,S_Side_LR> > &	get_goal_time()
									const;

	bool	game_over() const;
	bool	monitor_connection_responsive() const;

	bool	have_server_process_id() const;
	void	kill_server() const;


	// XXX: these methods should be moved ?
	const SServer_Param &	sserver_param() const;

	int	send_start();
	int	send_foul( double  x ,  double  y ,  S_Side_LR  side );

	void	set_auto_drop( bool  f );
	bool	auto_drop_mode() const;
	long	auto_drop_rest_step() const;
	long	auto_drop_rest_second() const;

	void	set_auto_kick_off( bool  f );
	bool	auto_kick_off_mode() const;
	long	auto_kick_off_rest_step() const;
	long	auto_kick_off_rest_second() const;

	void	set_auto_quit( bool  f );
	bool	auto_quit_mode() const;
	long	auto_quit_rest_step() const;
	long	auto_quit_rest_second() const;
};


#endif	/* ACTIVE_REPOSITORY_H_INCLUDED */
