#include  "debug_client_field_recog.h"
#include  <climits>
#include  <cstring>
#include  <cassert>

using namespace std;

SServer_Param	Debug_Client_Field_Recog::dummy_param;


bool   Debug_Client_Field_Recog::teammate_coordinate_valid( int  indx ) const
{
	return( (this -> player_coordinate_valid) & (1 << indx) );
}

bool   Debug_Client_Field_Recog::opponent_coordinate_valid( int  indx ) const
{
	return( (this -> player_coordinate_valid)
		& (1 << (MAX_PLAYER + indx)) );
}

bool   Debug_Client_Field_Recog::teammate_body_angle_valid( int  indx ) const
{
	return( (this -> player_body_angle_valid) & (1 << indx) );
}

bool   Debug_Client_Field_Recog::opponent_body_angle_valid( int  indx ) const
{
	return( (this -> player_body_angle_valid)
		& (1 << (MAX_PLAYER + indx)) );
}

bool   Debug_Client_Field_Recog::teammate_coordinate_set_valid( int  indx ,
								bool  b )
{
	if ( b )
	{
		(this -> player_coordinate_valid) |= (1 << indx);
	}
	else
	{
		(this -> player_coordinate_valid) &= ~(1 << indx);
	}

	return( this -> teammate_coordinate_valid( indx ) );
}

bool   Debug_Client_Field_Recog::opponent_coordinate_set_valid( int  indx ,
								bool  b )
{
	if ( b )
	{
		(this -> player_coordinate_valid)
			|= (1 << (MAX_PLAYER + indx));
	}
	else
	{
		(this -> player_coordinate_valid)
			&= ~(1 << (MAX_PLAYER + indx));
	}

	return( this -> opponent_coordinate_valid( indx ) );
}


bool   Debug_Client_Field_Recog::teammate_body_angle_set_valid( int  indx ,
								bool  b )
{
	if ( b )
	{
		(this -> player_body_angle_valid) |= (1 << indx);
	}
	else
	{
		(this -> player_body_angle_valid) &= ~(1 << indx);
	}

	return( this -> teammate_body_angle_valid( indx ) );
}

bool   Debug_Client_Field_Recog::opponent_body_angle_set_valid( int  indx ,
								bool  b )
{
	if ( b )
	{
		this -> player_body_angle_valid |= (1 << (MAX_PLAYER + indx));
	}
	else
	{
		this -> player_body_angle_valid &= ~(1 << (MAX_PLAYER + indx));
	}

	return( this -> opponent_body_angle_valid( indx ) );
}


Debug_Client_Field_Recog::Debug_Client_Field_Recog
				( const Client_Debug_View &  view )
	: player_coordinate_valid( 0x0 ) ,
	  player_body_angle_valid( 0x0 ) ,
	  ball_coordinate_valid  ( false ) ,
	  ball_velocity_valid    ( false ) ,
	  self_face_angle_valid  ( false ) ,
	  player_number( -1 ),
	  side( 0 ) ,
	  target_teammate( -1 ) ,
	  have_target_point_flag( false ) , have_message_flag( false ) ,
	  target_point_x( 0.0 ) , target_point_y( 0.0 ) ,
	  message()
{
	assert( sizeof(unsigned long) * CHAR_BIT >= MAX_PLAYER * 2 );

	ref_count_ptr<const Field_Recog_Snapshot>	field
		= view.field_snapshot();

	this -> player_number
		= field -> game_state.game_info.self_player_number;

	switch( field -> game_state.game_info.our_side )
	{
	case S_Side_LR::Left_Side:
		this -> side = +1;
		break;
	case S_Side_LR::Right_Side:
		this -> side = -1;
		break;
	case S_Side_LR::Unknown:
		this -> side = 0;
		break;
	}

	if ( (this -> self_face_angle_valid
	      = field -> body.neck_angle.valid()) == true )
	{
		this -> self_additional.face_angle
			= field -> body.neck_angle.point().degree();
	}

	if ( (this -> ball_coordinate_valid
	      = field -> ball.coordinate.valid()) == true )
	{
		this -> ball.coordinate_x
				= field -> ball.coordinate.point().x();
		this -> ball.coordinate_y
				= field -> ball.coordinate.point().y();

		if ( (this -> ball_velocity_valid
		      = field -> ball.velocity.valid()) == true )
		{
			this -> ball.velocity_x
				= field -> ball.velocity.point().x();
			this -> ball.velocity_y
				= field -> ball.velocity.point().y();
		}

		if ( view.ball_comment().length() == 0 )
		{
			this -> ball.comment = static_cast<char *>(0);
		}
		else
		{
			this -> ball.comment
				= new char[ view.ball_comment().length() + 1 ];
			std::strcpy( this -> ball.comment ,
				     view.ball_comment().c_str() );
		}
	}
	else
	{
		this -> ball.comment = static_cast<char *>(0);
	}

	for ( int  i = 0  ;  i < MAX_PLAYER  ;  i ++ )
	{
		if ( this -> teammate_coordinate_set_valid
			( i , field -> teammate[i].coordinate.valid() ) )
		{
			this -> teammate[i].x
			  = field -> teammate[i].coordinate.point().x();
			this -> teammate[i].y
			  = field -> teammate[i].coordinate.point().y();
		}

		if ( this -> teammate_body_angle_set_valid
		        ( i , field -> teammate[i].body_angle.valid()) )
		{
			this -> teammate[i].body_angle
			    = field -> teammate[i].body_angle.point().degree();
		}

		if ( view.teammate_comment(i+1).length() == 0 )
		{
			this -> teammate[i].comment
				= static_cast<char *>(0);
		}
		else
		{
			this -> teammate[i].comment
			 = new char[ view.teammate_comment(i+1).length() + 1 ];
			std::strcpy( this -> teammate[i].comment ,
				     view.teammate_comment(i+1).c_str() );
		}
	}

	for ( int  i = 0  ;  i < MAX_PLAYER  ;  i ++ )
	{
		if ( this -> opponent_coordinate_set_valid
			( i , field -> opponent[i].coordinate.valid() ) )
		{
			this -> opponent[i].x
			  = field -> opponent[i].coordinate.point().x();
			this -> opponent[i].y
			  = field -> opponent[i].coordinate.point().y();
		}

		if ( this -> opponent_body_angle_set_valid
		        ( i , field -> opponent[i].body_angle.valid()) )
		{
			this -> opponent[i].body_angle
			    = field -> opponent[i].body_angle.point().degree();
		}

		if ( view.opponent_comment(i+1).length() == 0 )
		{
			this -> opponent[i].comment = static_cast<char *>(0);
		}
		else
		{
			this -> opponent[i].comment
			 = new char[ view.opponent_comment(i+1).length() + 1 ];
			std::strcpy( this -> opponent[i].comment ,
				     view.opponent_comment(i+1).c_str() );
		}
	}

	for ( size_t  i = 0  ;  i < field -> unknown_player.size()  ;  i ++ )
	{
		if ( field -> unknown_player[i].coordinate.valid() )
		{
			Unknown_Player_Info	pl;
			pl.x
			  = field -> unknown_player[i].coordinate.point().x();
			pl.y
			  = field -> unknown_player[i].coordinate.point().y();

			this -> unknown_player.push_back( pl );
		}
	}

	this -> target_teammate = view.get_target_teammate();

	if ( view.have_target_point() )
	{
		this -> target_point_x = view.get_target_point().x();
		this -> target_point_y = view.get_target_point().y();

		this -> have_target_point_flag = true;
	}

	if ( view.have_message() )
	{
		this -> message = view.get_message();

		this -> have_message_flag = true;
	}
}

Debug_Client_Field_Recog::~Debug_Client_Field_Recog()
{
	delete  ball.comment;

	for ( int  i = 0  ;  i < MAX_PLAYER  ;  i ++ )
	{
		delete  teammate[i].comment;
	}

	for ( int  i = 0  ;  i < MAX_PLAYER  ;  i ++ )
	{
		delete  opponent[i].comment;
	}
}

const char *  Debug_Client_Field_Recog::ball_comment() const
{
	return( ball.comment );
}

const char *  Debug_Client_Field_Recog::teammate_comment( int  num ) const
{
	assert( 1 <= num && num <= MAX_PLAYER );

	return( teammate[num - 1].comment );
}

const char *  Debug_Client_Field_Recog::opponent_comment( int  num ) const
{
	assert( 1 <= num && num <= MAX_PLAYER );

	return( opponent[num - 1].comment );
}

// XXX
int   Debug_Client_Field_Recog::get_target_teammate() const
{
	return( this -> target_teammate );
}

// XXX
bool   Debug_Client_Field_Recog::have_target_point() const
{
	return( this -> have_target_point_flag );
}

// XXX
D2_Vector   Debug_Client_Field_Recog::get_target_point() const
{
	return( D2_Vector( this -> target_point_x , this -> target_point_y ) );
}

// XXX
bool   Debug_Client_Field_Recog::have_message() const
{
	return( this -> have_message_flag );
}

// XXX
std::string  Debug_Client_Field_Recog::get_message() const
{
	return( this -> message );
}


ref_count_ptr<const Field_Recog_Abstract::Field_Recog_Snapshot>
	Debug_Client_Field_Recog::snapshot() const
{
	ref_count_ptr<Field_Recog_Abstract::Field_Recog_Snapshot>
	  ret = new Field_Recog_Abstract::Field_Recog_Snapshot( &dummy_param );

	ret -> game_state.game_info.self_player_number
		= this -> player_number;

	switch( this -> side )
	{
	case +1:
		ret -> game_state.game_info.our_side = S_Side_LR::Left_Side;
		break;
	case -1:
		ret -> game_state.game_info.our_side = S_Side_LR::Right_Side;
		break;
	default:
		ret -> game_state.game_info.our_side = S_Side_LR::Unknown;
		break;
	}

	if ( this -> self_face_angle_valid )
	{
		ret -> body.neck_angle
			.set( Degree( -180.0 ) , Degree( +180.0 ) ,
			      Degree( this -> self_additional.face_angle ) );

		ret -> teammate[this -> player_number - 1].face_angle
			.set( Degree( -180.0 ) , Degree( +180.0 ) ,
			      Degree( this -> self_additional.face_angle ) );
	}

	if ( this -> ball_coordinate_valid )
	{
		ret -> ball.coordinate
			.set( D2_Region::universal_region() ,
			      D2_Vector( this -> ball.coordinate_x ,
					 this -> ball.coordinate_y ) );
		ret -> ball.coordinate_accuracy = 0;

		if ( this -> ball_velocity_valid )
		{
			ret -> ball.velocity
				.set( D2_Region::universal_region() ,
				      D2_Vector( this -> ball.velocity_x ,
						 this -> ball.velocity_y ) );
			ret -> ball.velocity_accuracy = 0;
		}
	}

	for ( int  i = 0  ;  i < MAX_PLAYER  ;  i ++ )
	{
		if ( this -> teammate_coordinate_valid(i) )
		{
			ret -> teammate[i].coordinate.set
				( D2_Region::universal_region() ,
				  D2_Vector( this -> teammate[i].x ,
					     this -> teammate[i].y ) );

			ret -> teammate[i].coordinate_accuracy = 0;
		}

		if ( this -> teammate_body_angle_valid(i) )
		{
			ret -> teammate[i].body_angle.set
				( Degree( -180.0 ) , Degree( +180.0 ) ,
				  Degree( this -> teammate[i].body_angle ) );
		}
		else
		{
			ret -> teammate[i].body_angle.set
				( Degree( -180.0 ) , Degree( +180.0 ) ,
				  Degree( 0.0 ) );
		}
	}

	for ( int  i = 0  ;  i < MAX_PLAYER  ;  i ++ )
	{
		if ( this -> opponent_coordinate_valid(i) )
		{
			ret -> opponent[i].coordinate.set
				( D2_Region::universal_region() ,
				  D2_Vector( this -> opponent[i].x ,
					     this -> opponent[i].y ) );

			ret -> opponent[i].coordinate_accuracy = 0;
		}

		if ( this -> opponent_body_angle_valid(i) )
		{
			ret -> opponent[i].body_angle.set
				( Degree( -180.0 ) , Degree( +180.0 ) ,
				  Degree( this -> opponent[i].body_angle ) );
		}
		else
		{
			ret -> opponent[i].body_angle.set
				( Degree( -180.0 ) , Degree( +180.0 ) ,
				  Degree( -180.0 ) );
		}
	}

	for ( size_t  i = 0  ;  i < unknown_player.size()  ;  i ++ )
	{
		Field_Recog_Abstract::Player_Info	pl;

		pl.coordinate.set( D2_Region::universal_region() ,
				   D2_Vector( this -> unknown_player[i].x ,
					      this -> unknown_player[i].y ) );

		pl.coordinate_accuracy = 0;

		ret -> unknown_player.push_back( pl );
	}

	if ( this -> teammate_body_angle_valid( this -> player_number - 1 ) )
	{
		ret -> body.my_body_angle.set
			( Degree( -180.0 ) , Degree( +180.0 ) ,
			  Degree( this -> teammate[this -> player_number - 1]
							      .body_angle ) );

		ret -> teammate[this -> player_number - 1].coordinate_accuracy
			= 0;
	}
	else
	{
		ret -> body.my_body_angle.set
			( Degree( -180.0 ) , Degree( +180.0 ) ,
			  Degree( 0.0 ) );

		ret -> teammate[this -> player_number - 1].coordinate_accuracy
			= 0;
	}

	return( ret );
}
