#ifndef	   DEBUG_CLIENT_FIELD_RECOG_H_INCLUDED
#define	   DEBUG_CLIENT_FIELD_RECOG_H_INCLUDED

#include  "field_recog_abstract.h"
#include  "field_recog_interface.h"
#include  "client_debug_view.h"
#include  "ref_count_ptr.h"
#include  <vector>
#include  <string>

class  Debug_Client_Field_Recog : public Field_Recog_Abstract
{
protected:
	static	SServer_Param	dummy_param;

protected:
	struct  Ball_Info
	{
		float	coordinate_x;
		float	coordinate_y;
		float	velocity_x;
		float	velocity_y;

		char *	comment;
	};

	struct  Player_Info
	{
		float	x;
		float	y;

		float	body_angle;

		char *	comment;
	};

	struct  Unknown_Player_Info
	{
		float	x;
		float	y;
	};

	struct  Self_Additional_Info
	{
		float	face_angle;
	};

	Ball_Info				ball;
	Player_Info				teammate[MAX_PLAYER];
	Player_Info				opponent[MAX_PLAYER];
	std::vector<Unknown_Player_Info>	unknown_player;
	Self_Additional_Info			self_additional;

	unsigned long	player_coordinate_valid : MAX_PLAYER * 2;
	unsigned long	player_body_angle_valid : MAX_PLAYER * 2;
	bool		ball_coordinate_valid   : 1;
	bool		ball_velocity_valid     : 1;
	bool		self_face_angle_valid   : 1;

	int		player_number : 5;
	int		side : 2;

	// XXX
	int		target_teammate : 5;

	// XXX
	bool		have_target_point_flag : 1;
	bool		have_message_flag : 1;

	float		target_point_x;
	float		target_point_y;

	std::string	message;

protected:
	bool	teammate_coordinate_valid( int  indx ) const;
	bool	opponent_coordinate_valid( int  indx ) const;
	bool	teammate_body_angle_valid( int  indx ) const;
	bool	opponent_body_angle_valid( int  indx ) const;
	bool	teammate_coordinate_set_valid( int  indx ,  bool  b );
	bool	opponent_coordinate_set_valid( int  indx ,  bool  b );
	bool	teammate_body_angle_set_valid( int  indx ,  bool  b );
	bool	opponent_body_angle_set_valid( int  indx ,  bool  b );

public:
		 Debug_Client_Field_Recog( const Client_Debug_View &  view );
	virtual	~Debug_Client_Field_Recog();

	virtual	ref_count_ptr<const Field_Recog_Snapshot>	snapshot()
									const;
	virtual	const char *	ball_comment() const;
	virtual	const char *	teammate_comment( int  num ) const;
	virtual	const char *	opponent_comment( int  num ) const;

	// XXX
	virtual	int		get_target_teammate() const;

	// XXX
	virtual	bool		have_target_point() const;
	virtual	D2_Vector	get_target_point() const;

	// XXX
	virtual	bool		have_message() const;
	virtual	std::string	get_message() const;
};


#endif	/* DEBUG_CLIENT_FIELD_RECOG_H_INCLUDED */
