#include  "log_supplyer.h"
#include  "sserver_monitor_log_format.h"
#include  "comstream.h"
#include  <iostream>
#include  <cstdlib>
#include  <algorithm>

Log_Supplyer::Log_Supplyer
		( const ref_count_ptr<Abstruct_Updator> &  updator ,
		  const ref_count_ptr<Abstruct_Updator::Callback> &  callback ,
		  const std::string &  log_file_name )
	: file( static_cast<std::istream *>(0) ) , fds() ,
	  version( -1 ) , v3_play_mode()
{
	if ( log_file_name == "-" )
	{
		file = new std::istream( std::cin.rdbuf() );

		fds.push_back( 0 );
	}
	else if ( log_file_name.substr
		  ( log_file_name.length() - std::strlen(".gz") ) == ".gz" )
	{
		comstream *	com_stream = new comstream
						 ( "gzip" ,
						   "-dc" ,
						   log_file_name.c_str() ,
						   static_cast<char *>(0) );
		com_stream -> close( std::ios::in );

		file = com_stream;

		if ( com_stream -> fd( std::ios::out ) != comstream::BAD_FD )
		{
			fds.push_back( com_stream -> fd( std::ios::out ) );
		}
	}
	else if ( log_file_name.substr
		  ( log_file_name.length() - std::strlen(".bz2") ) == ".bz2" )
	{
		comstream *	com_stream = new comstream
						 ( "bzip2" ,
						   "-dc" ,
						   log_file_name.c_str() ,
						   static_cast<char *>(0) );
		com_stream -> close( std::ios::in );

		file = com_stream;

		if ( com_stream -> fd( std::ios::out ) != comstream::BAD_FD )
		{
			fds.push_back( com_stream -> fd( std::ios::out ) );
		}
	}
	else if ( log_file_name.substr
		  ( log_file_name.length() - std::strlen(".Z") ) == ".Z" )
	{
		comstream *	com_stream = new comstream
						 ( "uncompress" ,
						   "-c" ,
						   log_file_name.c_str() ,
						   static_cast<char *>(0) );
		com_stream -> close( std::ios::in );

		file = com_stream;

		if ( com_stream -> fd( std::ios::out ) != comstream::BAD_FD )
		{
			fds.push_back( com_stream -> fd( std::ios::out ) );
		}
	}
	else
	{
		std::ifstream *	file_stream = new std::ifstream
						  ( log_file_name.c_str() ,
						    std::ios::in );

		file = file_stream;

		if ( file_stream -> rdbuf() )
		{
			fds.push_back( file_stream -> rdbuf() -> fd() );
		}
	}

	if ( ! file )
	{
		std::cerr << "Can't open file \"" << log_file_name << "\"."
			  << std::endl;

		std::exit( 1 );
	}


	v3_play_mode = SServer_Monitor_Log_Format::Null_Mode;
	v3_team[0].name[0] = '\0';
	v3_team[1].name[0] = '\0';
	v3_team[0].score = 0;
	v3_team[1].score = 0;


	char	ulg[4];

	if ( ! file -> read( ulg , 4 )
	     || file -> gcount() != 4
	     || ulg[0] != 'U'
	     || ulg[1] != 'L'
	     || ulg[2] != 'G'
	     || (   ulg[3] != SServer_Monitor_Log_Format::REC_VERSION_2
		 && ulg[3] != SServer_Monitor_Log_Format::REC_VERSION_3 ) )
	{
		std::cerr << "Can't interpret \"" << log_file_name << "\"."
			  << std::endl;

		std::exit( 1 );
	}

	switch( ulg[3] )
	{
	case  SServer_Monitor_Log_Format::REC_VERSION_2:
		version = 2;
		break;

	case  SServer_Monitor_Log_Format::REC_VERSION_3:
		version = 3;
		break;

	default:
		version = -1;
		break;
	}

	updator -> set_interval_callback( callback , 1 /* msec */ );
}

Log_Supplyer::~Log_Supplyer()
{
	delete file;
}

ref_count_ptr<const Monitor_View_Data>
  Log_Supplyer::get( const ref_count_ptr<Abstruct_Updator> &  updator ,
		     bool *  have_s_param ,
		     SServer_Monitor_Log_Format::server_param_t *  s_param )
{
	*have_s_param = false;


	//
	// get data
	//
	if ( ! this -> responsive() )
	{
		updator -> stop_interval();

		return( static_cast<Monitor_View_Data *>(0) );
	}
	else
	{
		switch( version )
		{
		case  2:
			return( SServer_Monitor_Log_Format
				::parse_dispinfo_t( *file ) );
			break;

		case  3:
			return( SServer_Monitor_Log_Format
				::parse_log_v3( *file ,
						&v3_play_mode , v3_team ,
						have_s_param , s_param ) );
			break;

		default:
			return( static_cast<Monitor_View_Data *>(0) );
			break;
		}
	}
}

bool   Log_Supplyer::responsive() const
{
	return( static_cast<bool>( *file ) && ! file -> eof() );
}
