#include  "monitor_supplyer.h"
#include  "sserver_monitor_log_format.h"

Monitor_Supplyer::Monitor_Supplyer
	     ( const ref_count_ptr<Abstruct_Updator> &  updator ,
	       const ref_count_ptr<Abstruct_Updator::Callback> &  callback ,
	       const std::string &  host_name ,
	       ip_port_number_t  server_port ,
	       int  protocol_version )
	: connection( host_name , server_port ) ,
	  protocol_version( protocol_version )
{
	connection.send_dispinit( protocol_version );

	updator -> set_fd_callback( callback , connection.fd() );
}

Monitor_Supplyer::~Monitor_Supplyer()
{
}

ref_count_ptr<const Monitor_View_Data>  Monitor_Supplyer::get
		( const ref_count_ptr<Abstruct_Updator> & ,
		  bool *  have_s_param ,
		  SServer_Monitor_Log_Format::server_param_t *  s_param )
{
	*have_s_param = false;


	//
	// get data
	//
	std::string	input;
	if ( ! this -> connection.recv( &input , false ) )
	{
		return( static_cast<Monitor_View_Data *>(0) );
	}

	switch( protocol_version )
	{
	case 1:
		return( SServer_Monitor_Log_Format
				::parse_dispinfo_t( input ) );
		break;

	case 2:
		return( SServer_Monitor_Log_Format
			  ::parse_monitor_v2( input ,
					      have_s_param , s_param) );
		break;

	default:
		return( static_cast<Monitor_View_Data *>(0) );
		break;
	}
}

bool   Monitor_Supplyer::responsive() const
{
	return( this -> connection.responsive() );
}

int   Monitor_Supplyer::send_start()
{
	return( this -> connection.send_dispstart() );
}

int   Monitor_Supplyer::send_foul( double  x ,  double  y ,
				   S_Side_LR  side )
{
	return( this -> connection.send_dispfoul( x , y , side ) );
}
