#include  "monitor_view_data.h"
#include  <cmath>

using namespace SServer_Monitor_Log_Format;

Monitor_View_Data::Player_State::Player_State()
	: p() , side_( S_Side_LR::Unknown ) , uniform_number_( -1 ) ,
	  have_showinfo_t2_extension_( false ) ,
	  have_overrided_stamina_( false ) ,
	  have_overrided_effort_( false ) ,
	  have_overrided_head_angle_( false ) ,
	  have_overrided_view_width_( false )
{
	p.mode			= 0x0;
	p.type			= 0;
	p.x			= 0;
	p.y			= 0;
	p.delta_x		= 0;
	p.delta_y		= 0;
	p.body_angle		= 0;
	p.head_angle		= 0;
	p.view_width		= 0;
	p.view_quality		= 0;
	p.stamina		= 0;
	p.effort		= 0;
	p.recovery		= 0;
	p.kick_count		= 0;
	p.dash_count		= 0;
	p.turn_count		= 0;
	p.say_count		= 0;
	p.turn_neck_count	= 0;
	p.catch_count		= 0;
	p.move_count		= 0;
	p.change_view_count	= 0;
}

Monitor_View_Data::Player_State::Player_State( const player_t &  p )
	: p( p ) , side_( S_Side_LR::Unknown ) , uniform_number_( -1 ) ,
	  have_showinfo_t2_extension_( true ) ,
	  have_overrided_stamina_( false ) ,
	  have_overrided_effort_( false ) ,
	  have_overrided_head_angle_( false ) ,
	  have_overrided_view_width_( false )
{
}

Monitor_View_Data::Player_State::Player_State
	( const SServer_Monitor_Log_Format::pos_t &  pos )
	: p() , side_( pos.side_lr() ) , uniform_number_( pos.unum ) ,
	  have_showinfo_t2_extension_( false ) ,
	  have_overrided_stamina_( false ) ,
	  have_overrided_effort_( false ) ,
	  have_overrided_head_angle_( false ) ,
	  have_overrided_view_width_( false )
{
	p.mode			= pos.enable;
	p.type			= 0;
	p.x			= static_cast<long>
				  ( pos.x
				    * (SHOWINFO_SCALE_2 / SHOWINFO_SCALE) );
	p.y			= static_cast<long>
				  ( pos.y
				    * (SHOWINFO_SCALE_2 / SHOWINFO_SCALE) );
	p.delta_x		= 0;
	p.delta_y		= 0;
	p.body_angle		= static_cast<long>
				  ( rint( Degree( pos.angle ).radian()
					  * SHOWINFO_SCALE_2 ) );
	p.head_angle		= 0;
	p.view_width		= 0;
	p.view_quality		= 0;
	p.stamina		= 0;
	p.effort		= 0;
	p.recovery		= 0;
	p.kick_count		= 0;
	p.dash_count		= 0;
	p.turn_count		= 0;
	p.say_count		= 0;
	p.turn_neck_count	= 0;
	p.catch_count		= 0;
	p.move_count		= 0;
	p.change_view_count	= 0;
}


bool   Monitor_View_Data::Player_State::have_stamina() const
{
	return( have_showinfo_t2_extension_ || have_overrided_stamina_ );
}

bool   Monitor_View_Data::Player_State::have_effort() const
{
	return( have_showinfo_t2_extension_ || have_overrided_effort_ );
}

bool   Monitor_View_Data::Player_State::have_head_angle() const
{
	return( have_showinfo_t2_extension_ || have_overrided_head_angle_ );
}

bool   Monitor_View_Data::Player_State::have_view_width() const
{
	return( have_showinfo_t2_extension_ || have_overrided_view_width_ );
}


bool   Monitor_View_Data::Player_State::valid() const
{
	return( p.mode & STAND );
}

bool   Monitor_View_Data::Player_State::goalie() const
{
	return( p.mode & GOALIE );
}

bool   Monitor_View_Data::Player_State::kicking() const
{
	return( p.mode & KICKING );
}

bool   Monitor_View_Data::Player_State::kicking_fault() const
{
	return( p.mode & KICKING_FAULT );
}

bool   Monitor_View_Data::Player_State::catching() const
{
	return( p.mode & CATCHING );
}

bool   Monitor_View_Data::Player_State::catching_fault() const
{
	return( p.mode & CATCHING_FAULT );
}

bool   Monitor_View_Data::Player_State::ball_to_player() const
{
	return( p.mode & BALL_TO_PLAYER );
}

bool   Monitor_View_Data::Player_State::player_to_ball() const
{
	return( p.mode & PLAYER_TO_BALL );
}

bool   Monitor_View_Data::Player_State::discard() const
{
	return( p.mode & DISCARD );
}

int    Monitor_View_Data::Player_State::uniform_number() const
{
	return( uniform_number_ );
}

S_Side_LR  Monitor_View_Data::Player_State::side() const
{
	return( side_ );
}

double  Monitor_View_Data::Player_State::x() const
{
	return( static_cast<double>( p.x ) / SHOWINFO_SCALE_2 );
}

double  Monitor_View_Data::Player_State::y() const
{
	return( static_cast<double>( p.y ) / SHOWINFO_SCALE_2 );
}

Angle  Monitor_View_Data::Player_State::body_angle() const
{
	return( Radian( static_cast<double>( p.body_angle )
			/ SHOWINFO_SCALE_2 ) );
}

Angle  Monitor_View_Data::Player_State::head_angle() const
{
	return( Radian( static_cast<double>( p.head_angle )
			/ SHOWINFO_SCALE_2 ) );
}

Angle  Monitor_View_Data::Player_State::view_width() const
{
	return( Radian( static_cast<double>( p.view_width )
			/ SHOWINFO_SCALE_2 ) );
}

double  Monitor_View_Data::Player_State::stamina() const
{
	return( static_cast<double>( p.stamina ) / SHOWINFO_SCALE_2 );
}

double  Monitor_View_Data::Player_State::effort() const
{
	return( static_cast<double>( p.effort ) / SHOWINFO_SCALE_2 );
}

bool   Monitor_View_Data::Player_State::full_effort() const
{
	return( p.effort == SHOWINFO_SCALE_2 );
}


void   Monitor_View_Data::Player_State::set_valid( bool  b )
{
	b ? (p.mode |= STAND) : (p.mode &= ~STAND);
}

void   Monitor_View_Data::Player_State::set_goalie( bool  b )
{
	b ? (p.mode |= GOALIE) : (p.mode &= ~GOALIE);
}

void   Monitor_View_Data::Player_State::set_kicking( bool  b )
{
	b ? (p.mode |= KICKING) : (p.mode &= ~KICKING);
}

void   Monitor_View_Data::Player_State::set_kicking_fault( bool  b )
{
	b ? (p.mode |= KICKING_FAULT) : (p.mode &= ~KICKING_FAULT);
}

void   Monitor_View_Data::Player_State::set_catching( bool  b )
{
	b ? (p.mode |= CATCHING) : (p.mode &= ~CATCHING);
}

void   Monitor_View_Data::Player_State::set_catching_fault( bool  b )
{
	b ? (p.mode |= CATCHING_FAULT) : (p.mode &= ~CATCHING_FAULT);
}

void   Monitor_View_Data::Player_State::set_ball_to_player( bool  b )
{
	b ? (p.mode |= BALL_TO_PLAYER) : (p.mode &= ~BALL_TO_PLAYER);
}

void   Monitor_View_Data::Player_State::set_player_to_ball( bool  b )
{
	b ? (p.mode |= PLAYER_TO_BALL) : (p.mode &= ~PLAYER_TO_BALL);
}

void   Monitor_View_Data::Player_State::set_discard( bool  b )
{
	b ? (p.mode |= DISCARD) : (p.mode &= ~DISCARD);
}

void   Monitor_View_Data::Player_State::set_uniform_number( int  u )
{
	uniform_number_ = u;
}

void   Monitor_View_Data::Player_State::set_side( const S_Side_LR &  s )
{
	side_ = s;
}

void   Monitor_View_Data::Player_State::set_body_angle( const Angle &  a )
{
	p.body_angle = static_cast<long>
			( ::rint( a.radian() * SHOWINFO_SCALE_2 ) );
}

void   Monitor_View_Data::Player_State::set_x( double  d )
{
	p.x = static_cast<long>( ::rint( d * SHOWINFO_SCALE_2 ) );
}

void   Monitor_View_Data::Player_State::set_y( double  d )
{
	p.y = static_cast<long>( ::rint( d * SHOWINFO_SCALE_2 ) );
}

void   Monitor_View_Data::Player_State::set_head_angle( const Angle &  a )
{
	p.head_angle = static_cast<long>
			( ::rint( a.radian() * SHOWINFO_SCALE_2 ) );

	have_overrided_head_angle_ = true;
}

void   Monitor_View_Data::Player_State::set_view_width( const Angle &  a )
{
	p.view_width = static_cast<long>
			( ::rint( a.radian() * SHOWINFO_SCALE_2 ) );
	have_overrided_view_width_ = true;
}

void   Monitor_View_Data::Player_State::set_stamina( double  s )
{
	p.stamina = static_cast<long>( ::rint( s * SHOWINFO_SCALE_2 ) );
	have_overrided_stamina_ = true;
}

void   Monitor_View_Data::Player_State::set_effort( double  e )
{
	p.effort = static_cast<long>( ::rint( e * SHOWINFO_SCALE_2 ) );
	have_overrided_effort_ = true;
}
