#ifndef	   MONITOR_VIEW_DATA_H_INCLUDED
#define	   MONITOR_VIEW_DATA_H_INCLUDED

// Author:		H. Shimora
// Created:		May 22 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  May 22 2000    base version.
//
//

#include  "s_basic.h"
#include  "angle.h"
#include  "d2_vector.h"
#include  "sserver_monitor_log_format.h"
#include  <vector>
#include  <string>

class  Monitor_View_Data
{
public:
	class  Player_State
	{
	protected:
		SServer_Monitor_Log_Format::player_t	p;

		S_Side_LR	side_;
		char		uniform_number_;
		bool		have_showinfo_t2_extension_ : 1;
		bool		have_overrided_stamina_     : 1;
		bool		have_overrided_effort_      : 1;
		bool		have_overrided_head_angle_  : 1;
		bool		have_overrided_view_width_  : 1;

	public:
		Player_State();
		Player_State( const SServer_Monitor_Log_Format::player_t & );
		Player_State( const SServer_Monitor_Log_Format::pos_t & );

		bool	have_stamina() const;
		bool	have_effort() const;
		bool	have_head_angle() const;
		bool	have_view_width() const;

		bool	valid()		 const;

		bool	goalie()	 const;
		bool	kicking()	 const;
		bool	kicking_fault()	 const;
		bool	catching()	 const;
		bool	catching_fault() const;
		bool	ball_to_player() const;
		bool	player_to_ball() const;
		bool	discard()	 const;

		S_Side_LR	side()	 const;

		int	uniform_number() const;

		double	x()		 const;
		double	y()		 const;

		Angle	body_angle()	 const;
		Angle	head_angle()	 const;

		Angle	view_width()	 const;

		double	stamina()	 const;
		double	effort()	 const;
		bool	full_effort()	 const;

	public:
		void	set_valid         ( bool  b );
		void	set_goalie        ( bool  b );
		void	set_kicking       ( bool  b );
		void	set_kicking_fault ( bool  b );
		void	set_catching      ( bool  b );
		void	set_catching_fault( bool  b );
		void	set_ball_to_player( bool  b );
		void	set_player_to_ball( bool  b );
		void	set_discard       ( bool  b );

		void	set_uniform_number( int  u );

		void	set_side( const S_Side_LR &  s );

		void	set_body_angle( const Angle &  a );
		void	set_x( double  d );
		void	set_y( double  d );

		void	set_head_angle( const Angle & );
		void	set_view_width( const Angle & );
		void	set_stamina( double  s );
		void	set_effort( double  e );
	};

	struct  Team_State
	{
		std::string	team_name;
		long		score;

	public:
		 Team_State() : team_name("") , score(0) {}
		~Team_State() {}
	};

	struct  Monitor_Play_Mode
	{
		char	pmode;

	public:
		enum Mode { Null_Mode ,		Before_Kick_Off ,
			    Time_Over ,		Play_On ,
			    Kick_Off_Left ,	Kick_Off_Right ,
			    Kick_In_Left ,	Kick_In_Right ,
			    Free_Kick_Left ,	Free_Kick_Right ,
			    Corner_Kick_Left ,	Corner_Kick_Right ,
			    Goal_Kick_Left ,	Goal_Kick_Right ,
			    Goal_Left ,		Goal_Right ,
			    Drop_Ball ,
			    Offside_Left ,	Offside_Right };

		static const int	N_MODE = 19;

	public:
		Monitor_Play_Mode( char  m = Null_Mode ) : pmode(m) {}

		operator Monitor_Play_Mode::Mode() const
		{
			return( static_cast<Mode>(pmode) );
		}

		bool	operator == ( const Mode &  m ) const
		{
			return( pmode == static_cast<char>(m) );
		}

		bool	operator != ( const Mode &  m ) const
		{
			return( ! ((*this) == m) );
		}

		bool	operator == ( const Monitor_Play_Mode &  m ) const
		{
			return( pmode == m.pmode );
		}

		bool	operator != ( const Monitor_Play_Mode &  m ) const
		{
			return( ! ((*this) == m) );
		}

		std::string	play_mode_str
				( const std::string &  left_teamname = "" ,
				  const std::string &  right_teamname = "" )
									 const
		{
			struct  Mode_Trans_Table
			{
				std::string	mode_string;
				S_Side_LR	side;
			};

			static	Mode_Trans_Table	table[N_MODE]
			= {
				{ "null" ,            S_Side_LR::Unknown } ,
				{ "before kick off" , S_Side_LR::Unknown } ,
				{ "time over" ,       S_Side_LR::Unknown } ,
				{ "play on" ,         S_Side_LR::Unknown } ,
				{ "kick off" ,        S_Side_LR::Left_Side } ,
				{ "kick off" ,        S_Side_LR::Right_Side } ,
				{ "kick in" ,         S_Side_LR::Left_Side } ,
				{ "kick in" ,         S_Side_LR::Right_Side } ,
				{ "free kick" ,       S_Side_LR::Left_Side } ,
				{ "free kick" ,       S_Side_LR::Right_Side } ,
				{ "corner kick" ,     S_Side_LR::Left_Side } ,
				{ "corner kick" ,     S_Side_LR::Right_Side } ,
				{ "goal kick" ,       S_Side_LR::Left_Side } ,
				{ "goal kick" ,       S_Side_LR::Right_Side } ,
				{ "goal" ,            S_Side_LR::Left_Side } ,
				{ "goal" ,            S_Side_LR::Right_Side } ,
				{ "drop ball" ,       S_Side_LR::Unknown } ,
				{ "offside" ,         S_Side_LR::Left_Side } ,
				{ "offside" ,         S_Side_LR::Right_Side }
			};

			if ( static_cast<size_t>(pmode)
			       >= (sizeof(table) / sizeof(table[0]))
			  || pmode < 0 )
			{
				std::cerr << "Unknown play mode" << std::endl;

				return( "Unknown" );
			}


			std::string	left_str;
			if ( left_teamname.length() == 0 )
			{
				left_str = "left";
			}
			else
			{
				left_str = std::string("\"")
					   + left_teamname + "\"";
			}

			std::string	right_str;
			if ( right_teamname.length() == 0 )
			{
				right_str = "right";
			}
			else
			{
				right_str = std::string("\"")
					    + right_teamname + "\"";
			}

			const Mode_Trans_Table &
				m = table[static_cast<int>(pmode)];

			if ( m.side == S_Side_LR::Left_Side )
			{
				return( m.mode_string + " " + left_str );
			}
			else if ( m.side == S_Side_LR::Right_Side )
			{
				return( m.mode_string + " " + right_str );
			}
			else
			{
				return( m.mode_string );
			}
		}

		S_Side_LR	advantage() const
		{
			switch( pmode )
			{
			case Kick_Off_Left:
			case Kick_In_Left:
			case Free_Kick_Left:
			case Corner_Kick_Left:
			case Goal_Kick_Left:
			case Offside_Right:
				return( S_Side_LR::Left_Side );
				break;

			case Kick_Off_Right:
			case Kick_In_Right:
			case Free_Kick_Right:
			case Corner_Kick_Right:
			case Goal_Kick_Right:
			case Offside_Left:
				return( S_Side_LR::Right_Side );
				break;

			case Null_Mode:
			case Before_Kick_Off:
			case Time_Over:
			case Play_On:
			case Goal_Left:
			case Goal_Right:
			case Drop_Ball:
			default:
				return( S_Side_LR::Unknown );
				break;
			}
		}

		static	std::vector<Monitor_Play_Mode>	mode_list()
		{
			std::vector<Monitor_Play_Mode>	m_list;

			for( int  i = 0  ;  i < N_MODE  ;  i ++ )
			{
				m_list.push_back( Mode(i) );
			}

			return( m_list );
		}
	};


public:
	Monitor_Play_Mode		play_mode;
	long				time_count;
	D2_Vector			ball;
	Player_State			player[MAX_PLAYER * 2];
	Team_State			team[2];

public:
	 Monitor_View_Data()
		 : play_mode() ,
		   time_count( -1 ) ,
		   ball( 0.0 , 0.0 ) ,
		   player(),
		   team()
	{
	}

	~Monitor_View_Data()
	{
	}
};


#endif	/* MONITOR_VIEW_DATA_H_INCLUDED */
