#include  "sserver_monitor_log_format.h"
#include  "monitor_view_data.h"
#include  "angle.h"
#include  <sys/types.h>
#include  <netinet/in.h>
#include  <cstring>
#include  <strstream>
#include  <iostream>

//
// dispinfo_t
//
ref_count_ptr<const Monitor_View_Data>
  SServer_Monitor_Log_Format::parse_dispinfo_t( const std::string &  str )
{
	std::istrstream	stream( str.data() , str.length() );

	return( parse_dispinfo_t( stream ) );
}

ref_count_ptr<const Monitor_View_Data>
  SServer_Monitor_Log_Format::parse_dispinfo_t( std::istream &  stream )
{
	//
	// byte stream -> dispinfo_t
	//
	dispinfo_t	info;

	std::memset( reinterpret_cast<char *>( &info ) , 0 , sizeof( info ) );

	stream.read( reinterpret_cast<char *>( &(info.mode) ) ,
		     sizeof( info.mode ) );
	if ( stream.gcount() != sizeof( info.mode ) )
	{
		return( static_cast<Monitor_View_Data *>(0) );
	}

	info.mode = ntohs( info.mode );

	switch( info.mode )
	{
	case SServer_Monitor_Log_Format::DISPINFO_MODE::SHOW_MODE:
	    {
		stream.read( reinterpret_cast<char *>( &(info.body.show) ) ,
			     sizeof( info.body.show ) );

		if ( stream.gcount() != sizeof( info.body.show ) )
		{
			return( static_cast<Monitor_View_Data *>(0) );
		}

		SServer_Monitor_Log_Format::showinfo_t &
			show = info.body.show;

		show.time          = ntohs( info.body.show.time );
		show.team[0].score = ntohs( show.team[0].score );
		show.team[1].score = ntohs( show.team[1].score );

		for ( int  i = 0  ;  i < MAX_PLAYER * 2 + 1  ;  i ++ )
		{
			show.pos[i].enable = ntohs( show.pos[i].enable );
			show.pos[i].side   = ntohs( show.pos[i].side   );
			show.pos[i].unum   = ntohs( show.pos[i].unum   );
			show.pos[i].angle  = ntohs( show.pos[i].angle  );
			show.pos[i].x      = ntohs( show.pos[i].x      );
			show.pos[i].y      = ntohs( show.pos[i].y      );
		}
	    }
	    break;

	case SServer_Monitor_Log_Format::DISPINFO_MODE::MSG_MODE:
	    {
		stream.read( reinterpret_cast<char *>
			     ( &(info.body.msg.board) ) ,
			     sizeof( info.body.msg.board ) );
		if ( stream.gcount() != sizeof( info.body.msg.board ) )
		{
			return( static_cast<Monitor_View_Data *>(0) );
		}
		info.body.msg.board = ntohs( info.body.msg.board );


		short	message_length = 0;
		stream.read( reinterpret_cast<char *>( &message_length ) ,
			     sizeof( message_length ) );
		if ( stream.gcount() != sizeof( message_length ) )
		{
			return( static_cast<Monitor_View_Data *>(0) );
		}
#ifndef OLD_LOG_2
		message_length = ntohs( message_length );
#endif
		if ( message_length
		     > static_cast<short>
		       ( sizeof( info.body.msg.message ) - 1 ) )
		{
			return( static_cast<Monitor_View_Data *>(0) );
		}

		stream.read( info.body.msg.message , message_length );
		if ( static_cast<short>(stream.gcount()) != message_length )
		{
			return( static_cast<Monitor_View_Data *>(0) );
		}
	    }
	    break;

	case SServer_Monitor_Log_Format::DISPINFO_MODE::NO_INFO:
		// ignore this message
		break;

	default:
		std::cerr << "unknown mode. (" << info.mode << ")"
			  << std::endl;
		break;
	}


	if ( info.mode
	     != SServer_Monitor_Log_Format::DISPINFO_MODE::SHOW_MODE )
	{
		return( static_cast<Monitor_View_Data *>(0) );
	}


	//
	// dispinfo_t -> Monitor_View_Data
	//
	ref_count_ptr<Monitor_View_Data>	data = new Monitor_View_Data();

	data -> time_count = info.body.show.time;
	data -> play_mode  = info.body.show.pmode;

	data -> team[0].team_name = info.body.show.team[0].name;
	data -> team[0].score     = info.body.show.team[0].score;
	data -> team[1].team_name = info.body.show.team[1].name;
	data -> team[1].score     = info.body.show.team[1].score;

	data -> ball.set( static_cast<double>( info.body.show.pos[0].x )
			  / SHOWINFO_SCALE ,
			  static_cast<double>( info.body.show.pos[0].y )
			  / SHOWINFO_SCALE );

	for ( int  i = 0  ;
	      i < SServer_Monitor_Log_Format::MAX_PLAYER * 2  ;  i ++ )
	{
		data -> player[i] = info.body.show.pos[i + 1];
	}

	return( data );
}


//
// monitor_v2
//
ref_count_ptr<const Monitor_View_Data>
  SServer_Monitor_Log_Format::parse_monitor_v2
	( const std::string &  str ,
	  bool *  have_s_param ,
	  SServer_Monitor_Log_Format::server_param_t *  s_param )
{
	*have_s_param = false;


	if ( str.size() != sizeof(dispinfo_t2) )
	{
		return( static_cast<Monitor_View_Data *>(0) );
	}


	//
	// byte stream -> dispinfo_t2
	//
	dispinfo_t2	info;

	std::memset( reinterpret_cast<char *>( &info ) , 0 , sizeof( info ) );

	info = *reinterpret_cast<const dispinfo_t2 *>(str.data());

	info.mode = ntohs( info.mode );

	if ( info.mode
	     == SServer_Monitor_Log_Format::DISPINFO_MODE::PARAM_MODE )
	{
		// XXX
		info.body.sparams.kick_power_rate
			= ntohl( info.body.sparams.kick_power_rate );
		info.body.sparams.stamina_max
			= ntohl( info.body.sparams.stamina_max );
		info.body.sparams.stamina_inc_max
			= ntohl( info.body.sparams.stamina_inc_max );

		*s_param = info.body.sparams;
		*have_s_param = true;
	}

	if ( info.mode
	     != SServer_Monitor_Log_Format::DISPINFO_MODE::SHOW_MODE )
	{
		return( static_cast<Monitor_View_Data *>(0) );
	}


	//
	// SHOW_MODE
	//
	SServer_Monitor_Log_Format::showinfo_t2 &	show = info.body.show;

	show.time          = ntohs( show.time );
	show.team[0].score = ntohs( show.team[0].score );
	show.team[1].score = ntohs( show.team[1].score );

	for ( int  i = 0  ;  i < MAX_PLAYER * 2  ;  i ++ )
	{
		SServer_Monitor_Log_Format::player_t &	pl = show.player[i];

		pl.mode              = ntohs( pl.mode );
		pl.type              = ntohs( pl.type );
		pl.x                 = ntohl( pl.x );
		pl.y                 = ntohl( pl.y );
		pl.delta_x           = ntohl( pl.delta_x );
		pl.delta_y           = ntohl( pl.delta_y );
		pl.body_angle        = ntohl( pl.body_angle );
		pl.head_angle        = ntohl( pl.head_angle );
		pl.view_width        = ntohl( pl.view_width );
		pl.view_quality      = ntohs( pl.view_quality );
		pl.stamina           = ntohl( pl.stamina );
		pl.effort            = ntohl( pl.effort );
		pl.recovery          = ntohl( pl.recovery );
		pl.kick_count        = ntohs( pl.kick_count );
		pl.dash_count        = ntohs( pl.dash_count );
		pl.turn_count        = ntohs( pl.turn_count );
		pl.say_count         = ntohs( pl.say_count );
		pl.turn_neck_count   = ntohs( pl.turn_neck_count );
		pl.catch_count       = ntohs( pl.catch_count );
		pl.move_count        = ntohs( pl.move_count );
		pl.change_view_count = ntohs( pl.change_view_count );
	}

	show.ball.x       = ntohl( show.ball.x       );
	show.ball.y       = ntohl( show.ball.y       );
	show.ball.delta_x = ntohl( show.ball.delta_x );
	show.ball.delta_y = ntohl( show.ball.delta_y );


	//
	// dispinfo_t2 -> Monitor_View_Data
	//
	ref_count_ptr<Monitor_View_Data>	data = new Monitor_View_Data();

	data -> time_count = show.time;
	data -> play_mode  = show.pmode;

	data -> team[0].team_name = show.team[0].name;
	data -> team[0].score     = show.team[0].score;
	data -> team[1].team_name = show.team[1].name;
	data -> team[1].score     = show.team[1].score;

	data -> ball.set( static_cast<double>(show.ball.x)
			  / SHOWINFO_SCALE_2 ,
			  static_cast<double>(show.ball.y)
			  / SHOWINFO_SCALE_2 );

	for ( int  i = 0  ;
	      i < SServer_Monitor_Log_Format::MAX_PLAYER * 2  ;  i ++ )
	{
		data -> player[i] = show.player[i];
		data -> player[i].set_uniform_number( i % MAX_PLAYER + 1 );
		data -> player[i].set_side( (i < MAX_PLAYER) ?
					      S_Side_LR::Left_Side
					    : S_Side_LR::Right_Side );
	}

	return( data );
}


//
// log_v3
//
ref_count_ptr<const Monitor_View_Data>
  SServer_Monitor_Log_Format::parse_log_v3( std::istream &  stream ,
					    char *  play_mode ,
					    team_t  team[2] ,
					    bool *  have_s_param ,
					    server_param_t *  s_param )
{
	*have_s_param = false;

	short	mode;

	stream.read( reinterpret_cast<char *>( &mode ) , sizeof( mode ) );
	if ( stream.gcount() != sizeof( mode ) )
	{
		return( static_cast<Monitor_View_Data *>(0) );
	}
	mode = ntohs( mode );


	SServer_Monitor_Log_Format::short_showinfo_t2	show;

	switch ( mode )
	{
	case  SServer_Monitor_Log_Format::DISPINFO_MODE::PM_MODE:
		stream.read( reinterpret_cast<char *>( play_mode ) ,
			     sizeof( *play_mode ) );
		if ( stream.gcount() != sizeof( *play_mode ) )
		{
			return( static_cast<Monitor_View_Data *>(0) );
		}

		return( static_cast<Monitor_View_Data *>(0) );
		break;

	case  SServer_Monitor_Log_Format::DISPINFO_MODE::TEAM_MODE:
		stream.read( reinterpret_cast<char *>( team ) ,
			     sizeof( team[0] ) * 2 );
		if ( stream.gcount() != sizeof( team[0] ) * 2 )
		{
			return( static_cast<Monitor_View_Data *>(0) );
		}

		team[0].score = ntohs( team[0].score );
		team[1].score = ntohs( team[1].score );

		return( static_cast<Monitor_View_Data *>(0) );
		break;

	case  SServer_Monitor_Log_Format::DISPINFO_MODE::SHOW_MODE:
		stream.read( reinterpret_cast<char *>( &show ) ,
			     sizeof( show ) );
		if ( stream.gcount() != sizeof( show ) )
		{
			return( static_cast<Monitor_View_Data *>(0) );
		}
		break;

	case  SServer_Monitor_Log_Format::DISPINFO_MODE::MSG_MODE:
		{
			msginfo_t	msg;

			stream.read( reinterpret_cast<char *>( &msg.board ) ,
				     sizeof( msg.board ) );
			if ( stream.gcount() != sizeof( msg.board ) )
			{
				return( static_cast<Monitor_View_Data *>(0) );
			}

			short	message_length;
			stream.read( reinterpret_cast<char *>
				     ( &message_length ) ,
				     sizeof( message_length ) );
			if ( stream.gcount() != sizeof( message_length ) )
			{
				return( static_cast<Monitor_View_Data *>(0) );
			}
			message_length = ntohs( message_length );

			if ( message_length > static_cast<short>
					      ( sizeof( msg.message ) - 1 ) )
			{
				return( static_cast<Monitor_View_Data *>(0) );
			}

			stream.read( reinterpret_cast<char *>
				     ( &(msg.message) ) ,
				     message_length );
			if ( static_cast<short>(stream.gcount())
			     != message_length )
			{
				return( static_cast<Monitor_View_Data *>(0) );
			}
		}

		return( static_cast<Monitor_View_Data *>(0) );
		break;

	case  SServer_Monitor_Log_Format::DISPINFO_MODE::PARAM_MODE:
		{
			server_param_t	s_param_buf;

			stream.read( reinterpret_cast<char *>( &s_param_buf ) ,
				     sizeof( s_param_buf ) );
			if ( stream.gcount() != sizeof( s_param_buf ) )
			{
				return( static_cast<Monitor_View_Data *>(0) );
			}

			// XXX
			s_param_buf.stamina_max
				= ntohl( s_param_buf.stamina_max );
			s_param_buf.stamina_inc_max
				= ntohl( s_param_buf.stamina_inc_max );
			s_param_buf.kick_power_rate
				= ntohl( s_param_buf.kick_power_rate );

			*s_param = s_param_buf;

			*have_s_param = true;
		}

		return( static_cast<Monitor_View_Data *>(0) );
		break;

	case  SServer_Monitor_Log_Format::DISPINFO_MODE::PPARAM_MODE:
		{
			player_param_t	p_param;

			stream.read( reinterpret_cast<char *>( &p_param ) ,
				     sizeof( p_param ) );
			if ( stream.gcount() != sizeof( p_param ) )
			{
				return( static_cast<Monitor_View_Data *>(0) );
			}
		}

		return( static_cast<Monitor_View_Data *>(0) );
		break;

	case  SServer_Monitor_Log_Format::DISPINFO_MODE::PT_MODE:
		{
			player_type_t	p_type;

			stream.read( reinterpret_cast<char *>( &p_type ) ,
				     sizeof( p_type ) );
			if ( stream.gcount() != sizeof( p_type ) )
			{
				return( static_cast<Monitor_View_Data *>(0) );
			}
		}

		return( static_cast<Monitor_View_Data *>(0) );

	default:
		std::cerr << "Unknown mode: " << mode << std::endl;
		return( static_cast<Monitor_View_Data *>(0) );
		break;
	}


	show.time = ntohs( show.time );

	for ( int  i = 0  ;  i < MAX_PLAYER * 2  ;  i ++ )
	{
		SServer_Monitor_Log_Format::player_t &	pl = show.player[i];

		pl.mode              = ntohs( pl.mode );
		pl.type              = ntohs( pl.type );
		pl.x                 = ntohl( pl.x );
		pl.y                 = ntohl( pl.y );
		pl.delta_x           = ntohl( pl.delta_x );
		pl.delta_y           = ntohl( pl.delta_y );
		pl.body_angle        = ntohl( pl.body_angle );
		pl.head_angle        = ntohl( pl.head_angle );
		pl.view_width        = ntohl( pl.view_width );
		pl.view_quality      = ntohs( pl.view_quality );
		pl.stamina           = ntohl( pl.stamina );
		pl.effort            = ntohl( pl.effort );
		pl.recovery          = ntohl( pl.recovery );
		pl.kick_count        = ntohs( pl.kick_count );
		pl.dash_count        = ntohs( pl.dash_count );
		pl.turn_count        = ntohs( pl.turn_count );
		pl.say_count         = ntohs( pl.say_count );
		pl.turn_neck_count   = ntohs( pl.turn_neck_count );
		pl.catch_count       = ntohs( pl.catch_count );
		pl.move_count        = ntohs( pl.move_count );
		pl.change_view_count = ntohs( pl.change_view_count );
	}

	show.ball.x       = ntohl( show.ball.x       );
	show.ball.y       = ntohl( show.ball.y       );
	show.ball.delta_x = ntohl( show.ball.delta_x );
	show.ball.delta_y = ntohl( show.ball.delta_y );


	//
	// dispinfo_t2 -> Monitor_View_Data
	//
	ref_count_ptr<Monitor_View_Data>	data = new Monitor_View_Data();

	data -> time_count = show.time;
	data -> play_mode  = *play_mode;

	data -> team[0].team_name = team[0].name;
	data -> team[0].score     = team[0].score;
	data -> team[1].team_name = team[1].name;
	data -> team[1].score     = team[1].score;

	data -> ball.set( static_cast<double>(show.ball.x)
			  / SHOWINFO_SCALE_2 ,
			  static_cast<double>(show.ball.y)
			  / SHOWINFO_SCALE_2 );

	for ( int  i = 0  ;
	      i < SServer_Monitor_Log_Format::MAX_PLAYER * 2  ;  i ++ )
	{
		data -> player[i] = show.player[i];
		data -> player[i].set_uniform_number( i % MAX_PLAYER + 1 );
		data -> player[i].set_side( (i < MAX_PLAYER) ?
					      S_Side_LR::Left_Side
					    : S_Side_LR::Right_Side );
	}

	return( data );
}

ref_count_ptr<const Monitor_View_Data>
  SServer_Monitor_Log_Format::parse_log_v3( const std::string &  input ,
					    char *  play_mode ,
					    team_t  team[2] ,
					    bool *  have_s_param ,
					    server_param_t *  s_param ,
					    size_t *  n_read )
{
	*have_s_param = false;

	short	mode;

	*n_read = 0;

	const char *	p = input.data();

	if ( input.size() < sizeof(short) )
	{
		return( static_cast<Monitor_View_Data *>(0) );
	}
	else
	{
		mode = *(reinterpret_cast<const short *>(p));
		mode = ntohs( mode );
		p += sizeof(short);
		*n_read += sizeof(short);
	}


	SServer_Monitor_Log_Format::short_showinfo_t2	show;

	switch ( mode )
	{
	case  SServer_Monitor_Log_Format::DISPINFO_MODE::PM_MODE:
		if ( input.size() < (*n_read) + sizeof(*play_mode) )
		{
			return( static_cast<Monitor_View_Data *>(0) );
		}
		else
		{
			*play_mode = *(reinterpret_cast<const char *>(p));
			p += sizeof(*play_mode);
			*n_read += sizeof(*play_mode);
		}

		return( static_cast<Monitor_View_Data *>(0) );
		break;

	case  SServer_Monitor_Log_Format::DISPINFO_MODE::TEAM_MODE:
		if ( input.size() < (*n_read) + sizeof( team[0] ) * 2 )
		{
			return( static_cast<Monitor_View_Data *>(0) );
		}
		else
		{
			team[0] = (reinterpret_cast<const team_t *>(p))[0];
			team[1] = (reinterpret_cast<const team_t *>(p))[1];

			p += sizeof(team[0]) * 2;
			*n_read += sizeof(team[0]) * 2;
		}

		team[0].score = ntohs( team[0].score );
		team[1].score = ntohs( team[1].score );

		return( static_cast<Monitor_View_Data *>(0) );
		break;

	case  SServer_Monitor_Log_Format::DISPINFO_MODE::SHOW_MODE:
		if ( input.size() < (*n_read) + sizeof( show ) )
		{
			return( static_cast<Monitor_View_Data *>(0) );
		}
		else
		{
			show
			  = *(reinterpret_cast<const short_showinfo_t2 *>(p));
			p += sizeof(show);
			*n_read += sizeof(show);
		}
		break;

	case  SServer_Monitor_Log_Format::DISPINFO_MODE::MSG_MODE:
		{
			msginfo_t	msg;

			if ( input.size() < (*n_read) + sizeof( msg.board ) )
			{
				return( static_cast<Monitor_View_Data *>(0) );
			}
			else
			{
				msg.board
				    = *(reinterpret_cast<const short *>(p));
				p += sizeof(short);
				*n_read += sizeof(short);
			}

			short	mes_length;
			if ( input.size() < (*n_read) + sizeof( mes_length ) )
			{
				return( static_cast<Monitor_View_Data *>(0) );
			}
			else
			{
				mes_length
				    = *(reinterpret_cast<const short *>(p));
				p += sizeof(mes_length);
				*n_read += sizeof(mes_length);
			}

			mes_length = ntohs( mes_length );

			if ( input.size() < (*n_read) + mes_length
			  || static_cast<size_t>(mes_length) + 1
			     > sizeof( msg.message ) )
			{
				return( static_cast<Monitor_View_Data *>(0) );
			}
			else
			{
				std::memcpy( msg.message , p , mes_length );
				p += mes_length;
				*n_read += mes_length;
			}
		}

		return( static_cast<Monitor_View_Data *>(0) );
		break;

	case  SServer_Monitor_Log_Format::DISPINFO_MODE::PARAM_MODE:
		{
			server_param_t	s_param_buf;

			if ( input.size() < (*n_read) + sizeof(s_param_buf) )
			{
				return( static_cast<Monitor_View_Data *>(0) );
			}
			else
			{
				s_param_buf
				  = *(reinterpret_cast<const server_param_t *>
				      (p));
				p += sizeof(server_param_t);
				*n_read += sizeof(server_param_t);
			}

			*have_s_param = true;
			*s_param = s_param_buf;
		}

		return( static_cast<Monitor_View_Data *>(0) );
		break;

	case  SServer_Monitor_Log_Format::DISPINFO_MODE::PPARAM_MODE:
		{
			player_param_t	p_param;

			if ( input.size() < (*n_read) + sizeof(p_param) )
			{
				return( static_cast<Monitor_View_Data *>(0) );
			}
			else
			{
				p_param
				  = *(reinterpret_cast<const player_param_t *>
				      (p));
				p += sizeof(player_param_t);
				*n_read += sizeof(player_param_t);
			}
		}

		return( static_cast<Monitor_View_Data *>(0) );
		break;

	case  SServer_Monitor_Log_Format::DISPINFO_MODE::PT_MODE:
		{
			player_type_t	p_type;

			if ( input.size() < (*n_read) + sizeof(p_type) )
			{
				return( static_cast<Monitor_View_Data *>(0) );
			}
			else
			{
				p_type
				  = *(reinterpret_cast<const player_type_t *>
				      (p));
				p += sizeof(player_type_t);
				*n_read += sizeof(player_type_t);
			}
		}

		return( static_cast<Monitor_View_Data *>(0) );
		break;

	default:
		std::cerr << "Unknown mode: " << mode << std::endl;
		return( static_cast<Monitor_View_Data *>(0) );
		break;
	}


	show.time = ntohs( show.time );

	for ( int  i = 0  ;  i < MAX_PLAYER * 2  ;  i ++ )
	{
		SServer_Monitor_Log_Format::player_t &	pl = show.player[i];

		pl.mode              = ntohs( pl.mode );
		pl.type              = ntohs( pl.type );
		pl.x                 = ntohl( pl.x );
		pl.y                 = ntohl( pl.y );
		pl.delta_x           = ntohl( pl.delta_x );
		pl.delta_y           = ntohl( pl.delta_y );
		pl.body_angle        = ntohl( pl.body_angle );
		pl.head_angle        = ntohl( pl.head_angle );
		pl.view_width        = ntohl( pl.view_width );
		pl.view_quality      = ntohs( pl.view_quality );
		pl.stamina           = ntohl( pl.stamina );
		pl.effort            = ntohl( pl.effort );
		pl.recovery          = ntohl( pl.recovery );
		pl.kick_count        = ntohs( pl.kick_count );
		pl.dash_count        = ntohs( pl.dash_count );
		pl.turn_count        = ntohs( pl.turn_count );
		pl.say_count         = ntohs( pl.say_count );
		pl.turn_neck_count   = ntohs( pl.turn_neck_count );
		pl.catch_count       = ntohs( pl.catch_count );
		pl.move_count        = ntohs( pl.move_count );
		pl.change_view_count = ntohs( pl.change_view_count );
	}

	show.ball.x       = ntohl( show.ball.x       );
	show.ball.y       = ntohl( show.ball.y       );
	show.ball.delta_x = ntohl( show.ball.delta_x );
	show.ball.delta_y = ntohl( show.ball.delta_y );


	//
	// dispinfo_t2 -> Monitor_View_Data
	//
	ref_count_ptr<Monitor_View_Data>	data = new Monitor_View_Data();

	data -> time_count = show.time;
	data -> play_mode  = *play_mode;

	data -> team[0].team_name = team[0].name;
	data -> team[0].score     = team[0].score;
	data -> team[1].team_name = team[1].name;
	data -> team[1].score     = team[1].score;

	data -> ball.set( static_cast<double>(show.ball.x)
			  / SHOWINFO_SCALE_2 ,
			  static_cast<double>(show.ball.y)
			  / SHOWINFO_SCALE_2 );

	for ( int  i = 0  ;
	      i < SServer_Monitor_Log_Format::MAX_PLAYER * 2  ;  i ++ )
	{
		data -> player[i] = show.player[i];
		data -> player[i].set_uniform_number( i % MAX_PLAYER + 1 );
		data -> player[i].set_side( (i < MAX_PLAYER) ?
					      S_Side_LR::Left_Side
					    : S_Side_LR::Right_Side );
	}

	return( data );
}
