#ifndef	   SSERVER_MONITOR_LOG_FORMAT_H_INCLUDED
#define	   SSERVER_MONITOR_LOG_FORMAT_H_INCLUDED

#include  <string>
#include  <iostream>
#include  "s_basic.h"
#include  "ref_count_ptr.h"

class Monitor_View_Data;

namespace SServer_Monitor_Log_Format
{
	static	const	int	MAX_PLAYER = 11;
	static	const	int	COLOR_NAME_MAX = 64;
	static	const	int	REC_VERSION_2 = 2;
	static	const	int	REC_VERSION_3 = 3;

	static	const	double	SHOWINFO_SCALE   =    16.0;
	static	const	double	SHOWINFO_SCALE_2 = 65536.0;

	enum  player_status
	{
		DISABLE        = 0x0000 ,
		STAND          = 0x0001 ,
		KICKING        = 0x0002 ,
		KICKING_FAULT  = 0x0004 ,
		GOALIE         = 0x0008 ,
		CATCHING       = 0x0010 ,
		CATCHING_FAULT = 0x0020 ,
		BALL_TO_PLAYER = 0x0040 ,
		PLAYER_TO_BALL = 0x0080 ,
		DISCARD        = 0x0100
	};

	struct  pos_t
	{
	public:
		enum { LEFT = +1 , NEUTRAL = 0 , RIGHT = -1 };

	public:
		short	enable;
		short	side;
		short	unum;
		short	angle;
		short	x;
		short	y;

	public:
		S_Side_LR	side_lr() const
		{
			switch( side )
			{
			case LEFT:
				return( S_Side_LR::Left_Side );
				break;

			case RIGHT:
				return( S_Side_LR::Right_Side );
				break;

			default:
				return( S_Side_LR::Unknown );
				break;
			}
		}
	};

	struct  team_t
	{
		char	name[16];
		short	score;
	};

	struct  showinfo_t
	{
		char	pmode;
		team_t	team[2];
		pos_t	pos[MAX_PLAYER * 2 + 1];
		short	time;
	};

	struct  ball_t
	{
		long	x;
		long	y;
		long	delta_x;
		long	delta_y;
	};

	struct  player_t
	{
		short	mode;
		short	type;
		long	x;
		long	y;
		long	delta_x;
		long	delta_y;
		long	body_angle;
		long	head_angle;
		long	view_width;
		short	view_quality;
		long	stamina;
		long	effort;
		long	recovery;
		short	kick_count;
		short	dash_count;
		short	turn_count;
		short	say_count;
		short	turn_neck_count;
		short	catch_count;
		short	move_count;
		short	change_view_count;
	};


	enum SServer_Play_Mode
		{ Null_Mode ,		Before_Kick_Off ,
		  Time_Over ,		Play_On ,
		  Kick_Off_Left ,	Kick_Off_Right ,
		  Kick_In_Left ,	Kick_In_Right ,
		  Free_Kick_Left ,	Free_Kick_Right ,
		  Corner_Kick_Left ,	Corner_Kick_Right ,
		  Goal_Kick_Left ,	Goal_Kick_Right ,
		  Goal_Left ,		Goal_Right ,
		  Drop_Ball ,
		  Offside_Left ,	Offside_Right };
	enum { SServer_Play_Mode_Nmber = 19 };


	struct  showinfo_t2
	{
		char		pmode;
		team_t		team[2];
		ball_t		ball;
		player_t	player[MAX_PLAYER * 2];
		short		time;
	};

	struct  short_showinfo_t2
	{
		ball_t		ball;
		player_t	player[MAX_PLAYER * 2];
		short		time;
	};

	struct  player_type_t
	{
		short	id;
		long	player_speed_max;
		long	stamina_inc_max;
		long	player_decay;
		long	inertia_moment;
		long	dash_power_rate;
		long	player_size;
		long	kickable_margin;
		long	kick_rand;
		long	extra_stamina;
		long	effort_max;
		long	effort_min;

		long	spare_long_1;
		long	spare_long_2;
		long	spare_long_3;
		long	spare_long_4;
		long	spare_long_5;
		long	spare_long_6;
		long	spare_long_7;
		long	spare_long_8;
		long	spare_long_9;
		long	spare_long_10;
	};

	struct  msginfo_t
	{
		short	board;
		char	message[2048];
	};

	struct  pointinfo_t
	{
		short	x;
		short	y;
		char	color[COLOR_NAME_MAX];
	};

	struct  circleinfo_t
	{
		short	x;
		short	y;
		short	r;
		char	color[COLOR_NAME_MAX];
	};

	struct  lineinfo_t
	{
		short	x1;
		short	y1;
		short	x2;
		short	y2;
		char	color[COLOR_NAME_MAX];
	};

	struct  drawinfo_t
	{
		short	mode;

		union
		{
			pointinfo_t	pinfo;
			circleinfo_t	cinfo;
			lineinfo_t	linfo;
		} object;
	};

	struct  server_param_t
	{
		long	goal_width;
		long	inertia_moment;
		long	player_size;
		long	player_decay;
		long	player_rand;
		long	player_weight;
		long	player_speed_max;
		long	player_accel_max;
		long	stamina_max;
		long	stamina_inc_max;
		long	recover_init;
		long	recover_dec_thr;
		long	recover_min;
		long	recover_dec;
		long	effort_init;
		long	effort_dec_thr;
		long	effort_min;
		long	effort_dec;
		long	effort_inc_thr;
		long	effort_inc;
		long	kick_rand;
		short	team_actuator_noise;
		long	player_rand_factor_l;
		long	player_rand_factor_r;
		long	kick_rand_factor_l;
		long	kick_rand_factor_r;
		long	ball_size;
		long	ball_decay;
		long	ball_rand;
		long	ball_weight;
		long	ball_speed_max;
		long	ball_accel_max;
		long	dash_power_rate;
		long	kick_power_rate;
		long	kickable_margin;
		long	control_radius;
		long	control_radius_width;
		long	max_power;
		long	min_power;
		long	max_moment;
		long	min_moment;
		long	max_neck_moment;
		long	min_neck_moment;
		long	max_neck_angle;
		long	min_neck_angle;
		long	visible_angle;
		long	visible_distance;
		long	wind_direction;
		long	wind_force;
		long	wind_angle;
		long	wind_rand;
		long	kickable_area;
		long	catch_area_l;
		long	catch_area_w;
		long	catch_probability;
		short	goalie_max_moves;
		long	corner_kick_margin;
		long	offside_active_area;
		short	wind_factor_none;
		short	wind_random;
		short	say_cnt_max;
		short	say_coach_message_size;
		short	clang_win_size;
		short	clang_define_win;
		short	clang_meta_win;
		short	clang_advice_win;
		short	clang_info_win;
		short	clang_mess_delay;
		short	clang_mess_per_cycle;
		short	half_time;
		short	simulator_step;
		short	send_step;
		short	recv_step;
		short	sense_body_step;
		short	lcm_st;
		short	say_message_size;
		short	hear_max;
		short	hear_inc;
		short	hear_decay;
		short	catch_ban_cycle;
		short	slow_down_factor;
		short	use_offside;
		short	kick_off_offside;
		long	offside_kick_margin;
		long	audio_cut_dist;
		long	dist_quantize_step;
		long	dist_quantize_step_land;
		long	dir_quantize_step;
		long	dist_quantize_step_left;
		long	dist_quantize_step_right;
		long	land_quantize_step_left;
		long	land_quantize_step_right;
		long	dir_quantize_step_left;
		long	dir_quantize_step_right;
		short	coach_mode;
		short	coach_with_referee_mode;
		short	old_hear;
		short	online_coach_look_step;

		long	spare_long_1;
		long	spare_long_2;
		long	spare_long_3;
		long	spare_long_4;
		long	spare_long_5;
		long	spare_long_6;
		long	spare_long_7;
		long	spare_long_8;
		long	spare_long_9;
		long	spare_long_10;

		short	start_goal_l;
		short	start_goal_r;
		short	full_state_l;
		short	full_state_r;
		short	drop_time;

		short	spare_short_6;
		short	spare_short_7;
		short	spare_short_8;
		short	spare_short_9;
		short	spare_short_10;
	};

	struct  player_param_t
	{
		short	player_types;
		short	subs_max;
		short	pt_max;
		long	player_speed_max_delta_min;
		long	player_speed_max_delta_max;
		long	stamina_inc_max_delta_factor;
		long	player_decay_delta_min;
		long	player_decay_delta_max;
		long	inertia_moment_delta_factor;
		long	dash_power_rate_delta_min;
		long	dash_power_rate_delta_max;
		long	player_size_delta_factor;
		long	kickable_margin_delta_min;
		long	kickable_margin_delta_max;
		long	kick_rand_delta_factor;
		long	extra_stamina_delta_min;
		long	extra_stamina_delta_max;
		long	effort_max_delta_factor;
		long	effort_min_delta_factor;

		long	spare_long_1;
		long	spare_long_2;
		long	spare_long_3;
		long	spare_long_4;
		long	spare_long_5;
		long	spare_long_6;
		long	spare_long_7;
		long	spare_long_8;
		long	spare_long_9;
		long	spare_long_10;

		short	spare_short_1;
		short	spare_short_2;
		short	spare_short_3;
		short	spare_short_4;
		short	spare_short_5;
		short	spare_short_6;
		short	spare_short_7;
		short	spare_short_8;
		short	spare_short_9;
		short	spare_short_10;
	};

	class  DISPINFO_MODE
	{
	public:
		enum
		{
			NO_INFO     = 0 ,
			SHOW_MODE   = 1 ,
			MSG_MODE    = 2 ,
			DRAW_MODE   = 3 ,
			BLANK_MODE  = 4 ,
			PM_MODE     = 5 ,
			TEAM_MODE   = 6 ,
			PT_MODE     = 7 ,
			PARAM_MODE  = 8 ,
			PPARAM_MODE = 9
		};
	};

	struct  dispinfo_t
	{
	public:
		short	mode;

		union
		{
			showinfo_t	show;
			msginfo_t	msg;
			drawinfo_t	draw;
		} body;

	public:
		dispinfo_t() : mode( DISPINFO_MODE::NO_INFO ){}
	};

	struct  dispinfo_t2
	{
		enum  type
		{
			NO_INFO    = 0 ,
			SHOW_MODE  = 1 ,
			MSG_MODE   = 2 ,
			DRAW_MODE  = 3 ,
			BLANK_MODE = 4
		};

	public:
		short	mode;

		union
		{
			showinfo_t2	show;
			msginfo_t	msg;
			player_type_t	ptinfo;
			server_param_t	sparams;
			player_param_t	pparams;
		} body;

	public:
		dispinfo_t2() : mode( NO_INFO ){}
	};


	extern	ref_count_ptr<const Monitor_View_Data>
			parse_dispinfo_t( std::istream & );

	extern	ref_count_ptr<const Monitor_View_Data>
			parse_dispinfo_t( const std::string & );


	extern	ref_count_ptr<const Monitor_View_Data>
		  parse_monitor_v2
		    ( const std::string & ,
		      bool *  have_s_param ,
		      SServer_Monitor_Log_Format::server_param_t *  s_param );

	extern	ref_count_ptr<const Monitor_View_Data>
			parse_log_v3( std::istream & ,
				      char *  play_mode ,
				      team_t  team[2] ,
				      bool *  have_s_param ,
				      server_param_t *  s_param );

	extern	ref_count_ptr<const Monitor_View_Data>
			parse_log_v3( const std::string & ,
				      char *  play_mode ,  team_t  team[2] ,
				      bool *  have_s_param ,
				      server_param_t *  s_param ,
				      size_t *  n_read );
};


#endif	/* SSERVER_MONITOR_LOG_FORMAT_H_INCLUDED */
