#include  "view_snapshot.h"

View_Snapshot::View_Snapshot()
	: monitor( static_cast<Monitor_View_Data *>(0) ) ,
	  client( MAX_PLAYER * 2 )
{
	for( int  i = 0  ;  i < MAX_PLAYER * 2  ;  i ++ )
	{
		client[i] = static_cast<Debug_Client_Field_Recog *>(0);
	}
}

View_Snapshot::~View_Snapshot()
{
}

// protected:
int    View_Snapshot::player_to_offset( const  S_Side_LR &  side ,
					int  player_number )
{
	if ( side == S_Side_LR::Unknown
	  || ! (1 <= player_number && player_number <= MAX_PLAYER) )
	{
		return( -1 );
	}

	if ( side == S_Side_LR::Right_Side )
	{
		return( MAX_PLAYER + player_number - 1 );
	}
	else
	{
		return( player_number - 1 );
	}
}

void   View_Snapshot::set_monitor_view_data
			( const ref_count_ptr<const Monitor_View_Data> &  m )
{
	monitor = m;
}

void   View_Snapshot::set_client_view
		( const ref_count_ptr<const Debug_Client_Field_Recog> &  c )
{
	int	offset;
	offset = View_Snapshot::player_to_offset
	  ( c -> snapshot() -> game_state.game_info.our_side ,
	    c -> snapshot() -> game_state.game_info.self_player_number );

	if ( offset != -1 )
	{
		client[ offset ] = c;
	}
}


ref_count_ptr<const Monitor_View_Data>  View_Snapshot::monitor_view_data()
	const
{
	return( monitor );
}

ref_count_ptr<const Debug_Client_Field_Recog>  View_Snapshot::client_view_data
						( const  S_Side_LR &  side ,
						  int  player_number ) const
{
	int	offset;
	offset = View_Snapshot::player_to_offset( side , player_number );

	if ( offset != -1 )
	{
		return( client[ offset ] );
	}
	else
	{
		return( ref_count_ptr<const Debug_Client_Field_Recog>( 0 ) );
	}
}
