#include  "config_window.h"
#include  "soccer_viewer.h"
#include  "s_basic.h"
#include  <cstring>
#include  <cassert>

using namespace std;

//
// Config_Check_Button
//
Config_Check_Button::Config_Check_Button( bool &  f ,
					  Soccer_Viewer &  v ,
					  const std::string &  label ,
					  gfloat  x ,  gfloat  y )
	: Gtk::CheckButton( label , x , y ) , flag( f ) , viewer( v )
{
	this -> set_active( flag );
}

Config_Check_Button::~Config_Check_Button()
{
}

void   Config_Check_Button::toggled_impl()
{
	flag = this -> get_active();

	viewer.config_changed();
}


//
// Config_Toggle_Button
//
Config_Toggle_Button::Config_Toggle_Button( bool &  f ,
					    Soccer_Viewer &  v ,
					    const std::string &  label ,
					    gfloat  x ,  gfloat  y )
	: Gtk::ToggleButton( label , x , y ) , flag( f ) , viewer( v )
{
	this -> set_active( flag );
}

Config_Toggle_Button::~Config_Toggle_Button()
{
}

void   Config_Toggle_Button::toggled_impl()
{
	flag = this -> get_active();

	viewer.config_changed();
}


//
// Config_HScale
//
Config_HScale::Config_HScale( double &  val ,  Soccer_Viewer &  v ,
			      gfloat  value ,  gfloat  lower ,  gfloat  upper ,
			      gfloat  step_increment ,
			      gfloat  page_increment ,
			      gfloat  page_size )
	: Gtk::HScale() ,
	  value( val ) , viewer( v ) ,
	  adj( value , lower , upper ,
	       step_increment , page_increment , page_size )
{
	adj.value_changed.connect
	    ( SigC::bind( SigC::slot( this ,
				      &Config_HScale::adjust_callback ) ,
			  &adj ) );

	this -> set_adjustment( adj );
}

Config_HScale::~Config_HScale()
{
	this -> set_adjustment();
}

void   Config_HScale::adjust_callback( Gtk::Adjustment *  adj )
{
	this -> value = adj -> get_value();

	viewer.config_changed();
}

void   Config_HScale::update()
{
	adj.set_value( this -> value );
}



//
// Debug_View_Checks
//
Config_Window::Debug_View_Checks::Debug_View_Checks
					( Soccer_Viewer &  v ,
					  View_Config &  c ,
					  const S_Side_LR &  side ,
					  int  player_number )
	: ball_button
		( c.debug_config( side , player_number ).debug_ball , v ,
		  "ball" ) ,
	  self_button
		( c.debug_config( side , player_number ).debug_self , v ,
		  "self" ) ,
	  players_button
		( c.debug_config( side , player_number ).debug_players , v ,
		  "players" ) ,
	  comment_button
		( c.debug_config( side , player_number ).debug_comment , v ,
		  "comment" )
{
	char	buf[ sizeof(gint) * CHAR_BIT + strlen("-") + 1
			     + std::max( strlen("left ") , strlen("right ") )];

	assert( side != S_Side_LR::Unknown );

	sprintf( buf ,
		 ((side == S_Side_LR::Left_Side) ? "left %2d" : "right %2d") ,
		 player_number );

	label.set_text( buf );
}



//
// Config_Window
//
Config_Window::Config_Window( View_Config &  config ,
			      Soccer_Viewer &  viewer ,
			      Time_Controller &  controller ,
			      Gtk::ToggleButton &  c_button )
	: Gtk::Window( GTK_WINDOW_TOPLEVEL ) ,
	  config( config ) , viewer( viewer ) , controller( controller ) ,
	  config_button( c_button ) ,
	  box() , frame( "config" ) ,
	  view_frame( "view" ) , view_vbox() , view_hbox() ,
	  view_table_1( MAX_PLAYER , 5 , true ) ,
	  view_table_2( MAX_PLAYER , 5 , true ) ,
	  monitor_view_button( config.monitor_view ,
			       viewer , "Monitor View" ) ,
	  player_view_angle_button( config.player_view_angle ,
				    viewer , "Player View Angle" ) ,
	  debug_view_checks() ,
	  offside_line_button( config.offside_line ,
			       viewer , "Offside Line" ) ,
	  chase_ball_button( "Chase Ball" ) ,
	  field_magnify_frame( "Field Magnify" ) , field_magnify_box() ,
	  auto_adjust_magnify_button( config.auto_adjust_magnify , viewer ,
				      "Auto Adjust Magnify" ) ,
	  field_magnify_scale( config.field_magnify , viewer ,
			       config.field_magnify , 1.0 , 300.0 ,
			       0.005 , 0.005 , 0.1 ) ,
	  inverse_x_button( config.inverse_x , viewer , "Inverse X" ) ,
	  inverse_y_button( config.inverse_y , viewer , "Inverse Y" ) ,
	  ball_size_frame( "Ball Size" ) , ball_size_box() ,
	  ball_size_scale( config.ball_size , viewer ,
			   config.ball_size , 0.085 , 10.0 ,
			   0.005 , 0.005 , 0.1 ) ,
	  player_size_frame( "Player Size" ) , player_size_box() ,
	  player_size_scale( config.player_size , viewer ,
			     config.player_size , 0.3 , 10.0 ,
			     0.005 , 0.005 , 0.1 ) ,
	  draw_grid_button( config.draw_grid , viewer , "Draw Glid" ) ,
	  draw_grid_scale( config.grid_width , viewer ,
			   config.grid_width , 0.1 , 20.0 ,
			   0.1 , 0.1 , 0.1 ) ,
	  draw_circle_button( config.draw_circle , viewer , "Draw Circle" ) ,
	  draw_circle_scale( config.circle_radius , viewer ,
			     config.circle_radius , 0.1 , 150.0 ,
			     3.0 , 0.1 , 0.1 ) ,
	  use_teamname_button( config.use_teamname , viewer ,
			       "Use teamname instead of left or right" ) ,
	  auto_drop_button( "Auto Drop Ball" ) ,
	  auto_kick_off_button( "Auto Kick Off" ) ,
	  auto_quit_button( "Auto Quit" ) ,
	  separator() ,
	  close_button( "Close" )
{
	//
	// This Window
	//
	this -> set_title( "Soccer Viewer Config" );
	this -> set_policy( /* allow_shrink = */ true ,
			    /* allow_grow   = */ true ,
			    /* auto_shrink  = */ true );

	this -> box.set_border_width( 10 );
	this -> frame.add( box );
	this -> frame.set_border_width( 20 );
	this -> frame.show_all();
	this -> add( frame );


	//
	// View
	//

	// Monitor View
	view_frame.add( view_vbox );
	view_vbox.pack_start( monitor_view_button );
	view_vbox.pack_start( player_view_angle_button );
	view_vbox.pack_start( view_hbox );
	view_hbox.pack_start( view_table_1 );
	view_hbox.pack_start( view_table_2 );
	view_hbox.show_all();
	view_vbox.show_all();
	view_frame.show_all();
	box.pack_start( view_frame );

	// Debug_View_Checks
	S_Side_LR	side_list[2] = { S_Side_LR::Left_Side ,
					 S_Side_LR::Right_Side };
	int		offset_list[2] = { 0 , MAX_PLAYER };
	Gtk::Table *	table_list[2] = { &(this -> view_table_1) ,
					  &(this -> view_table_2) };

	for ( int  s = 0  ;  s <= 1  ;  s ++ )
	{
		for ( int  i = 0  ;  i < MAX_PLAYER  ;  i ++ )
		{
			int	p = offset_list[s] + i;

			debug_view_checks[p]
				= new Debug_View_Checks( viewer , config ,
							 side_list[s] ,
							 i + 1 );

			table_list[s] -> attach( debug_view_checks[p]
						  -> label ,
						 0 , 1 , i , i + 1 );

			table_list[s] -> attach( debug_view_checks[p]
						  -> ball_button ,
						 1 , 2 , i , i + 1 );

			table_list[s] -> attach( debug_view_checks[p]
						  -> self_button ,
						 2 , 3 , i , i + 1 );

			table_list[s] -> attach( debug_view_checks[p]
						  -> players_button ,
						 3 , 4 , i , i + 1 );

			table_list[s] -> attach( debug_view_checks[p]
						  -> comment_button ,
						 4 , 5 , i , i + 1 );
		}
	}


	//
	// Offside_Line Button
	//
	box.pack_start( offside_line_button );


	//
	// Ball_Size Scale
	//
	box.pack_start( ball_size_frame );
	ball_size_frame.add( ball_size_box );
	ball_size_box.set_border_width( 10 );
	ball_size_box.add( ball_size_scale );
	ball_size_scale.set_update_policy( GTK_UPDATE_CONTINUOUS );
	ball_size_scale.set_digits( 3 );
	ball_size_scale.set_value_pos( GTK_POS_TOP );
	ball_size_scale.set_draw_value( 50 );
	ball_size_box.show_all();
	ball_size_frame.show_all();


	//
	// Player_Size Scale
	//
	box.pack_start( player_size_frame );
	player_size_frame.add( player_size_box );
	player_size_box.set_border_width( 10 );
	player_size_box.add( player_size_scale );
	player_size_scale.set_update_policy( GTK_UPDATE_CONTINUOUS );
	player_size_scale.set_digits( 3 );
	player_size_scale.set_value_pos( GTK_POS_TOP );
	player_size_scale.set_draw_value( 100 );
	player_size_box.show_all();
	player_size_frame.show_all();


	// Draw_Grid Button
	box.pack_start( draw_grid_button );
	box.pack_start( draw_grid_scale );

	// Draw_Grid Button
	box.pack_start( draw_circle_button );
	box.pack_start( draw_circle_scale );


#if 0
	// Use_Teamname Button
	box.pack_start( use_teamname_button );
#endif


	//
	// Chase Ball
	//
	box.pack_start( chase_ball_button );
	chase_ball_button.toggled.connect
	  ( SigC::slot( this , &Config_Window::chase_ball_button_toggled ) );


	//
	// Field_Magnify
	//
	box.pack_start( field_magnify_frame );
	field_magnify_frame.add( field_magnify_box );
	field_magnify_box.add( auto_adjust_magnify_button );
	field_magnify_box.add( field_magnify_scale );
	field_magnify_box.set_border_width( 10 );
	field_magnify_scale.set_update_policy( GTK_UPDATE_CONTINUOUS );
	field_magnify_scale.set_digits( 3 );
	field_magnify_scale.set_value_pos( GTK_POS_TOP );
	field_magnify_scale.set_draw_value( 100 );
	field_magnify_box.show_all();
	field_magnify_frame.show_all();


	//
	// Inverse_X
	//
	box.pack_start( inverse_x_button );

	//
	// Inverse_Y
	//
	box.pack_start( inverse_y_button );


	//
	// Auto_Drop
	//
	box.pack_start( auto_drop_button );
	auto_drop_button.toggled.connect
	 ( SigC::slot( this , &Config_Window::auto_drop_button_toggled ) );
	auto_drop_button.set_active( config.auto_drop );

	//
	// Auto_Kick_Off
	//
	box.pack_start( auto_kick_off_button );
	auto_kick_off_button.toggled.connect
	 ( SigC::slot( this , &Config_Window::auto_kick_off_button_toggled ) );
	auto_kick_off_button.set_active( config.auto_kick_off );

	//
	// Auto_Quit
	//
	box.pack_start( auto_quit_button );
	auto_quit_button.toggled.connect
	 ( SigC::slot( this , &Config_Window::auto_quit_button_toggled ) );
	auto_quit_button.set_active( config.auto_quit );


	//
	// separator
	//
	box.pack_start( separator ,
			false /*expand*/ , true /*fill*/ , 5 /*padding*/ );


	//
	// close button
	//
	box.pack_start( close_button , false , false );
	close_button.clicked.connect(
		SigC::slot( this , &Config_Window::close_button_clicked ) );
	close_button.set_flags( GTK_CAN_DEFAULT );
	close_button.grab_default();
	close_button.set_border_width( 10 );


	//
	// box
	//
	box.show_all();
}

Config_Window::~Config_Window()
{
}

void   Config_Window::chase_ball_button_toggled()
{
	if ( chase_ball_button.get_active() )
	{
		this -> config.view_point.type = View_Config::View_Point::Ball;
	}
	else
	{
		this -> config.view_point.type
				= View_Config::View_Point::Point;
		this -> config.view_point.coordinate.set( 0.0 , 0.0 );
	}

	viewer.config_changed();
}

void   Config_Window::auto_drop_button_toggled()
{
	config.auto_drop = auto_drop_button.get_active();
	controller.set_auto_drop( config.auto_drop );
}

void   Config_Window::auto_kick_off_button_toggled()
{
	config.auto_kick_off = auto_kick_off_button.get_active();
	controller.set_auto_kick_off( config.auto_kick_off );
}

void   Config_Window::auto_quit_button_toggled()
{
	config.auto_quit = auto_quit_button.get_active();
	controller.set_auto_quit( config.auto_quit );
}

void   Config_Window::close_button_clicked()
{
	this -> hide();
	this -> config_button.set_active( false );
}

void   Config_Window::config_changed()
{
	// XXX
	field_magnify_scale.update();
}

void   Config_Window::field_magnify_changed()
{
	field_magnify_scale.update();
}
