#ifndef	   CONFIG_WINDOW_H_INCLUDED
#define	   CONFIG_WINDOW_H_INCLUDED

#include  <gtk--.h>
#include  "view_config.h"
#include  "time_controller.h"
#include  <string>

class  Soccer_Viewer;

class  Config_Check_Button : public Gtk::CheckButton
{
protected:
	bool &			flag;
	Soccer_Viewer &		viewer;

protected:
	virtual	void	toggled_impl();

public:
	Config_Check_Button( bool &  f , Soccer_Viewer &  v ,
			     const std::string &  label ,
			     gfloat  x = 0.5 ,  gfloat  y = 0.5 );

	virtual	~Config_Check_Button();
};

class  Config_Toggle_Button : public Gtk::ToggleButton
{
protected:
	bool &			flag;
	Soccer_Viewer &		viewer;

protected:
	virtual	void	toggled_impl();

public:
	Config_Toggle_Button( bool &  f , Soccer_Viewer &  v ,
			      const std::string &  label ,
			      gfloat  x = 0.5 ,  gfloat  y = 0.5 );

	virtual	~Config_Toggle_Button();
};

class  Config_HScale : public Gtk::HScale
{
protected:
	double &		value;
	Soccer_Viewer &		viewer;
	Gtk::Adjustment		adj;

protected:
	virtual	void	adjust_callback( Gtk::Adjustment *  adj );

public:
	Config_HScale( double &  val ,  Soccer_Viewer &  v ,
		       gfloat  value ,  gfloat  lower ,  gfloat  upper ,
		       gfloat  step_increment = 1 ,
		       gfloat  page_increment = 10 ,
		       gfloat  page_size = 0 );

	virtual	~Config_HScale();

	virtual	void	update();
};


class  Config_Window : public Gtk::Window
{
protected:
	struct  Debug_View_Checks
	{
		Gtk::Label		label;
		Config_Toggle_Button	ball_button;
		Config_Toggle_Button	self_button;
		Config_Toggle_Button	players_button;
		Config_Toggle_Button	comment_button;

	public:
		Debug_View_Checks( Soccer_Viewer &  v ,
				   View_Config &  c ,
				   const S_Side_LR &  side ,
				   int  player_number );
	};

protected:
	View_Config &		config;
	Soccer_Viewer &		viewer;
	Time_Controller &	controller;
	Gtk::ToggleButton &	config_button;

	Gtk::VBox		box;
	Gtk::Frame		frame;

protected:
	//
	// What to Display
	//
	Gtk::Frame		view_frame;
	Gtk::VBox		view_vbox;
	Gtk::HBox		view_hbox;
	Gtk::Table		view_table_1;
	Gtk::Table		view_table_2;
	Config_Check_Button	monitor_view_button;
	Config_Check_Button	player_view_angle_button;

	ref_count_ptr<Debug_View_Checks>  debug_view_checks[MAX_PLAYER * 2];

	Config_Check_Button	offside_line_button;


	//
	// How to Display
	//
	Gtk::CheckButton	chase_ball_button;

	Gtk::Frame		field_magnify_frame;
	Gtk::VBox		field_magnify_box;
	Config_Check_Button	auto_adjust_magnify_button;
	Config_HScale		field_magnify_scale;

	Config_Check_Button	inverse_x_button;
	Config_Check_Button	inverse_y_button;

	Gtk::Frame		ball_size_frame;
	Gtk::VBox		ball_size_box;
	Config_HScale		ball_size_scale;

	Gtk::Frame		player_size_frame;
	Gtk::VBox		player_size_box;
	Config_HScale		player_size_scale;

	Config_Check_Button	draw_grid_button;
	Config_HScale		draw_grid_scale;

	Config_Check_Button	draw_circle_button;
	Config_HScale		draw_circle_scale;

	Config_Check_Button	use_teamname_button;


	//
	// Connection Operation
	//
	Gtk::CheckButton	auto_drop_button;
	Gtk::CheckButton	auto_kick_off_button;
	Gtk::CheckButton	auto_quit_button;


	//
	// Operation for This Window
	//
	Gtk::HSeparator		separator;

	Gtk::Button		close_button;


public:
		 Config_Window( View_Config & ,
				Soccer_Viewer & ,
				Time_Controller & ,
				Gtk::ToggleButton & );

	virtual	~Config_Window();

	virtual	void	chase_ball_button_toggled();
	virtual	void	auto_drop_button_toggled();
	virtual	void	auto_kick_off_button_toggled();
	virtual	void	auto_quit_button_toggled();
	virtual	void	close_button_clicked();

	virtual	void	config_changed();
	virtual	void	field_magnify_changed();
};


#endif	/* CONFIG_WINDOW_H_INCLUDED */
