#include  "field_view.h"
#include  "field_recog_interface.h"

//
// Canvas
//

//
// event handler
//
Field_Canvas_Canvas_Event_Handler::Field_Canvas_Canvas_Event_Handler
						( Field_View &  field_view )
	: field_view( field_view )
{
}

Field_Canvas_Canvas_Event_Handler::~Field_Canvas_Canvas_Event_Handler()
{
}

void   Field_Canvas_Canvas_Event_Handler::configured()
{
	this -> field_view.canvas_configured();
}


//
// monitor connection
//
Viewer_Field_Canvas_Monitor_Connection::Viewer_Field_Canvas_Monitor_Connection
					    ( Time_Controller &  controller )
	: controller( controller )
{
}

Viewer_Field_Canvas_Monitor_Connection
	::~Viewer_Field_Canvas_Monitor_Connection()
{
}

int    Viewer_Field_Canvas_Monitor_Connection::send_foul
				( double  x ,  double  y ,  S_Side_LR  side )
{
	return( this -> controller.send_foul( x , y , side , true ) );
}



//
// Field_View
//
Field_View::Field_View( Time_Controller &  controller ,
			View_Config &  config ,
			View_Controll_Panel &  panel ,
			bool  have_left_team_config ,
			const std::string &  left_team_config_file_name ,
			bool  have_right_team_config ,
			const std::string &  right_team_config_file_name )
	: controller( controller ) , config( config ) , panel( panel ) ,
	  canvas_event_handler( *this ) ,
	  canvas_monitor_connection( controller ) ,
	  canvas( canvas_event_handler , canvas_monitor_connection ,
		  config , controller.sserver_param() ,
		  0.0 , 0.0 , config.field_magnify ) ,
	  view_point_type( config.view_point.type ) ,
	  canvas_magnify( config.field_magnify ) ,
	  view_point_coordinate( config.view_point.coordinate ) ,
	  view_point_player( config.view_point.player ) ,
	  inverse_x( config.inverse_x ) , inverse_y( config.inverse_y ) ,
	  auto_adjust_magnify( config.auto_adjust_magnify ) ,
	  old_ball_coordinate( 0.0 , 0.0 )
{
	//
	// Team Config
	//
	this -> setup_team_config( S_Side_LR::Left_Side ,
				   have_left_team_config ,
				   left_team_config_file_name );
	this -> setup_team_config( S_Side_LR::Right_Side ,
				   have_right_team_config ,
				   right_team_config_file_name );


	//
	// Field
	//
	canvas.show();
	this -> pack_start( canvas );


	//
	// this
	//
	this -> set_spacing( 5 );
	this -> show();
}

Field_View::~Field_View()
{
}

void   Field_View::canvas_configured()
{
	if ( config.auto_adjust_magnify )
	{
		config.field_magnify
		= std::min( static_cast<gdouble>( canvas.width()  )
			    / Field_Canvas::DEFAULT_WIDTH ,
			    static_cast<gdouble>( canvas.height() )
			    / Field_Canvas::DEFAULT_HEIGHT )
			* Field_Canvas::DEFAULT_MAGNIFY;
	}

	this -> display();
}

void   Field_View::view_set()
{
	if ( config.view_point.type == View_Config::View_Point::Ball
	  || config.view_point.type == View_Config::View_Point::Player
	  || canvas_magnify != config.field_magnify
	  || view_point_type != config.view_point.type
	  || view_point_coordinate != config.view_point.coordinate
	  || view_point_player != config.view_point.player
	  || inverse_x != config.inverse_x
	  || inverse_y != config.inverse_y
	  || auto_adjust_magnify != config.auto_adjust_magnify )
	{
		canvas_magnify = config.field_magnify;
		view_point_type = config.view_point.type;
		view_point_coordinate = config.view_point.coordinate;
		view_point_player = config.view_point.player;
		inverse_x = config.inverse_x;
		inverse_y = config.inverse_y;
		auto_adjust_magnify = config.auto_adjust_magnify;

		switch( view_point_type )
		{
		case View_Config::View_Point::Point:
			canvas.view_change( config.view_point.coordinate.x() ,
					    config.view_point.coordinate.y() ,
					    config.field_magnify ,
					    config.inverse_x ,
					    config.inverse_y );
			break;

		case View_Config::View_Point::Ball:
			if ( controller.monitor_view_data() )
			{
				canvas.view_change
				( controller.monitor_view_data() -> ball.x() ,
				  controller.monitor_view_data() -> ball.y() ,
				  config.field_magnify ,
				  config.inverse_x ,
				  config.inverse_y );
			}
			break;

		case View_Config::View_Point::Player:
			// XXX
			break;
		}

		this -> panel.config_changed();
	}
}


void   Field_View::display()
{
	//
	// View Change
	//
	this -> view_set();

	//
	// Clear Field
	//
	canvas.clear_field();

	// if no snapshot, return with no drawing.
	if ( ! controller.snapshot()
	  && ! (controller.auto_quit_mode() && controller.game_over()) )
	{
		//
		// Update Field
		//
		canvas.update_field();

		return;
	}


	//
	// Draw Grid
	//
	if ( config.draw_grid )
	{
		canvas.draw_grid( config.grid_width );
	}


	//
	// Monitor View
	//
	if ( config.monitor_view && controller.monitor_view_data() )
	{
		canvas.draw_monitor_view_data
			( *(controller.monitor_view_data()) ,
			  config.player_view_angle ,
			  team_config ,
			  config.player_size , config.ball_size ,
			  config.use_teamname );
	}


	//
	// Draw Circle
	//
	if ( config.draw_circle )
	{
		canvas.draw_circle( *(controller.monitor_view_data()) ,
				    config.circle_radius );
	}


	//
	// Auto Drop: Count Down
	//
	if ( controller.auto_drop_mode()
	     && controller.live_mode()
	     && controller.monitor_view_data()
	     && controller.monitor_view_data() -> play_mode
		  != Monitor_View_Data::Monitor_Play_Mode::Before_Kick_Off )
	{
		if ( controller.auto_drop_rest_second()
		     <= Active_Repository::AUTO_DROP_COUNT )
		{
			canvas.draw_auto_drop_count_down
				( controller.auto_drop_rest_second() );
		}
	}


	//
	// Auto Kick Off: Count Down
	//
	if ( controller.auto_kick_off_mode()
	     && controller.live_mode()
	     && controller.monitor_view_data()
	     && controller.monitor_view_data() -> play_mode
		  == Monitor_View_Data::Monitor_Play_Mode::Before_Kick_Off )
	{
		canvas.draw_auto_kick_off_count_down
			( controller.auto_kick_off_rest_second() );
	}


	//
	// Auto Quit: Count Down
	//
	if ( controller.auto_quit_mode()
	  && controller.game_over() )
	{
		canvas.draw_auto_quit_count_down
			( controller.auto_quit_rest_second() );
	}


	//
	// Offside Line
	//
	if ( config.offside_line && controller.monitor_view_data() )
	{
		canvas.draw_offside_line( *(controller.monitor_view_data()) );
	}


	//
	// Client Debug View
	//
	S_Side_LR	side_list[2];
	side_list[0] = S_Side_LR::Left_Side;
	side_list[1] = S_Side_LR::Right_Side;

	for ( int  s = 0  ;  s < 2  ;  s ++ )
	{
		for ( int  p = 1  ;  p <= MAX_PLAYER  ;  p ++ )
		{
			if ( ! controller.client_view_data( side_list[s] , p )
			  || ! (controller.client_view_data( side_list[s] , p )
				 -> snapshot() ) )
			{
				continue;
			}

			ref_count_ptr<const Debug_Client_Field_Recog>	recog
			     = controller.client_view_data( side_list[s] , p );

			Field_Recog_Interface	interface
						    ( recog -> snapshot() );

			const View_Config::Debug_View_Config &	c
				= config.debug_config( side_list[s] , p );

			// Debug Other Players
			if ( c.debug_players )
			{
				// Debug Teammate Player
				for ( int  i = 1  ;  i <= MAX_PLAYER  ;  i ++ )
				{
					if ( i == interface.self()
							    .player_number() )
					{
						continue;
					}

					if ( interface.teammate( i )
						    .coordinate().have_info() )
					{
						canvas.draw_player
						 ( interface.teammate( i ) ,
						   interface.our_team()
								.side_lr() ,
						   Soccer_Command
							   ::No_Command() ,
						   config.player_size ,
						   (c.debug_comment ?
						    recog
						      -> teammate_comment(i)
						    : static_cast<const char *>
						      (0) ) ,
						   true ,
						   false ,
						   static_cast<const char *>
						     (0) ,
						   true );
					}
				}

				// Debug Opponent Player
				for ( int  i = 1  ;  i <= MAX_PLAYER  ;  i ++ )
				{
					if ( interface.opponent( i )
						    .coordinate().have_info() )
					{
						canvas.draw_player
						 ( interface.opponent( i ) ,
						   interface.our_team()
								.side_lr() ,
						   Soccer_Command
							   ::No_Command() ,
						   config.player_size ,
						   (c.debug_comment ?
						    recog
						      -> opponent_comment(i)
						    : static_cast<const char *>
						      (0) ) ,
						   true ,
						   false ,
						   static_cast<const char *>
						     (0) ,
						   true );
					}
				}

				// Debug Unknown Player
				for ( size_t  i = 0  ;
				      i < interface.n_unknown_player()  ;
				      i ++ )
				{
					if ( interface.unknown_player( i )
						    .coordinate().have_info() )
					{
						canvas.draw_player
						 ( interface
						     .unknown_player( i ) ,
						   interface.our_team()
								.side_lr() ,
						   Soccer_Command
							   ::No_Command() ,
						   config.player_size ,
						   static_cast<const char *>
									  (0) ,
						   true ,
						   false ,
						   static_cast<const char *>
						     (0) ,
						   true );
					}
				}
			}

			// XXX
			// Debug Target Teammate
			if ( recog -> get_target_teammate() != -1 )
			{
				canvas.draw_player
					( interface.teammate
					   ( recog -> get_target_teammate() ) ,
					  interface.our_team().side_lr() ,
					  Soccer_Command::No_Command() ,
					  config.player_size ,
					  static_cast<const char *>(0) ,
					  true ,
					  false ,
					  static_cast<const char *>(0) ,
					  true );
			}

			// XXX
			// Debug Target Point
			if ( recog -> have_target_point() )
			{
				canvas.draw_target_point
					( recog -> get_target_point() ,
					  interface.our_team().side_lr() );
			}

			// XXX
			// Debug Self
			if ( c.debug_self
			  && interface.self().coordinate().have_info() )
			{
				canvas.draw_player
					( interface.self() ,
					  interface.our_team().side_lr() ,
					  Soccer_Command::No_Command() ,
					  config.player_size ,
					  static_cast<const char *>(0) ,
					  true ,
					  true ,
					  recog -> get_message().c_str() ,
					  true );
			}

			// Debug Ball
			if ( c.debug_ball
			  && interface.ball().coordinate().have_info() )
			{
				canvas.draw_ball
					( interface.ball() ,
					  interface.our_team().side_lr() ,
					  config.ball_size ,
					  interface.play_mode() ,
					  interface.ball().velocity()
								.have_info() ,
					  (c.debug_comment ?
					    recog -> ball_comment()
					   : static_cast<const char *>(0)) ,
					  true );
			}
		}
	}


	//
	// Update Field
	//
	canvas.update_field();
}


#include  <fstream>
#include  "ref_count_ptr.h"
void   Field_View::setup_team_config( S_Side_LR  side ,
				      bool  have_team_config ,
				      const std::string &  file_name )
{
	if ( ! have_team_config )
	{
		return;
	}

	std::istream *			input;
	ref_count_ptr<std::istream>	input_file;

	if ( file_name == "-" )
	{
		input = &std::cin;
	}
	else
	{
		input_file = new std::ifstream( file_name.c_str() ,
						std::ios::in );
		input = &(*input_file);
	}


	if ( side == S_Side_LR::Left_Side )
	{
		team_config[0].read_config( *input );
	}
	else if ( side == S_Side_LR::Right_Side )
	{
		team_config[1].read_config( *input );
	}
}
