#ifndef	   FIELD_VIEW_H_INCLUDED
#define	   FIELD_VIEW_H_INCLUDED

#include  <gtk--.h>
#include  "viewer_field_canvas.h"
#include  "time_controller.h"
#include  "view_config.h"
#include  "view_controll_panel.h"
#include  "team_config.h"

class  Field_View;


class  Field_Canvas_Canvas_Event_Handler
	: public Field_Canvas::Canvas_Event_Handler
{
protected:
	Field_View &	field_view;

public:
		 Field_Canvas_Canvas_Event_Handler( Field_View &  field_view );
	virtual	~Field_Canvas_Canvas_Event_Handler();
	virtual	void	configured();
};


class  Viewer_Field_Canvas_Monitor_Connection
	: public Viewer_Field_Canvas::Monitor_Connection
{
protected:
	Time_Controller &	controller;

public:
	Viewer_Field_Canvas_Monitor_Connection
				( Time_Controller &  controller );
	virtual	~Viewer_Field_Canvas_Monitor_Connection();
	virtual	int	send_foul( double  x ,  double  y ,  S_Side_LR  side );
};


class  Field_View : public Gtk::VBox
{
protected:
	Time_Controller &		controller;
	View_Config &			config;
	Team_Config			team_config[2];

	View_Controll_Panel &		panel;

	Field_Canvas_Canvas_Event_Handler	canvas_event_handler;
	Viewer_Field_Canvas_Monitor_Connection	canvas_monitor_connection;
	Viewer_Field_Canvas			canvas;

	View_Config::View_Point::Type	view_point_type;
	gdouble				canvas_magnify;
	D2_Vector			view_point_coordinate;
	SObject_Player_Identifier	view_point_player;

	bool				inverse_x;
	bool				inverse_y;

	bool				auto_adjust_magnify;

	D2_Vector			old_ball_coordinate;

protected:
	void	setup_team_config( S_Side_LR ,
				   bool  have_team_config ,
				   const std::string &  file_name );

public:
		 Field_View
		   ( Time_Controller &  controller ,
		     View_Config &  config ,
		     View_Controll_Panel &  panel ,
		     bool  have_left_team_config ,
		     const std::string &  left_team_config_file_name ,
		     bool  have_right_team_config ,
		     const std::string &  right_team_config_file_name );

	virtual	~Field_View();

	virtual	void	display();

	virtual	void	view_set();

	virtual	void	canvas_configured();
};


#endif	/* FIELD_VIEW_H_INCLUDED */
