//
// Display part is based on soccermonitor provided by Itsuki Noda.
//

#include  "soccer_viewer.h"
#include  "active_repository.h"
#include  "gtk_updator.h"
#include  "soccer_viewer_option_analyser.h"
#include  "debugstream.h"
#include  <gtk--.h>

int    main( int  argc ,  char *  argv[] )
{
	Debug_Stream::dbg.inhibit();


	Gtk::Main			gtk( &argc , &argv );

	Soccer_Viewer_Option_Analyser	opt;

	if ( ! opt.analyse( argc , argv ) )
	{
		opt.usage();

		return( 1 );
	}
	else if ( opt.help() )
	{
		opt.usage();

		return( 0 );
	}



	Active_Repository	repository( new Gtk_Updator() ,
					    opt.server_hostname() ,
					    opt.server_port_number() ,
					    opt.debug_port_number() ,
					    opt.server_protocol_version() ,
					    opt.log_file_source() ,
					    opt.log_file_name() ,
					    opt.receive_debug() ,
					    opt.auto_drop() ,
					    opt.auto_kick_off() ,
					    opt.auto_quit() ,
					    opt.server_process_id() );

	Soccer_Viewer		viewer( repository ,
					opt.default_window_size() ,
					opt.log_file_source() ,
					opt.draw_player_view_angle() ,
					opt.have_left_team_config() ,
					opt.left_team_config_file_name() ,
					opt.have_right_team_config() ,
					opt.right_team_config_file_name() );

	gtk.run();

	return( 0 );
}
