#include "soccer_viewer.h"

Game_Info_Mode_Line_Model::Game_Info_Mode_Line_Model
					( const Time_Controller &  t ,
					  const View_Config &  c )
	: time_controller( t ) , config( c )
{
}

Game_Info_Mode_Line_Model::~Game_Info_Mode_Line_Model()
{
}

bool   Game_Info_Mode_Line_Model::valid() const
{
	return( time_controller.monitor_view_data() );
}

std::string  Game_Info_Mode_Line_Model::left_teamname() const
{
	return( time_controller.monitor_view_data() -> team[0].team_name );
}

std::string  Game_Info_Mode_Line_Model::right_teamname() const
{
	return( time_controller.monitor_view_data() -> team[1].team_name );
}

gint  Game_Info_Mode_Line_Model::left_score() const
{
	return( time_controller.monitor_view_data() -> team[0].score );
}

gint  Game_Info_Mode_Line_Model::right_score() const
{
	return( time_controller.monitor_view_data() -> team[1].score );
}

std::string  Game_Info_Mode_Line_Model::play_mode() const
{
	if ( config.use_teamname )
	{
		return( time_controller.monitor_view_data()
			-> play_mode.play_mode_str
					( this -> left_teamname() ,
					  this -> right_teamname() ) );
	}
	else
	{
		return( time_controller.monitor_view_data()
			-> play_mode.play_mode_str() );
	}
}

gboolean  Game_Info_Mode_Line_Model::inverse_x() const
{
	return( config.inverse_x );
}

glong  Game_Info_Mode_Line_Model::step() const
{
	return( time_controller.snapshot_time() );
}



//
// Soccer_Viewer_Window
//
gint   Soccer_Viewer_Window::delete_event_impl( GdkEventAny * )
{
	Gtk::Main::quit();

	return( false );
}

Soccer_Viewer_Window::~Soccer_Viewer_Window()
{
}


//
// Soccer_Viewer
//
Soccer_Viewer::Soccer_Viewer
		( Active_Repository &  rep ,
		  const std::pair<int, int> &  window_size ,
		  bool  log_file_source ,
		  bool  draw_player_view_angle ,
		  bool  have_left_team_config ,
		  const std::string &  left_team_config_file_name ,
		  bool  have_right_team_config ,
		  const std::string &  right_team_config_file_name )
	: config( rep.auto_drop_mode() ,
		  rep.auto_kick_off_mode() ,
		  rep.auto_quit_mode() ,
		  draw_player_view_angle ) ,
	  repository( rep ) ,
	  repository_updater( rep ) ,
	  time_controller( rep , *this , log_file_source ) ,
	  window() ,
	  controll_panel( time_controller , config , *this ) ,
	  field( time_controller , config , controll_panel ,
		 have_left_team_config , left_team_config_file_name ,
		 have_right_team_config , right_team_config_file_name ) ,
	  mode_line_model( time_controller , config ) ,
	  mode_line( mode_line_model )
{
	// mode line
	vbox.pack_start( mode_line , false );

	// field
	vbox.pack_start( field );

	// controll panel
	vbox.pack_start( controll_panel , false );

	// vbox
	vbox.set_spacing( 3 );
	vbox.show_all();
	

	// window
	window.add( vbox );
	window.set_title( "Soccer Viewer" );
	window.set_border_width( 4 );
	window.set_policy( /* allow_shrink = */ true ,
			   /* allow_grow   = */ true ,
			   /* auto_shrink  = */ true );
	if ( window_size.first > 0  &&  window_size.second > 0 )
	{
		window.set_default_size( window_size.first ,
					 window_size.second );
	}

	window.show();
}

Soccer_Viewer::~Soccer_Viewer()
{
}

void   Soccer_Viewer::display()
{
	if ( ! window.is_realized() )
	{
		return;
	}

	mode_line     .display();
	field         .canvas_configured();
	controll_panel.display();
}

void   Soccer_Viewer::config_changed()
{
	this -> display();
}
