#ifndef	   SOCCER_VIEWER_H_INCLUDED
#define	   SOCCER_VIEWER_H_INCLUDED

// Author:		H. Shimora
// Last-Modified:	May 22 2000
// Created:		May 22 2000
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  May 22 2000    base version.
//
//

#include  "view_config.h"
#include  "active_repository.h"
#include  "active_repository_updater.h"
#include  "view_controll_panel.h"
#include  "field_view.h"
#include  "game_info_mode_line.h"
#include  "view_config.h"
#include  <gtk--.h>

class  Soccer_Viewer_Window : public Gtk::Window
{
public:
	virtual		~Soccer_Viewer_Window();
	virtual	gint	delete_event_impl( GdkEventAny * );
};


class  Game_Info_Mode_Line_Model : public Game_Info_Mode_Line::Model
{
private:
	const Time_Controller &		time_controller;
	const View_Config &		config;

public:
		 Game_Info_Mode_Line_Model( const Time_Controller & ,
					    const View_Config & );
	virtual	~Game_Info_Mode_Line_Model();
	virtual	bool		valid() const;
	virtual	std::string	left_teamname() const;
	virtual	std::string	right_teamname() const;
	virtual	gint		left_score() const;
	virtual	gint		right_score() const;
	virtual	std::string	play_mode() const;
	virtual	gboolean	inverse_x() const;
	virtual	glong		step() const;
};


class  Soccer_Viewer : public Abstract_Soccer_Viewer
{
protected:
	View_Config			config;

	Active_Repository &		repository;
	Active_Repository_Updater	repository_updater;

	Time_Controller			time_controller;

	Soccer_Viewer_Window		window;
	Gtk::VBox			vbox;

	View_Controll_Panel		controll_panel;
	Field_View			field;
	Game_Info_Mode_Line_Model	mode_line_model;
	Game_Info_Mode_Line		mode_line;

public:
		 Soccer_Viewer
			 ( Active_Repository &  rep ,
			   const std::pair<int, int> &  window_size ,
			   bool  log_file_source ,
			   bool  draw_player_view_angle ,
			   bool  have_left_team_config ,
			   const std::string &  left_team_config_file_name ,
			   bool  have_right_team_config ,
			   const std::string &  right_team_config_file_name );

	virtual	~Soccer_Viewer();

	virtual	void	display();
	virtual	void	config_changed();
};


#endif	/* SOCCER_VIEWER_H_INCLUDED */
