#ifndef	   SOCCER_VIEWER_OPTION_ANALYSER_H_INCLUDED
#define	   SOCCER_VIEWER_OPTION_ANALYSER_H_INCLUDED

#include  <string>
#include  <iostream>
#include  <algorithm>
#include  <sys/types.h>
#include  "option_analyser.h"
#include  "ip_address.h"
#include  "sserver_param.h"

class  Soccer_Viewer_Option_Analyser : public Option_Analyser
{
protected:
	bool		help_flag;

	std::string	server_host;
	int		server_port;
	int		debug_port;

	int		serv_protocol_version;
	bool		log_file_source_flag;
	std::string	log_file_name_str;

	bool		draw_player_view_angle_flag;

	bool		left_team_conf_flag;
	std::string	left_team_conf_file_name;
	bool		right_team_conf_flag;
	std::string	right_team_conf_file_name;

	bool		receive_debug_flag;

	bool		auto_drop_flag;
	bool		auto_kick_off_flag;
	bool		auto_quit_flag;

	int		server_pid;

	std::pair<int, int>	window_size;

public:
		 Soccer_Viewer_Option_Analyser
		   ( const std::string &  default_server_host_name
					 = "localhost" ,
		     ip_port_number_t  default_server_port_number
					 = SServer_Param::DEFAULT_PORT ,
		     ip_port_number_t  default_debug_port_number
					 = 0 /* server_port
						 + Debug_Server_Connection
						    ::DEFAULT_PORT_OFFSET */ );
	virtual	~Soccer_Viewer_Option_Analyser();

	virtual	void	usage( std::ostream &  ostr = std::cerr ) const;
	virtual	bool	check() const;

	virtual	bool			help() const;

	virtual	std::string		server_hostname() const;
	virtual	ip_port_number_t	server_port_number() const;
	virtual	ip_port_number_t	debug_port_number() const;

	virtual	int			server_protocol_version() const;
	virtual	bool			log_file_source() const;
	virtual	std::string		log_file_name() const;

	virtual	bool			draw_player_view_angle() const;

	virtual	bool			have_left_team_config() const;
	virtual	std::string		left_team_config_file_name() const;
	virtual	bool			have_right_team_config() const;
	virtual	std::string		right_team_config_file_name() const;

	virtual	bool			receive_debug() const;

	virtual	bool			auto_drop() const;
	virtual	bool			auto_kick_off() const;
	virtual	bool			auto_quit() const;

	virtual	pid_t			server_process_id() const;

	virtual	std::pair<int, int>	default_window_size() const;
};


#endif	/* SOCCER_VIEWER_OPTION_ANALYSER_H_INCLUDED */
