#include  "step_controller.h"
#include  <cstdlib>

//
// Step_Controller
//
Step_Controller::Step_Controller( Time_Controller &  time_controller )
	: Gtk::HBox( true ) ,
	  time_controller( time_controller ) ,
	  backward_highlight_button( "|<" ) ,
	  backward_very_fast_button( "<<<<" ) ,
	  backward_fast_button( "<<<" ) ,
	  backward_button( "<<" ) ,
	  backward_step_button( "<" ) ,
	  stop_button( "||" ) ,
	  forward_step_button( ">" ) ,
	  forward_button( ">>" ) ,
	  forward_fast_button( ">>>" ) ,
	  forward_very_fast_button( ">>>>" ) ,
	  forward_highlight_button( ">|" ) ,
	  live_log_button( "live-log" )
{
	backward_highlight_button.clicked.connect
		( SigC::slot( this , &Step_Controller::backward_highlight ) );

	backward_very_fast_button.clicked.connect
		( SigC::slot( this , &Step_Controller::backward_very_fast ) );

	backward_fast_button.clicked.connect
		( SigC::slot( this , &Step_Controller::backward_fast ) );

	backward_button.clicked.connect
		( SigC::slot( this , &Step_Controller::backward ) );

	backward_step_button.clicked.connect
		( SigC::slot( this , &Step_Controller::backward_step ) );

	stop_button.clicked.connect
		( SigC::slot( this , &Step_Controller::stop ) );

	forward_step_button.clicked.connect
		( SigC::slot( this , &Step_Controller::forward_step ) );

	forward_button.clicked.connect
		( SigC::slot( this , &Step_Controller::forward ) );

	forward_fast_button.clicked.connect
		( SigC::slot( this , &Step_Controller::forward_fast ) );

	forward_very_fast_button.clicked.connect
		( SigC::slot( this , &Step_Controller::forward_very_fast ) );

	forward_highlight_button.clicked.connect
		( SigC::slot( this , &Step_Controller::forward_highlight ) );

	live_log_button.clicked.connect
		( SigC::slot( this , &Step_Controller::live_log_toggle ) );

	time_set_entry.activate.connect
		( SigC::slot( this , &Step_Controller::time_set_entry_input) );

	this -> pack_start( backward_highlight_button );
	this -> pack_start( backward_very_fast_button );
	this -> pack_start( backward_fast_button );
	this -> pack_start( backward_button );
	this -> pack_start( backward_step_button );
	this -> pack_start( stop_button );
	this -> pack_start( forward_step_button );
	this -> pack_start( forward_button );
	this -> pack_start( forward_fast_button );
	this -> pack_start( forward_very_fast_button );
	this -> pack_start( forward_highlight_button );
	this -> pack_start( live_log_button );
	this -> pack_start( time_set_entry );

	this -> show_all();
}

Step_Controller::~Step_Controller()
{
}

void   Step_Controller::display()
{
}


#include  "time_controller.h"

void   Step_Controller::backward_highlight()
{
	time_controller.set_backward_highlight();
}

void   Step_Controller::backward_very_fast()
{
	time_controller.set_backward_very_fast();
}

void   Step_Controller::backward_fast()
{
	time_controller.set_backward_fast();
}

void   Step_Controller::backward()
{
	time_controller.set_backward();
}

void   Step_Controller::backward_step()
{
	time_controller.set_backward_step();
}

void   Step_Controller::stop()
{
	time_controller.set_stop();
}

void   Step_Controller::forward_step()
{
	time_controller.set_forward_step();
}

void   Step_Controller::forward()
{
	time_controller.set_forward();
}

void   Step_Controller::forward_fast()
{
	time_controller.set_forward_fast();
}

void   Step_Controller::forward_very_fast()
{
	time_controller.set_forward_very_fast();
}

void   Step_Controller::forward_highlight()
{
	time_controller.set_forward_highlight();
}

void   Step_Controller::live_log_toggle()
{
	time_controller.set_toggle_live_log();
}

void   Step_Controller::time_set_entry_input()
{
	char *	c;
	glong	t;
	t = std::strtol( time_set_entry.get_text().c_str() , &c , 10 );

	if ( *c != '\0' || t == LONG_MIN || t == LONG_MAX )
	{
		return;
	}

	time_set_entry.set_text( "" );

	time_controller.set_time( t );
}
