#ifndef	   TIME_CONTROLLER_H_INCLUDED
#define	   TIME_CONTROLLER_H_INCLUDED

// Author:		H. Shimora
// Created:		Feb 22 2001
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Feb 22 2001    base version.
//
//

#include  "active_repository.h"
#include  "event_timer.h"
#include  "ref_count_ptr.h"
#include  <queue>

class  Abstract_Soccer_Viewer
{
public:
		 Abstract_Soccer_Viewer() {}
	virtual	~Abstract_Soccer_Viewer() {}

	virtual	void	display() = 0;
};


class  Time_Controller
{
public:
	static	const int	FAST_SIMULATOR_STEP_MSEC;
	static	const int	VERY_FAST_SIMULATOR_STEP_MSEC;
	static	const int	N_STEP_DELAY;

private:
	class  Timer_Callback : public Event_Timer::Callback
	{
	private:
		Time_Controller &  tc;

	public:
		Timer_Callback( Time_Controller &  tc );
		gint	operator() ();
	};

	class  Active_Repository_Changed_Event_Receiver
		: public Active_Repository::Changed_Event_Receiver
	{
	private:
		Time_Controller &  tc;

	public:
		Active_Repository_Changed_Event_Receiver
					( Time_Controller &  tc );

		virtual	void	notify();
	};

private:
	Abstract_Soccer_Viewer &	viewer;

	Active_Repository &		active_repository;

	ref_count_ptr<Active_Repository_Changed_Event_Receiver>
					repository_changed_receiver;

	Timer_Callback			callback;
	Event_Timer			updater;


private:
	std::queue<long>	prev_server_time_queue;

	bool	live_mode_flag;
	long	log_count;
	int	log_wait;
	bool	log_forward;

private:
	void	forward_log();
	void	backward_log();
	void	stop_log();
	void	set_log( long  t );

	ref_count_ptr<const View_Snapshot>	current_snapshot() const;
	ref_count_ptr<const View_Snapshot>	log_snapshot() const;

public:
	Time_Controller( Active_Repository &  rep ,
			 Abstract_Soccer_Viewer &  v ,
			 bool  log_file_source );

	int	timed_out();
	void	repository_changed();


	bool	live_mode() const;

	void	set_forward_very_fast();
	void	set_forward_fast();
	void	set_forward();
	void	set_forward_step();
	void	set_stop();
	void	set_backward_step();
	void	set_backward();
	void	set_backward_fast();
	void	set_backward_very_fast();

	void	set_forward_highlight();
	void	set_backward_highlight();

	void	set_toggle_live_log();
	void	set_live_mode();

	void	set_time( long  t );


	long	snapshot_time() const;


	int	send_start();
	int	send_foul( double  x ,  double  y ,  S_Side_LR  side ,
			   bool  change_to_live_mode );

	bool	have_server_process_id() const;
	void	kill_server();

	bool	monitor_connection_responsive() const;
	bool	game_over() const;

	const SServer_Param &	sserver_param() const;

	void	set_auto_drop( bool  f );
	bool	auto_drop_mode() const;
	long	auto_drop_rest_step() const;
	long	auto_drop_rest_second() const;

	void	set_auto_kick_off( bool  f );
	bool	auto_kick_off_mode() const;
	long	auto_kick_off_rest_step() const;
	long	auto_kick_off_rest_second() const;

	void	set_auto_quit( bool  f );
	bool	auto_quit_mode() const;
	long	auto_quit_rest_step() const;
	long	auto_quit_rest_second() const;

	ref_count_ptr<const View_Snapshot>	snapshot() const;
	ref_count_ptr<const Monitor_View_Data>	monitor_view_data() const;
	ref_count_ptr<const Debug_Client_Field_Recog>
						client_view_data
						  ( const  S_Side_LR &  side ,
						    int  player_number ) const;
};


#endif	/* TIME_CONTROLLER_H_INCLUDED */
